/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.client.handler;

import com.feingto.iot.client.service.IMqttMessage;
import com.feingto.iot.common.handler.DefaultSimpleChannelHandler;
import com.feingto.iot.common.model.mqtt.MqttConnectOptions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.Optional;

@ChannelHandler.Sharable
public abstract class DefaultMqttChannelHandler
extends DefaultSimpleChannelHandler<MqttMessage> {
    private final MqttConnectOptions options;
    private final IMqttMessage mqttMessageService;

    public DefaultMqttChannelHandler(MqttConnectOptions options, IMqttMessage mqttMessageService) {
        this.options = options;
        this.mqttMessageService = mqttMessageService;
    }

    public void handleMessage(ChannelHandlerContext ctx, MqttMessage msg) {
        Optional.ofNullable(msg.fixedHeader()).ifPresent(fixedHeader -> {
            switch (fixedHeader.messageType()) {
                case CONNACK: {
                    this.mqttMessageService.connack((MqttConnAckMessage)msg);
                    break;
                }
                case PUBLISH: {
                    this.mqttMessageService.publish(ctx.channel(), msg);
                    break;
                }
                case PUBACK: {
                    this.mqttMessageService.puback(ctx.channel(), msg);
                    break;
                }
                case PUBREC: {
                    this.mqttMessageService.pubrec(ctx.channel(), msg);
                    break;
                }
                case PUBREL: {
                    this.mqttMessageService.pubrel(ctx.channel(), msg);
                    break;
                }
                case PUBCOMP: {
                    this.mqttMessageService.pubcomp(ctx.channel(), msg);
                    break;
                }
                case SUBACK: {
                    this.mqttMessageService.suback(ctx.channel(), (MqttSubAckMessage)msg);
                    break;
                }
                case UNSUBACK: {
                    this.mqttMessageService.unsubBack(ctx.channel(), msg);
                    break;
                }
            }
        });
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.mqttMessageService.connect(ctx.channel(), this.options);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state() == IdleState.WRITER_IDLE) {
                this.mqttMessageService.pingreq(ctx.channel());
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

