/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.client.service;

import com.feingto.iot.client.service.IMqttMessage;
import com.feingto.iot.common.model.mqtt.MqttConnectOptions;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.service.ResponseCallback;
import com.feingto.iot.common.service.mqtt.MessageRequest;
import com.feingto.iot.common.service.mqtt.MessageResponse;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMessageService
implements IMqttMessage {
    private static final Logger log = LoggerFactory.getLogger(MqttMessageService.class);
    private ResponseCallback<SendMessage> callback;

    @Override
    public void connect(Channel channel, MqttConnectOptions options) {
        MessageRequest.connect((Channel)channel, (MqttConnectOptions)options);
    }

    @Override
    public void connack(MqttConnAckMessage msg) {
        MqttConnAckVariableHeader mqttConnAckVariableHeader = msg.variableHeader();
        switch (mqttConnAckVariableHeader.connectReturnCode()) {
            case CONNECTION_ACCEPTED: {
                break;
            }
            case CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD: {
                log.error("\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef");
                break;
            }
            case CONNECTION_REFUSED_IDENTIFIER_REJECTED: {
                log.error("clientId\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25");
                break;
            }
            case CONNECTION_REFUSED_SERVER_UNAVAILABLE: {
                log.error("\u670d\u52a1\u4e0d\u53ef\u7528");
                break;
            }
            case CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION: {
                log.error("mqtt\u7248\u672c\u4e0d\u53ef\u7528");
                break;
            }
            case CONNECTION_REFUSED_NOT_AUTHORIZED: {
                log.error("\u672a\u6388\u6743\u8fde\u63a5");
            }
        }
    }

    @Override
    public void publish(Channel channel, MqttMessage msg) {
        MqttFixedHeader fixedHeader = msg.fixedHeader();
        MqttPublishMessage message = (MqttPublishMessage)msg;
        MqttPublishVariableHeader variableHeader = message.variableHeader();
        if (this.callback != null) {
            this.callback.onResponse((Object)SendMessage.newInstance((MqttPublishMessage)message));
        }
        switch (fixedHeader.qosLevel()) {
            case AT_MOST_ONCE: {
                break;
            }
            case AT_LEAST_ONCE: {
                MessageResponse.puback((Channel)channel, (MqttMessageType)MqttMessageType.PUBACK, (MqttQoS)MqttQoS.AT_MOST_ONCE, (int)variableHeader.packetId());
                break;
            }
            case EXACTLY_ONCE: {
                MessageResponse.puback((Channel)channel, (MqttMessageType)MqttMessageType.PUBREC, (MqttQoS)MqttQoS.AT_LEAST_ONCE, (int)variableHeader.packetId());
            }
        }
    }

    @Override
    public void puback(Channel channel, MqttMessage msg) {
    }

    @Override
    public void pubrec(Channel channel, MqttMessage msg) {
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)msg.variableHeader();
        MessageResponse.pubrel((Channel)channel, (int)variableHeader.messageId());
    }

    @Override
    public void pubrel(Channel channel, MqttMessage msg) {
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)msg.variableHeader();
        MessageResponse.pubcomp((Channel)channel, (int)variableHeader.messageId());
    }

    @Override
    public void pubcomp(Channel channel, MqttMessage msg) {
    }

    @Override
    public void suback(Channel channel, MqttSubAckMessage msg) {
    }

    @Override
    public void unsubBack(Channel channel, MqttMessage msg) {
    }

    @Override
    public void pingreq(Channel channel) {
        MessageRequest.pingreq((Channel)channel);
    }

    @Override
    public void disconnect(Channel channel) {
        MessageRequest.disconnect((Channel)channel);
    }

    @Override
    public void exceptionCaught(Throwable cause) {
        cause.printStackTrace();
        if (this.callback != null) {
            this.callback.onFailure(cause);
        }
    }

    public void setCallback(ResponseCallback<SendMessage> callback) {
        this.callback = callback;
    }
}

