/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.cache;

import com.feingto.iot.common.model.mqtt.SendMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCache;
import org.springframework.util.Assert;

public class MessageCache {
    private static MessageCache instance;
    private static IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> igniteCache;

    public static MessageCache getInstance(IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> cache) {
        if (instance == null) {
            instance = new MessageCache();
            igniteCache = cache;
        }
        return instance;
    }

    public List<SendMessage> getMessages(String clientId) {
        ArrayList<SendMessage> messages = new ArrayList<SendMessage>();
        igniteCache.forEach(entry -> {
            if (clientId.equals(entry.getKey())) {
                messages.addAll(((ConcurrentHashMap)entry.getValue()).values());
            }
        });
        return messages;
    }

    public SendMessage get(String clientId, Integer messageId) {
        return this.getMessages(clientId).stream().filter(message -> messageId.equals(message.id())).findFirst().orElse(null);
    }

    public void put(String clientId, SendMessage message) {
        Assert.notNull((Object)clientId, (String)"The clientId parameter cannot be empty");
        ConcurrentHashMap map = igniteCache.containsKey((Object)clientId) ? (ConcurrentHashMap)igniteCache.get((Object)clientId) : new ConcurrentHashMap();
        map.putIfAbsent(message.id(), message);
        igniteCache.put((Object)clientId, (Object)map);
    }

    public void remove(String clientId) {
        Assert.notNull((Object)clientId, (String)"The clientId parameter cannot be empty");
        igniteCache.forEach(entry -> {
            if (clientId.equals(entry.getKey())) {
                igniteCache.remove((Object)clientId);
            }
        });
    }

    public void remove(String clientId, Integer messageId) {
        Assert.notNull((Object)clientId, (String)"The clientId parameter cannot be empty");
        Assert.notNull((Object)messageId, (String)"The messageId parameter cannot be empty");
        Optional.ofNullable(igniteCache.get((Object)clientId)).ifPresent(map -> {
            map.remove(messageId);
            if (map.size() > 0) {
                igniteCache.put((Object)clientId, map);
            } else {
                igniteCache.remove((Object)clientId);
            }
        });
    }
}

