/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.codec;

import com.feingto.iot.common.bootstrap.SimpleHandlerLoader;
import com.feingto.iot.server.codec.RouteChannelDecoder;
import com.feingto.iot.server.handler.HttpRequestHandler;
import com.feingto.iot.server.handler.TcpMessageHandler;
import com.feingto.iot.server.handler.WebSocketMessageHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.internal.AppendableCharSequence;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class RouteChannelDecoder
extends ByteToMessageDecoder {
    private final LineParser lineParser = new LineParser(new AppendableCharSequence(128), 4096);

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        List channelHandlers;
        if (this.skipControlCharacters(in)) {
            channelHandlers = SimpleHandlerLoader.getHttpChannelHandlers();
            channelHandlers.add(new WebSocketMessageHandler());
            channelHandlers.add(new HttpRequestHandler());
        } else {
            channelHandlers = SimpleHandlerLoader.getTcpHandlers();
            channelHandlers.add(new IdleStateHandler(2L, 0L, 0L, TimeUnit.MINUTES));
            channelHandlers.add(new TcpMessageHandler());
        }
        channelHandlers.forEach(handler -> ctx.pipeline().addLast(new ChannelHandler[]{handler}));
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private boolean skipControlCharacters(ByteBuf buffer) {
        buffer.markReaderIndex();
        buffer.markWriterIndex();
        boolean skiped = false;
        int wIdx = buffer.writerIndex();
        int rIdx = buffer.readerIndex();
        while (wIdx > rIdx) {
            short c;
            if (Character.isISOControl(c = buffer.getUnsignedByte(rIdx++)) || Character.isWhitespace(c)) continue;
            --rIdx;
            skiped = true;
            break;
        }
        if (skiped && this.lineParser.parse(buffer) == null) {
            skiped = false;
        }
        buffer.readerIndex(rIdx);
        buffer.resetReaderIndex();
        buffer.resetWriterIndex();
        return skiped;
    }
}

