/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler;

import com.feingto.iot.common.handler.DefaultSimpleChannelHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@ChannelHandler.Sharable
public class HttpRequestHandler
extends DefaultSimpleChannelHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestHandler.class);
    private String fileUri = "/";

    public void handleMessage(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        if (!request.decoderResult().isSuccess()) {
            HttpRequestHandler.sendError((ChannelHandlerContext)ctx, (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST);
            return;
        }
        if (request.method() != HttpMethod.GET) {
            HttpRequestHandler.sendError((ChannelHandlerContext)ctx, (HttpResponseStatus)HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        String uri = request.uri();
        String path = this.sanitizeUri(uri);
        if (path == null) {
            HttpRequestHandler.sendError((ChannelHandlerContext)ctx, (HttpResponseStatus)HttpResponseStatus.FORBIDDEN);
            return;
        }
        File file = new File(path);
        if (file.isHidden() || !file.exists()) {
            HttpRequestHandler.sendError((ChannelHandlerContext)ctx, (HttpResponseStatus)HttpResponseStatus.NOT_FOUND);
            return;
        }
        if (file.isDirectory()) {
            if (uri.endsWith("/")) {
                HttpRequestHandler.renderHtml((ChannelHandlerContext)ctx, (File)file, (boolean)uri.equals(this.fileUri));
            } else {
                HttpRequestHandler.sendRedirect((ChannelHandlerContext)ctx, (String)(uri + "/"));
            }
            return;
        }
        if (!file.isFile()) {
            HttpRequestHandler.sendError((ChannelHandlerContext)ctx, (HttpResponseStatus)HttpResponseStatus.FORBIDDEN);
            return;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        long fileLength = randomAccessFile.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
        HttpRequestHandler.setContentTypeHeader((HttpResponse)response, (File)file);
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ctx.write((Object)response);
        ctx.write((Object)new ChunkedFile(randomAccessFile, 0L, fileLength, 8192), (ChannelPromise)ctx.newProgressivePromise()).addListener((GenericFutureListener)new /* Unavailable Anonymous Inner Class!! */);
        if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
            ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        if (!uri.startsWith(this.fileUri) || !uri.startsWith("/")) {
            return null;
        }
        if ((uri = uri.replace('/', File.separatorChar)).contains(File.separator + '.') || uri.contains('.' + File.separator) || uri.startsWith(".") || uri.endsWith(".") || Pattern.compile(".*[<>&\"].*").matcher(uri).matches()) {
            return null;
        }
        return System.getProperty("user.dir") + File.separator + uri;
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mimetypesFileTypeMap.getContentType(file.getPath()));
    }

    private static void sendRedirect(ChannelHandlerContext ctx, String newUri) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
        response.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)newUri);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)status.toString(), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html;charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void renderHtml(ChannelHandlerContext ctx, File dir, boolean isRoot) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html;charset=UTF-8");
        String dirPath = dir.getPath();
        StringBuilder buf = new StringBuilder();
        buf.append("<!DOCTYPE html>\r\n");
        buf.append("<html><head><meta charset=\"UTF-8\"><title>");
        buf.append(dirPath);
        buf.append("</title></head><body>\r\n");
        buf.append("<h3>");
        buf.append(dirPath).append(":");
        buf.append("</h3>\r\n");
        buf.append("<ul>");
        if (!isRoot) {
            buf.append("<li><a href=\"../\">\u4e0a\u4e00\u7ea7</a></li>\r\n");
        }
        Arrays.stream(dir.listFiles()).filter(file -> !file.isHidden() && file.canRead()).map(File::getName).filter(name -> Pattern.compile("[A-Za-z0-9][-_A-Za-z0-9\\.]*").matcher((CharSequence)name).matches()).forEach(name -> {
            buf.append("<li><a href=\"");
            buf.append((String)name);
            buf.append("\">");
            buf.append((String)name);
            buf.append("</a></li>\r\n");
        });
        buf.append("</ul></body></html>\r\n");
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)buf, (Charset)CharsetUtil.UTF_8);
        response.content().writeBytes(buffer);
        buffer.release();
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void setFileUri(String fileUri) {
        this.fileUri = fileUri;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

