/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.service.mqtt.MessageResponse;
import com.feingto.iot.server.cache.MessageCache;
import com.feingto.iot.server.cache.RetainedCache;
import com.feingto.iot.server.cache.SubscribeCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import com.feingto.iot.server.handler.mqtt.PublishHandler;
import com.feingto.iot.server.service.PushService;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import org.apache.ignite.IgniteCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishHandler
extends BaseMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(PublishHandler.class);
    private final PushService pushService;

    public PublishHandler(PushService pushService) {
        super(MqttMessageType.PUBLISH);
        this.pushService = pushService;
    }

    public void handle(Channel channel, Object object) {
        MqttPublishMessage msg = (MqttPublishMessage)object;
        MqttFixedHeader fixedHeader = msg.fixedHeader();
        MqttPublishVariableHeader variableHeader = msg.variableHeader();
        SendMessage sendMessage = SendMessage.newInstance((MqttPublishMessage)msg);
        if (sendMessage.retain()) {
            log.debug(">>> save retain message on {}", (Object)sendMessage.topic());
            RetainedCache.getInstance((IgniteCache)this.igniteRetained).put(sendMessage.topic(), sendMessage);
        }
        sendMessage.retain(false);
        switch (1.$SwitchMap$io$netty$handler$codec$mqtt$MqttQoS[fixedHeader.qosLevel().ordinal()]) {
            case 1: {
                this.pushService.internalSend(sendMessage);
                break;
            }
            case 2: {
                this.storeMessage(sendMessage, MqttMessageType.PUBLISH);
                this.pushService.internalSend(sendMessage);
                MessageResponse.puback((Channel)channel, (MqttMessageType)MqttMessageType.PUBACK, (MqttQoS)MqttQoS.AT_MOST_ONCE, (int)variableHeader.packetId());
                break;
            }
            case 3: {
                this.storeMessage(sendMessage, MqttMessageType.PUBREC);
                MessageResponse.puback((Channel)channel, (MqttMessageType)MqttMessageType.PUBREC, (MqttQoS)MqttQoS.AT_LEAST_ONCE, (int)variableHeader.packetId());
                break;
            }
        }
    }

    private void storeMessage(SendMessage message, MqttMessageType type) {
        SubscribeCache.getInstance((IgniteCache)this.igniteSubscribe).get(message.topic()).forEach(subscribe -> MessageCache.getInstance((IgniteCache)this.igniteMessage).put(subscribe.clientId(), message.type(type)));
    }
}

