/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.Constants;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.service.mqtt.MessageResponse;
import com.feingto.iot.server.cache.MessageCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import com.feingto.iot.server.service.PushService;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import org.apache.ignite.IgniteCache;

public class PubrelHandler
extends BaseMessageHandler {
    private final PushService pushService;

    public PubrelHandler(PushService pushService) {
        super(MqttMessageType.PUBREL);
        this.pushService = pushService;
    }

    public void handle(Channel channel, Object object) {
        MqttMessage msg = (MqttMessage)object;
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)msg.variableHeader();
        this.pushService.internalSend(SendMessage.newInstance((MqttPublishMessage)((MqttPublishMessage)msg)));
        MessageCache.getInstance((IgniteCache)this.igniteMessage).remove((String)channel.attr(Constants.KEY_CLIENT_ID).get(), Integer.valueOf(variableHeader.messageId()));
        MessageResponse.pubcomp((Channel)channel, (int)variableHeader.messageId());
    }
}

