/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.serialize;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.feingto.iot.server.serialize.JSONObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class JSON {
    private static JSON instance;
    private JSONObjectMapper objectMapper = new JSONObjectMapper();

    public static JSON getInstance() {
        if (null == instance) {
            instance = new JSON();
        }
        return instance;
    }

    public JSON objectMapper(JSONObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public JSON filter(String filterName, String ... properties) {
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter(filterName, SimpleBeanPropertyFilter.serializeAllExcept((String[])properties));
        this.objectMapper.setFilterProvider((FilterProvider)filterProvider);
        return this;
    }

    public ObjectNode JSONObject() {
        return this.objectMapper.createObjectNode();
    }

    public ArrayNode JSONArray() {
        return this.objectMapper.createArrayNode();
    }

    public JsonNode read(String json) {
        return StringUtils.isNotBlank((CharSequence)json) ? this.objectMapper.readTree(json) : this.JSONObject();
    }

    public JsonNode read(byte[] bytes) {
        return this.objectMapper.readTree(bytes);
    }

    public JsonNode read(InputStream inputStream) {
        return this.objectMapper.readTree(inputStream);
    }

    public String obj2json(Object pojo) {
        return pojo != null ? this.objectMapper.writeValueAsString(pojo) : "";
    }

    public <T> T json2pojo(String json, Class<T> clazz) {
        return (T)(StringUtils.isNotBlank((CharSequence)json) ? this.objectMapper.readValue(json, clazz) : null);
    }

    public <T> Map<String, T> json2map(String json, Class<T> clazz) throws Exception {
        Map map = (Map)this.objectMapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        HashMap result = new HashMap();
        map.forEach((key, value) -> result.put(key, this.object2pojo(value, clazz)));
        return result;
    }

    public <T> List<T> json2list(String json, Class<T> clazz) {
        return StringUtils.isNotBlank((CharSequence)json) ? (List)this.objectMapper.readValue(json, this.getCollectionType(new Class[]{clazz})) : new ArrayList();
    }

    public <T> T object2pojo(Object object, Class<T> clazz) {
        return (T)this.objectMapper.convertValue(object, clazz);
    }

    public Map object2Map(Object object) {
        return (Map)this.objectMapper.convertValue(object, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public <T> List<T> object2list(Object object, Class<T> clazz) {
        return ((List)this.objectMapper.convertValue(object, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).stream().map(map -> this.object2pojo(map, clazz)).collect(Collectors.toList());
    }

    public <T> String format(T entity) {
        return entity != null ? this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(entity) : "";
    }

    public String reduce(List<JsonNode> list) {
        return ((JsonNode)list.stream().reduce((l, r) -> {
            ObjectNode node = this.JSONObject();
            l.fields().forEachRemaining(it -> node.set((String)it.getKey(), (JsonNode)it.getValue()));
            r.fields().forEachRemaining(it -> node.set((String)it.getKey(), (JsonNode)it.getValue()));
            return node;
        }).orElse(this.JSONObject())).toString();
    }

    private JavaType getCollectionType(Class<?> ... elementClasses) {
        return this.objectMapper.getTypeFactory().constructParametricType(ArrayList.class, (Class[])elementClasses);
    }
}

