/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server;

import com.feingto.iot.common.model.enums.Protocol;
import com.feingto.iot.server.bootstrap.IoTServerBootstrap;
import com.feingto.iot.server.config.properties.NettyProperties;
import javax.annotation.Resource;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;

@SpringBootApplication
public class IoTServer
implements CommandLineRunner {
    @Resource
    private NettyProperties config;

    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).sources(new Class[]{IoTServer.class}).run(args);
    }

    public void run(String ... args) {
        if (this.config.getPort() > 0) {
            new Thread(() -> new IoTServerBootstrap().protocol(Protocol.TCP).port(this.config.getPort()).config(this.config).run()).start();
        }
        if (this.config.getWsPort() > 0) {
            new Thread(() -> new IoTServerBootstrap().protocol(Protocol.WS).port(this.config.getWsPort()).config(this.config).run()).start();
        }
        if (this.config.getMqtt().getPort() > 0) {
            new Thread(() -> new IoTServerBootstrap().protocol(Protocol.MQTT).port(this.config.getMqtt().getPort()).config(this.config).run()).start();
        }
        if (this.config.getMqtt().getWsPort() > 0) {
            new Thread(() -> new IoTServerBootstrap().protocol(Protocol.MQTT_WS).port(this.config.getMqtt().getWsPort()).config(this.config).run()).start();
        }
    }
}

