/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.cache;

import com.feingto.iot.common.model.custom.ChartMessage;
import com.feingto.iot.common.model.custom.Message;
import com.feingto.iot.common.model.custom.MessageChannel;
import com.feingto.iot.common.util.DateKit;
import com.feingto.iot.server.serialize.JSON;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ChannelCache {
    private static ChannelCache instance;
    private static ConcurrentHashMap<String, MessageChannel> channelCache;

    public static ChannelCache getInstance() {
        if (instance == null) {
            instance = new ChannelCache();
        }
        return instance;
    }

    public MessageChannel get(String key) {
        return (MessageChannel)channelCache.get(key);
    }

    public void put(String key, MessageChannel message) {
        Assert.notNull((Object)key, (String)"The key parameter cannot be empty");
        channelCache.put(key, message);
    }

    public void remove(String key) {
        Assert.notNull((Object)key, (String)"The key parameter cannot be empty");
        channelCache.remove(key);
    }

    public void push(Message message) {
        channelCache.values().forEach(mc -> mc.channel().writeAndFlush((Object)message));
    }

    public void push(ChartMessage message) {
        TextWebSocketFrame text = new TextWebSocketFrame(JSON.getInstance().obj2json((Object)message.timestamp(DateKit.nowUTC())));
        if (StringUtils.isEmpty((Object)message.to())) {
            channelCache.values().stream().filter(mc -> !mc.username().equals(message.from())).forEach(mc -> mc.channel().writeAndFlush((Object)text));
        } else {
            channelCache.values().stream().filter(mc -> mc.username().equals(message.to())).forEach(mc -> mc.channel().writeAndFlush((Object)text));
        }
    }

    static {
        channelCache = new ConcurrentHashMap();
    }
}

