/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.cache;

import com.feingto.iot.common.model.mqtt.SendMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MessageCache {
    private static final Logger log = LoggerFactory.getLogger(MessageCache.class);
    private static MessageCache instance;
    private static IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> igniteCache;

    public static MessageCache getInstance(IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> cache) {
        if (instance == null) {
            instance = new MessageCache();
            igniteCache = cache;
        }
        return instance;
    }

    public List<SendMessage> findBylientId(String clientId) {
        ArrayList<SendMessage> messages = new ArrayList<SendMessage>();
        igniteCache.forEach(entry -> {
            if (clientId.equals(entry.getKey())) {
                messages.addAll(((ConcurrentHashMap)entry.getValue()).values());
            }
        });
        log.debug(">>> client\uff1a[{}] match {} messages", (Object)clientId, (Object)messages.size());
        return messages;
    }

    public List<SendMessage> findByMessageId(Integer messageId) {
        ArrayList<SendMessage> messages = new ArrayList<SendMessage>();
        igniteCache.forEach(entry -> {
            if (((ConcurrentHashMap)entry.getValue()).containsKey(messageId)) {
                messages.add((SendMessage)((ConcurrentHashMap)entry.getValue()).get(messageId));
            }
        });
        log.debug(">>> message\uff1a[{}] match {} messages", (Object)messageId, (Object)messages.size());
        return messages;
    }

    public SendMessage get(String clientId, Integer messageId) {
        return this.findBylientId(clientId).stream().filter(message -> messageId.equals(message.id())).findFirst().orElse(null);
    }

    public void put(String clientId, SendMessage message) {
        Assert.notNull((Object)clientId, (String)"The clientId parameter cannot be empty");
        ConcurrentHashMap map = igniteCache.containsKey((Object)clientId) ? (ConcurrentHashMap)igniteCache.get((Object)clientId) : new ConcurrentHashMap();
        log.debug(">>> client\uff1a[{}] save message\uff1a[{}]", (Object)clientId, (Object)message.id());
        map.putIfAbsent(message.id(), message);
        igniteCache.put((Object)clientId, (Object)map);
    }

    public void remove(String clientId) {
        Assert.notNull((Object)clientId, (String)"The clientId parameter cannot be empty");
        igniteCache.forEach(entry -> {
            if (clientId.equals(entry.getKey())) {
                igniteCache.remove((Object)clientId);
            }
        });
    }

    public void remove(Integer messageId) {
        igniteCache.forEach(entry -> {
            ConcurrentHashMap map = (ConcurrentHashMap)entry.getValue();
            if (map.containsKey(messageId)) {
                map.remove(messageId);
                if (map.size() > 0) {
                    igniteCache.put(entry.getKey(), (Object)map);
                } else {
                    igniteCache.remove(entry.getKey());
                }
            }
        });
    }

    public void remove(String clientId, Integer messageId) {
        Assert.notNull((Object)clientId, (String)"The clientId parameter cannot be empty");
        Assert.notNull((Object)messageId, (String)"The messageId parameter cannot be empty");
        Optional.ofNullable(igniteCache.get((Object)clientId)).ifPresent(map -> {
            map.remove(messageId);
            if (map.size() > 0) {
                igniteCache.put((Object)clientId, map);
            } else {
                igniteCache.remove((Object)clientId);
            }
        });
    }
}

