/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.cache;

import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.util.MatchingKit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCache;
import org.springframework.util.Assert;

public class RetainedCache {
    private static RetainedCache instance;
    private static IgniteCache<String, SendMessage> igniteCache;

    public static RetainedCache getInstance(IgniteCache<String, SendMessage> cache) {
        if (instance == null) {
            instance = new RetainedCache();
            igniteCache = cache;
        }
        return instance;
    }

    public SendMessage get(String topic) {
        AtomicReference message = new AtomicReference();
        igniteCache.forEach(entry -> {
            if (MatchingKit.ofTopic((String)topic, (String)((String)entry.getKey()))) {
                message.set(igniteCache.get(entry.getKey()));
            }
        });
        return (SendMessage)message.get();
    }

    public void put(String topic, SendMessage message) {
        Assert.notNull((Object)topic, (String)"The topic parameter cannot be empty");
        if (message.payload().length == 0) {
            this.remove(topic);
        } else {
            igniteCache.put((Object)topic, (Object)message);
        }
    }

    public void remove(String topic) {
        Assert.notNull((Object)topic, (String)"The topic parameter cannot be empty");
        igniteCache.remove((Object)topic);
    }
}

