/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.cache;

import com.feingto.iot.common.model.mqtt.SubscribeMessage;
import com.feingto.iot.common.util.MatchingKit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SubscribeCache {
    private static final Logger log = LoggerFactory.getLogger(SubscribeCache.class);
    private static SubscribeCache instance;
    private static IgniteCache<String, ConcurrentHashMap<String, SubscribeMessage>> igniteCache;

    public static SubscribeCache getInstance(IgniteCache<String, ConcurrentHashMap<String, SubscribeMessage>> cache) {
        if (instance == null) {
            instance = new SubscribeCache();
            igniteCache = cache;
        }
        return instance;
    }

    public List<SubscribeMessage> findByTopic(String topic) {
        ArrayList<SubscribeMessage> subscribes = new ArrayList<SubscribeMessage>();
        igniteCache.forEach(entry -> {
            if (MatchingKit.ofTopic((String)((String)entry.getKey()), (String)topic)) {
                subscribes.addAll(((ConcurrentHashMap)entry.getValue()).values());
            }
        });
        log.debug(">>> topic\uff1a[{}] match {} subscribes", (Object)topic, (Object)subscribes.size());
        return subscribes;
    }

    public List<SubscribeMessage> findByClientId(String clientId) {
        ArrayList<SubscribeMessage> subscribes = new ArrayList<SubscribeMessage>();
        igniteCache.forEach(entry -> {
            if (((ConcurrentHashMap)entry.getValue()).containsKey(clientId)) {
                subscribes.add((SubscribeMessage)((ConcurrentHashMap)entry.getValue()).get(clientId));
            }
        });
        log.debug(">>> client\uff1a[{}] match {} subscribes", (Object)clientId, (Object)subscribes.size());
        return subscribes;
    }

    public void put(String topic, SubscribeMessage message) {
        Assert.notNull((Object)topic, (String)"The topic parameter cannot be empty");
        ConcurrentHashMap map = igniteCache.containsKey((Object)topic) ? (ConcurrentHashMap)igniteCache.get((Object)topic) : new ConcurrentHashMap();
        map.put(message.clientId(), message);
        igniteCache.put((Object)topic, (Object)map);
    }

    public void remove(String clientId) {
        Assert.notNull((Object)clientId, (String)"The clientId parameter cannot be empty");
        igniteCache.forEach(entry -> {
            ConcurrentHashMap map = (ConcurrentHashMap)entry.getValue();
            if (map.containsKey(clientId)) {
                map.remove(clientId);
                if (map.size() > 0) {
                    igniteCache.put(entry.getKey(), (Object)map);
                } else {
                    igniteCache.remove(entry.getKey());
                }
            }
        });
    }

    public void remove(String topic, String clientId) {
        ConcurrentHashMap map;
        Assert.notNull((Object)topic, (String)"The topic parameter cannot be empty");
        Assert.notNull((Object)clientId, (String)"The clientId parameter cannot be empty");
        if (igniteCache.containsKey((Object)topic) && (map = (ConcurrentHashMap)igniteCache.get((Object)topic)).containsKey(clientId)) {
            map.remove(clientId);
            if (map.size() > 0) {
                igniteCache.put((Object)topic, (Object)map);
            } else {
                igniteCache.remove((Object)topic);
            }
        }
    }
}

