/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.config;

import com.feingto.iot.server.config.properties.IgniteProperties;
import java.util.Arrays;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.apache.ignite.spi.checkpoint.CheckpointSpi;
import org.apache.ignite.spi.checkpoint.cache.CacheCheckpointSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class IgniteAutoConfiguration {
    private static final String DEFAULT_CACHE_NAME = "iot-cache-checkpoint";
    private static final String CACHE_REGION = "iot-cache-region";
    private static final String DATA_REGION = "iot-data-region";
    private static final String CACHE_SUBSCRIBE = "iot-cache-subscribe";
    private static final String CACHE_RETAINED = "iot-cache-retained";
    private static final String CACHE_MESSAGE = "iot-cache-message";

    @Bean(value={"igniteProperties"})
    public IgniteProperties config() {
        return new IgniteProperties();
    }

    @Bean(value={"igniteCache"})
    public Ignite ignite() {
        IgniteProperties.Broker brokerConfig = this.config().getBroker();
        CacheCheckpointSpi spi = new CacheCheckpointSpi();
        spi.setCacheName(DEFAULT_CACHE_NAME);
        DataRegionConfiguration notPersistenceRegion = new DataRegionConfiguration().setPersistenceEnabled(false).setName(CACHE_REGION);
        if (this.config().getNotPersistenceInitialSize() > 0L) {
            notPersistenceRegion.setInitialSize(this.config().getNotPersistenceInitialSize() * 1024L * 1024L);
        }
        if (this.config().getNotPersistenceMaxSize() > 0L) {
            notPersistenceRegion.setMaxSize(this.config().getNotPersistenceMaxSize() * 1024L * 1024L);
        }
        DataRegionConfiguration persistenceRegion = new DataRegionConfiguration().setPersistenceEnabled(true).setName(DATA_REGION);
        if (this.config().getPersistenceInitialSize() > 0L) {
            persistenceRegion.setInitialSize(this.config().getPersistenceInitialSize() * 1024L * 1024L);
        }
        if (this.config().getPersistenceMaxSize() > 0L) {
            persistenceRegion.setMaxSize(this.config().getPersistenceMaxSize() * 1024L * 1024L);
        }
        TcpDiscoverySpi discoverySpi = new TcpDiscoverySpi().setLocalPortRange(5);
        if (brokerConfig.isEnableMulticastGroup()) {
            discoverySpi.setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryMulticastIpFinder().setMulticastGroup(brokerConfig.getMulticastGroup()));
        } else {
            discoverySpi.setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryVmIpFinder().setAddresses(Arrays.asList(brokerConfig.getStaticIpAddresses())));
        }
        Ignite ignite = Ignition.start((IgniteConfiguration)new IgniteConfiguration().setCheckpointSpi(new CheckpointSpi[]{spi}).setIgniteInstanceName(brokerConfig.getName()).setGridLogger((IgniteLogger)new Slf4jLogger(LoggerFactory.getLogger((String)"org.apache.ignite"))).setSystemThreadPoolSize(this.config().getThreadPoolSize()).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(notPersistenceRegion).setDataRegionConfigurations(new DataRegionConfiguration[]{persistenceRegion}).setStoragePath(this.config().getPersistenceStorePath())).setDiscoverySpi((DiscoverySpi)discoverySpi));
        ignite.cluster().active(true);
        return ignite;
    }

    @Bean(value={"igniteMessaging"})
    public IgniteMessaging igniteMessaging() {
        return this.ignite().message(this.ignite().cluster().forRemotes());
    }

    @Bean(value={"igniteSubscribe"})
    public IgniteCache igniteSubscribe() {
        return this.ignite().getOrCreateCache(new CacheConfiguration().setDataRegionName(DATA_REGION).setCacheMode(CacheMode.PARTITIONED).setName(CACHE_SUBSCRIBE));
    }

    @Bean(value={"igniteRetained"})
    public IgniteCache igniteRetained() {
        return this.ignite().getOrCreateCache(new CacheConfiguration().setDataRegionName(DATA_REGION).setCacheMode(CacheMode.PARTITIONED).setName(CACHE_RETAINED));
    }

    @Bean(value={"igniteMessage"})
    public IgniteCache igniteMessage() {
        return this.ignite().getOrCreateCache(new CacheConfiguration().setDataRegionName(DATA_REGION).setCacheMode(CacheMode.PARTITIONED).setName(CACHE_MESSAGE));
    }
}

