/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler;

import com.feingto.iot.common.handler.DefaultChannelInboundHandler;
import com.feingto.iot.common.model.custom.ChartMessage;
import com.feingto.iot.common.model.custom.MessageChannel;
import com.feingto.iot.server.cache.ChannelCache;
import com.feingto.iot.server.serialize.JSON;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketScheme;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WebSocketMessageHandler
extends DefaultChannelInboundHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketMessageHandler.class);
    private String wsUri = "/websocket";
    private WebSocketServerHandshaker handshake;

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ChannelCache.getInstance().remove(ctx.channel().id().asLongText());
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(ChannelHandlerContext ctx, Object msg) {
        boolean release = true;
        try {
            if (msg instanceof WebSocketFrame) {
                this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            } else if (msg instanceof FullHttpRequest) {
                FullHttpRequest request = (FullHttpRequest)msg;
                if (request.decoderResult().isSuccess() && this.wsUri.equals(request.uri()) && "websocket".equals(request.headers().get("Upgrade"))) {
                    this.webSocketHandshake(ctx, request);
                } else {
                    release = false;
                    ctx.fireChannelRead((Object)request);
                }
            }
        }
        finally {
            if (release) {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    private void webSocketHandshake(ChannelHandlerContext ctx, FullHttpRequest request) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(WebSocketScheme.WS + "://" + request.headers().get((CharSequence)HttpHeaderNames.HOST), null, false);
        this.handshake = wsFactory.newHandshaker((HttpRequest)request);
        if (this.handshake == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            this.handshake.handshake(ctx.channel(), request);
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshake.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (frame instanceof TextWebSocketFrame) {
            String text = ((TextWebSocketFrame)frame).text();
            log.debug("Received websocket message: " + text);
            ChartMessage message = (ChartMessage)JSON.getInstance().json2pojo(text, ChartMessage.class);
            ChannelCache.getInstance().put(ctx.channel().id().asLongText(), new MessageChannel().channel(ctx.channel()).username(message.from()));
            ChannelCache.getInstance().push(message);
        }
    }

    public void setWsUri(String wsUri) {
        this.wsUri = wsUri;
    }
}

