/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.Constants;
import com.feingto.iot.server.cache.SessionCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconnectHandler
extends BaseMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(DisconnectHandler.class);

    public DisconnectHandler() {
        super(MqttMessageType.DISCONNECT);
    }

    public void handle(Channel channel, Object object) {
        String clientId = (String)channel.attr(Constants.KEY_CLIENT_ID).get();
        Optional.ofNullable(SessionCache.getInstance().get(clientId)).ifPresent(sess -> {
            if (sess.willMessage() != null) {
                log.debug(">>> remove will message of the {}", (Object)clientId);
                sess.willMessage(null);
            }
            if (sess.cleanSession()) {
                log.debug(">>> clean session of the {}", (Object)clientId);
                this.cleanSession(clientId);
            }
            SessionCache.getInstance().remove(clientId);
        });
        channel.close();
    }
}

