/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.service.mqtt.MessageResponse;
import com.feingto.iot.server.cache.MessageCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import com.feingto.iot.server.service.PushService;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.Optional;
import org.apache.ignite.IgniteCache;

public class PubrelHandler
extends BaseMessageHandler {
    private final PushService pushService;

    public PubrelHandler(PushService pushService) {
        super(MqttMessageType.PUBREL);
        this.pushService = pushService;
    }

    public void handle(Channel channel, Object object) {
        MqttMessage msg = (MqttMessage)object;
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)msg.variableHeader();
        int messageId = variableHeader.messageId();
        Optional.ofNullable(MessageCache.getInstance((IgniteCache)this.igniteMessage).findByMessageId(Integer.valueOf(messageId))).ifPresent(messages -> messages.forEach(message -> {
            this.pushService.internalSend(message);
            MessageCache.getInstance((IgniteCache)this.igniteMessage).remove(Integer.valueOf(messageId));
        }));
        MessageResponse.pubcomp((Channel)channel, (int)messageId);
    }
}

