/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.server.util;

import com.feingto.iot.server.serialize.JSON;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javapns.devices.Device;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.Payload;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushNotificationPayload;
import javapns.notification.PushedNotification;
import javapns.notification.PushedNotifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Push {
    private static final Logger log = LoggerFactory.getLogger(Push.class);
    private static final String IOS_PATH = "aps_development_cer.p12";
    private static final String IOS_PASSWORD = "toonyoo";
    private static final boolean PRODUCTION = false;

    public String sendpush(String message, String ... deviceToken) {
        String result;
        InputStream path = Thread.currentThread().getContextClassLoader().getResourceAsStream(IOS_PATH);
        if (path == null) {
            return "01";
        }
        try {
            PushNotificationPayload payLoad = PushNotificationPayload.fromJSON((String)message);
            String alert = JSON.getInstance().read(message).get("aps").get("alert").asText();
            payLoad.addAlert(alert);
            payLoad.addBadge(1);
            payLoad.addSound("default");
            PushNotificationManager pushManager = new PushNotificationManager();
            pushManager.initializeConnection((AppleNotificationServer)new AppleNotificationServerBasicImpl((Object)path, IOS_PASSWORD, false));
            PushedNotifications notifications = new ArrayList();
            List<String> deviceList = Arrays.asList(deviceToken);
            if (deviceList.size() == 1) {
                log.debug(">>> push to {}: {}", (Object)deviceList.get(0), (Object)alert);
                PushedNotification notification = pushManager.sendNotification((Device)new BasicDevice(deviceList.get(0)), (Payload)payLoad, true);
                notifications.add(notification);
            } else {
                log.debug(">>> push to {}: {}", (Object)deviceToken, (Object)alert);
                ArrayList<BasicDevice> devices = new ArrayList<BasicDevice>();
                for (String device : deviceList) {
                    devices.add(new BasicDevice(device));
                }
                notifications = pushManager.sendNotifications((Payload)payLoad, devices);
            }
            List failedNotifications = PushedNotification.findFailedNotifications((List)notifications);
            List successfulNotifications = PushedNotification.findSuccessfulNotifications((List)notifications);
            int failed = failedNotifications.size();
            int successful = successfulNotifications.size();
            if (successful > 0 && failed == 0) {
                log.debug(">>> push successful {} times", (Object)successfulNotifications.size());
                result = "00";
            } else if (successful == 0 && failed > 0) {
                log.debug(">>> push failed {} times", (Object)failedNotifications.size());
                result = "01";
            } else if (successful == 0) {
                log.debug(">>> may be because of a serious error that no notification can be sent");
                result = "01";
            } else {
                log.debug(">>> push successful {} times, failed {} times", (Object)successfulNotifications.size(), (Object)failedNotifications.size());
                result = "02";
            }
            pushManager.stopConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "01";
        }
        return result;
    }

    public static void main(String[] args) {
        new Push().sendpush("{\"aps\": {\"alert\": \"This is a test message\"}}", new String[]{"76edc85fd2e6704b27974d774cc046d7e33a3440fd6f39ba18c729387e6c788a"});
    }
}

