/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client;

import java.util.Collections;
import java.util.Map;

public class AuthData {
    private final String token;
    private final long expires;
    private final String uid;
    private final String provider;
    private final Map<String, Object> providerData;
    private final Map<String, Object> auth;

    public AuthData(String token, long expires, String uid, String provider, Map<String, Object> auth, Map<String, Object> providerData) {
        this.token = token;
        this.expires = expires;
        this.uid = uid;
        this.provider = provider;
        this.providerData = providerData != null ? Collections.unmodifiableMap(providerData) : null;
        this.auth = auth != null ? Collections.unmodifiableMap(auth) : null;
    }

    public String getToken() {
        return this.token;
    }

    public long getExpires() {
        return this.expires;
    }

    public String getUid() {
        return this.uid;
    }

    public String getProvider() {
        return this.provider;
    }

    public Map<String, Object> getProviderData() {
        return this.providerData;
    }

    public Map<String, Object> getAuth() {
        return this.auth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthData authData = (AuthData)o;
        if (this.provider != null ? !this.provider.equals(authData.provider) : authData.provider != null) {
            return false;
        }
        if (this.providerData != null ? !this.providerData.equals(authData.providerData) : authData.providerData != null) {
            return false;
        }
        if (this.auth != null ? !this.auth.equals(authData.auth) : authData.auth != null) {
            return false;
        }
        if (this.token != null ? !this.token.equals(authData.token) : authData.token != null) {
            return false;
        }
        if (this.expires != authData.expires) {
            return false;
        }
        return !(this.uid != null ? !this.uid.equals(authData.uid) : authData.uid != null);
    }

    public int hashCode() {
        int result = this.token != null ? this.token.hashCode() : 0;
        result = 31 * result + (this.uid != null ? this.uid.hashCode() : 0);
        result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
        result = 31 * result + (this.providerData != null ? this.providerData.hashCode() : 0);
        result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AuthData{uid='" + this.uid + '\'' + ", provider='" + this.provider + '\'' + ", token='" + (this.token == null ? null : "***") + '\'' + ", expires='" + this.expires + '\'' + ", auth='" + this.auth + '\'' + ", providerData='" + this.providerData + '\'' + '}';
    }
}

