/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client;

import com.firebase.client.AuthData;
import com.firebase.client.Config;
import com.firebase.client.FirebaseApp;
import com.firebase.client.FirebaseError;
import com.firebase.client.FirebaseException;
import com.firebase.client.OnDisconnect;
import com.firebase.client.Query;
import com.firebase.client.Transaction;
import com.firebase.client.authentication.AuthenticationManager;
import com.firebase.client.core.CompoundWrite;
import com.firebase.client.core.Context;
import com.firebase.client.core.Path;
import com.firebase.client.core.Repo;
import com.firebase.client.core.RepoManager;
import com.firebase.client.core.ValidationPath;
import com.firebase.client.core.view.QueryParams;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.NodeUtilities;
import com.firebase.client.snapshot.PriorityUtilities;
import com.firebase.client.utilities.ParsedUrl;
import com.firebase.client.utilities.PushIdGenerator;
import com.firebase.client.utilities.Utilities;
import com.firebase.client.utilities.Validation;
import com.firebase.client.utilities.encoding.JsonHelpers;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class Firebase
extends Query {
    private static Config defaultConfig;

    private AuthenticationManager getAuthenticationManager() {
        return this.getRepo().getAuthenticationManager();
    }

    public Firebase(String url) {
        this(Utilities.parseUrl(url));
    }

    public Firebase(Repo repo, Path path) {
        super(repo, path);
    }

    Firebase(String url, Config config) {
        this(Utilities.parseUrl(url), config);
    }

    private Firebase(ParsedUrl parsedUrl, Config config) {
        super(RepoManager.getRepo(config, parsedUrl.repoInfo), parsedUrl.path, QueryParams.DEFAULT_PARAMS, false);
    }

    private Firebase(ParsedUrl parsedUrl) {
        this(parsedUrl, Firebase.getDefaultConfig());
    }

    public Firebase child(String pathString) {
        if (pathString == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.getPath().isEmpty()) {
            Validation.validateRootPathString(pathString);
        } else {
            Validation.validatePathString(pathString);
        }
        Path childPath = this.getPath().child(new Path(pathString));
        return new Firebase(this.repo, childPath);
    }

    public Firebase push() {
        String childNameStr = PushIdGenerator.generatePushChildName(this.repo.getServerTime());
        ChildKey childKey = ChildKey.fromString(childNameStr);
        return new Firebase(this.repo, this.getPath().child(childKey));
    }

    public void setValue(Object value) {
        this.setValueInternal(value, PriorityUtilities.parsePriority(null), null);
    }

    public void setValue(Object value, Object priority) {
        this.setValueInternal(value, PriorityUtilities.parsePriority(priority), null);
    }

    public void setValue(Object value, CompletionListener listener) {
        this.setValueInternal(value, PriorityUtilities.parsePriority(null), listener);
    }

    public void setValue(Object value, Object priority, CompletionListener listener) {
        this.setValueInternal(value, PriorityUtilities.parsePriority(priority), listener);
    }

    private void setValueInternal(Object value, Node priority, final CompletionListener listener) {
        Validation.validateWritablePath(this.getPath());
        ValidationPath.validateWithObject(this.getPath(), value);
        try {
            Object bouncedValue = JsonHelpers.getMapper().convertValue(value, Object.class);
            Validation.validateWritableObject(bouncedValue);
            final Node node = NodeUtilities.NodeFromJSON(bouncedValue, priority);
            this.repo.scheduleNow(new Runnable(){

                @Override
                public void run() {
                    Firebase.this.repo.setValue(Firebase.this.getPath(), node, listener);
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new FirebaseException("Failed to parse to snapshot", e);
        }
    }

    public void setPriority(Object priority) {
        this.setPriorityInternal(PriorityUtilities.parsePriority(priority), null);
    }

    public void setPriority(Object priority, CompletionListener listener) {
        this.setPriorityInternal(PriorityUtilities.parsePriority(priority), listener);
    }

    private void setPriorityInternal(final Node priority, final CompletionListener listener) {
        Validation.validateWritablePath(this.getPath());
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Firebase.this.repo.setValue(Firebase.this.getPath().child(ChildKey.getPriorityKey()), priority, listener);
            }
        });
    }

    public void updateChildren(Map<String, Object> update) {
        this.updateChildren(update, null);
    }

    public void updateChildren(final Map<String, Object> update, final CompletionListener listener) {
        if (update == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<Path, Node> parsedUpdate = Validation.parseAndValidateUpdate(this.getPath(), update);
        final CompoundWrite merge = CompoundWrite.fromPathMerge(parsedUpdate);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Firebase.this.repo.updateChildren(Firebase.this.getPath(), merge, listener, update);
            }
        });
    }

    public void removeValue() {
        this.setValue(null);
    }

    public void removeValue(CompletionListener listener) {
        this.setValue(null, listener);
    }

    public OnDisconnect onDisconnect() {
        Validation.validateWritablePath(this.getPath());
        return new OnDisconnect(this.repo, this.getPath());
    }

    @Deprecated
    public void auth(String credential, AuthListener listener) {
        if (listener == null) {
            throw new NullPointerException("Can't pass null for argument 'listener' in auth()");
        }
        if (credential == null) {
            throw new NullPointerException("Can't pass null for argument 'credential' in auth()");
        }
        this.getAuthenticationManager().authWithFirebaseToken(credential, listener);
    }

    public void unauth() {
        this.getAuthenticationManager().unauth();
    }

    @Deprecated
    public void unauth(CompletionListener listener) {
        if (listener == null) {
            throw new NullPointerException("Can't pass null for argument 'listener' in unauth()");
        }
        this.getAuthenticationManager().unauth(listener);
    }

    public AuthStateListener addAuthStateListener(AuthStateListener listener) {
        if (listener == null) {
            throw new NullPointerException("Can't pass null for argument 'listener' in addAuthStateListener()");
        }
        this.getAuthenticationManager().addAuthStateListener(listener);
        return listener;
    }

    public void removeAuthStateListener(AuthStateListener listener) {
        if (listener == null) {
            throw new NullPointerException("Can't pass null for argument 'listener' in removeAuthStateListener()");
        }
        this.getAuthenticationManager().removeAuthStateListener(listener);
    }

    public AuthData getAuth() {
        return this.getAuthenticationManager().getAuth();
    }

    public void authAnonymously(AuthResultHandler handler) {
        this.getAuthenticationManager().authAnonymously(handler);
    }

    public void authWithPassword(String email, String password, AuthResultHandler handler) {
        if (email == null) {
            throw new NullPointerException("Can't pass null for argument 'email' in authWithPassword()");
        }
        if (password == null) {
            throw new NullPointerException("Can't pass null for argument 'password' in authWithPassword()");
        }
        this.getAuthenticationManager().authWithPassword(email, password, handler);
    }

    public void authWithCustomToken(String token, AuthResultHandler handler) {
        if (token == null) {
            throw new NullPointerException("Can't pass null for argument 'token' in authWithCustomToken()");
        }
        this.getAuthenticationManager().authWithCustomToken(token, handler);
    }

    public void authWithOAuthToken(String provider, String token, AuthResultHandler handler) {
        if (provider == null) {
            throw new NullPointerException("Can't pass null for argument 'provider' in authWithOAuthToken()");
        }
        if (token == null) {
            throw new NullPointerException("Can't pass null for argument 'token' in authWithOAuthToken()");
        }
        this.getAuthenticationManager().authWithOAuthToken(provider, token, handler);
    }

    public void authWithOAuthToken(String provider, Map<String, String> options, AuthResultHandler handler) {
        if (provider == null) {
            throw new NullPointerException("Can't pass null for argument 'provider' in authWithOAuthToken()");
        }
        if (options == null) {
            throw new NullPointerException("Can't pass null for argument 'options' in authWithOAuthToken()");
        }
        this.getAuthenticationManager().authWithOAuthToken(provider, options, handler);
    }

    public void createUser(String email, String password, ResultHandler handler) {
        if (email == null) {
            throw new NullPointerException("Can't pass null for argument 'email' in createUser()");
        }
        if (password == null) {
            throw new NullPointerException("Can't pass null for argument 'password' in createUser()");
        }
        this.getAuthenticationManager().createUser(email, password, handler);
    }

    public void createUser(String email, String password, ValueResultHandler<Map<String, Object>> handler) {
        if (email == null) {
            throw new NullPointerException("Can't pass null for argument 'email' in createUser()");
        }
        if (password == null) {
            throw new NullPointerException("Can't pass null for argument 'password' in createUser()");
        }
        this.getAuthenticationManager().createUser(email, password, handler);
    }

    public void removeUser(String email, String password, ResultHandler handler) {
        if (email == null) {
            throw new NullPointerException("Can't pass null for argument 'email' in removeUser()");
        }
        if (password == null) {
            throw new NullPointerException("Can't pass null for argument 'password' in removeUser()");
        }
        this.getAuthenticationManager().removeUser(email, password, handler);
    }

    public void changePassword(String email, String oldPassword, String newPassword, ResultHandler handler) {
        if (email == null) {
            throw new NullPointerException("Can't pass null for argument 'email' in changePassword()");
        }
        if (oldPassword == null) {
            throw new NullPointerException("Can't pass null for argument 'oldPassword' in changePassword()");
        }
        if (newPassword == null) {
            throw new NullPointerException("Can't pass null for argument 'newPassword' in changePassword()");
        }
        this.getAuthenticationManager().changePassword(email, oldPassword, newPassword, handler);
    }

    public void changeEmail(String oldEmail, String password, String newEmail, ResultHandler handler) {
        if (oldEmail == null) {
            throw new NullPointerException("Can't pass null for argument 'oldEmail' in changeEmail()");
        }
        if (password == null) {
            throw new NullPointerException("Can't pass null for argument 'password' in changeEmail()");
        }
        if (newEmail == null) {
            throw new NullPointerException("Can't pass null for argument 'newEmail' in changeEmail()");
        }
        this.getAuthenticationManager().changeEmail(oldEmail, password, newEmail, handler);
    }

    public void resetPassword(String email, ResultHandler handler) {
        if (email == null) {
            throw new NullPointerException("Can't pass null for argument 'email' in resetPassword()");
        }
        this.getAuthenticationManager().resetPassword(email, handler);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(final Transaction.Handler handler, final boolean fireLocalEvents) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        Validation.validateWritablePath(this.getPath());
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Firebase.this.repo.startTransaction(Firebase.this.getPath(), handler, fireLocalEvents);
            }
        });
    }

    public static void goOffline() {
        Firebase.goOffline(Firebase.getDefaultConfig());
    }

    static void goOffline(Config config) {
        RepoManager.interrupt(config);
    }

    public static void goOnline() {
        Firebase.goOnline(Firebase.getDefaultConfig());
    }

    static void goOnline(Config config) {
        RepoManager.resume(config);
    }

    public FirebaseApp getApp() {
        return this.repo.getFirebaseApp();
    }

    public String toString() {
        Firebase parent = this.getParent();
        if (parent == null) {
            return this.repo.toString();
        }
        try {
            return parent.toString() + "/" + URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new FirebaseException("Failed to URLEncode key: " + this.getKey(), e);
        }
    }

    public Firebase getParent() {
        Path parentPath = this.getPath().getParent();
        if (parentPath != null) {
            return new Firebase(this.repo, parentPath);
        }
        return null;
    }

    public Firebase getRoot() {
        return new Firebase(this.repo, new Path(""));
    }

    public String getKey() {
        if (this.getPath().isEmpty()) {
            return null;
        }
        return this.getPath().getBack().asString();
    }

    public boolean equals(Object other) {
        return other instanceof Firebase && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static String getSdkVersion() {
        return "2.4.0";
    }

    void setHijackHash(final boolean hijackHash) {
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Firebase.this.repo.setHijackHash(hijackHash);
            }
        });
    }

    public static synchronized Config getDefaultConfig() {
        if (defaultConfig == null) {
            defaultConfig = new Config();
        }
        return defaultConfig;
    }

    public static synchronized void setDefaultConfig(Config config) {
        if (defaultConfig != null && defaultConfig.isFrozen()) {
            throw new FirebaseException("Modifications to Config objects must occur before they are in use");
        }
        defaultConfig = config;
    }

    public static void setAndroidContext(android.content.Context context) {
        if (context == null) {
            throw new NullPointerException("Can't pass null for argument 'context' in setAndroidContext()");
        }
        Context.setAndroidContext(context);
    }

    public static interface ValueResultHandler<T> {
        public void onSuccess(T var1);

        public void onError(FirebaseError var1);
    }

    public static interface ResultHandler {
        public void onSuccess();

        public void onError(FirebaseError var1);
    }

    public static interface AuthResultHandler {
        public void onAuthenticated(AuthData var1);

        public void onAuthenticationError(FirebaseError var1);
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(AuthData var1);
    }

    @Deprecated
    public static interface AuthListener {
        public void onAuthError(FirebaseError var1);

        public void onAuthSuccess(Object var1);

        public void onAuthRevoked(FirebaseError var1);
    }

    public static interface CompletionListener {
        public void onComplete(FirebaseError var1, Firebase var2);
    }
}

