/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.ChildEventListener;
import com.firebase.client.DataSnapshot;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.firebase.client.core.EventRegistration;
import com.firebase.client.core.Repo;
import com.firebase.client.core.view.Change;
import com.firebase.client.core.view.DataEvent;
import com.firebase.client.core.view.Event;
import com.firebase.client.core.view.QuerySpec;

public class ChildEventRegistration
implements EventRegistration {
    private final Repo repo;
    private final ChildEventListener eventListener;

    public ChildEventRegistration(Repo repo, ChildEventListener eventListener) {
        this.repo = repo;
        this.eventListener = eventListener;
    }

    @Override
    public boolean respondsTo(Event.EventType eventType) {
        return eventType != Event.EventType.VALUE;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ChildEventRegistration && ((ChildEventRegistration)other).eventListener.equals(this.eventListener);
    }

    public int hashCode() {
        return this.eventListener.hashCode();
    }

    @Override
    public DataEvent createEvent(Change change, QuerySpec query) {
        Firebase ref = new Firebase(this.repo, query.getPath().child(change.getChildKey()));
        DataSnapshot snapshot = new DataSnapshot(ref, change.getIndexedNode());
        String prevName = change.getPrevName() != null ? change.getPrevName().asString() : null;
        return new DataEvent(change.getEventType(), this, snapshot, prevName);
    }

    @Override
    public void fireEvent(DataEvent eventData) {
        switch (eventData.getEventType()) {
            case CHILD_ADDED: {
                this.eventListener.onChildAdded(eventData.getSnapshot(), eventData.getPreviousName());
                break;
            }
            case CHILD_CHANGED: {
                this.eventListener.onChildChanged(eventData.getSnapshot(), eventData.getPreviousName());
                break;
            }
            case CHILD_MOVED: {
                this.eventListener.onChildMoved(eventData.getSnapshot(), eventData.getPreviousName());
                break;
            }
            case CHILD_REMOVED: {
                this.eventListener.onChildRemoved(eventData.getSnapshot());
                break;
            }
        }
    }

    @Override
    public void fireCancelEvent(FirebaseError error) {
        this.eventListener.onCancelled(error);
    }

    public String toString() {
        return "ChildEventRegistration";
    }
}

