/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.CredentialStore;
import com.firebase.client.EventTarget;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseException;
import com.firebase.client.Logger;
import com.firebase.client.RunLoop;
import com.firebase.client.core.AndroidSupport;
import com.firebase.client.core.AuthExpirationBehavior;
import com.firebase.client.core.GaePlatform;
import com.firebase.client.core.JvmPlatform;
import com.firebase.client.core.Platform;
import com.firebase.client.core.persistence.NoopPersistenceManager;
import com.firebase.client.core.persistence.PersistenceManager;
import com.firebase.client.utilities.LogWrapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class Context {
    private static final long DEFAULT_CACHE_SIZE = 0xA00000L;
    protected Logger logger;
    protected EventTarget eventTarget;
    protected CredentialStore credentialStore;
    protected RunLoop runLoop;
    protected String persistenceKey;
    protected List<String> loggedComponents;
    protected String userAgent;
    protected String authenticationServer;
    protected Logger.Level logLevel = Logger.Level.INFO;
    protected boolean persistenceEnabled;
    protected AuthExpirationBehavior authExpirationBehavior = AuthExpirationBehavior.DEFAULT;
    protected long cacheSize = 0xA00000L;
    private PersistenceManager forcedPersistenceManager;
    private boolean frozen = false;
    private boolean stopped = false;
    private static Platform platform;
    private static android.content.Context androidContext;

    private Platform getPlatform() {
        if (platform == null) {
            if (AndroidSupport.isAndroid()) {
                throw new RuntimeException("You need to set the Android context using Firebase.setAndroidContext() before using Firebase.");
            }
            if (GaePlatform.isActive()) {
                GaePlatform gaePlatform = GaePlatform.INSTANCE;
                gaePlatform.initialize();
                platform = gaePlatform;
            } else {
                platform = JvmPlatform.INSTANCE;
            }
        }
        return platform;
    }

    public static synchronized void setAndroidContext(android.content.Context context) {
        if (androidContext == null) {
            androidContext = context.getApplicationContext();
            try {
                Class<?> androidPlatformClass = Class.forName("com.firebase.client.android.AndroidPlatform");
                Constructor<?> constructor = androidPlatformClass.getConstructor(android.content.Context.class);
                platform = (Platform)constructor.newInstance(context);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Android classes not found. Are you using the firebase-client-android artifact?");
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to instantiate AndroidPlatform class.  Using ProGuard?  See http://stackoverflow.com/questions/26273929/what-proguard-configuration-do-i-need-for-firebase-on-android", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to instantiate AndroidPlatform class.", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to instantiate AndroidPlatform class.", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to instantiate AndroidPlatform class.", e);
            }
        }
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    synchronized void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            this.initServices();
        }
    }

    public void requireStarted() {
        if (this.stopped) {
            this.restartServices();
            this.stopped = false;
        }
    }

    private void initServices() {
        this.ensureLogger();
        this.getPlatform();
        this.ensureUserAgent();
        this.ensureEventTarget();
        this.ensureRunLoop();
        this.ensureSessionIdentifier();
        this.ensureCredentialStore();
    }

    private void restartServices() {
        this.eventTarget.restart();
        this.runLoop.restart();
    }

    void stop() {
        this.stopped = true;
        this.eventTarget.shutdown();
        this.runLoop.shutdown();
    }

    protected void assertUnfrozen() {
        if (this.isFrozen()) {
            throw new FirebaseException("Modifications to Config objects must occur before they are in use");
        }
    }

    public LogWrapper getLogger(String component) {
        return new LogWrapper(this.logger, component);
    }

    public LogWrapper getLogger(String component, String prefix) {
        return new LogWrapper(this.logger, component, prefix);
    }

    PersistenceManager getPersistenceManager(String firebaseId) {
        if (this.forcedPersistenceManager != null) {
            return this.forcedPersistenceManager;
        }
        if (this.persistenceEnabled) {
            PersistenceManager cache = platform.createPersistenceManager(this, firebaseId);
            if (cache == null) {
                throw new IllegalArgumentException("You have enabled persistence, but persistence is not supported on this platform.");
            }
            return cache;
        }
        return new NoopPersistenceManager();
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public AuthExpirationBehavior getAuthExpirationBehavior() {
        return this.authExpirationBehavior;
    }

    public long getPersistenceCacheSizeBytes() {
        return this.cacheSize;
    }

    void forcePersistenceManager(PersistenceManager persistenceManager) {
        this.forcedPersistenceManager = persistenceManager;
    }

    public EventTarget getEventTarget() {
        return this.eventTarget;
    }

    public RunLoop getRunLoop() {
        return this.runLoop;
    }

    public void runBackgroundTask(Runnable r) {
        this.getPlatform().runBackgroundTask(this, r);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getPlatformVersion() {
        return this.getPlatform().getPlatformVersion();
    }

    public String getSessionPersistenceKey() {
        return this.persistenceKey;
    }

    public CredentialStore getCredentialStore() {
        return this.credentialStore;
    }

    public String getAuthenticationServer() {
        if (this.authenticationServer == null) {
            return "https://auth.firebase.com/";
        }
        return this.authenticationServer;
    }

    public boolean isCustomAuthenticationServerSet() {
        return this.authenticationServer != null;
    }

    private void ensureLogger() {
        if (this.logger == null) {
            this.logger = this.getPlatform().newLogger(this, this.logLevel, this.loggedComponents);
        }
    }

    private void ensureRunLoop() {
        if (this.runLoop == null) {
            this.runLoop = platform.newRunLoop(this);
        }
    }

    private void ensureEventTarget() {
        if (this.eventTarget == null) {
            this.eventTarget = this.getPlatform().newEventTarget(this);
        }
    }

    private void ensureUserAgent() {
        if (this.userAgent == null) {
            this.userAgent = this.buildUserAgent(this.getPlatform().getUserAgent(this));
        }
    }

    private void ensureCredentialStore() {
        if (this.credentialStore == null) {
            this.credentialStore = this.getPlatform().newCredentialStore(this);
        }
    }

    private void ensureSessionIdentifier() {
        if (this.persistenceKey == null) {
            this.persistenceKey = "default";
        }
    }

    private String buildUserAgent(String platformAgent) {
        StringBuilder sb = new StringBuilder().append("Firebase/").append("5").append("/").append(Firebase.getSdkVersion()).append("/").append(platformAgent);
        return sb.toString();
    }
}

