/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.CredentialStore;
import com.firebase.client.EventTarget;
import com.firebase.client.Firebase;
import com.firebase.client.Logger;
import com.firebase.client.RunLoop;
import com.firebase.client.authentication.NoopCredentialStore;
import com.firebase.client.core.Context;
import com.firebase.client.core.Platform;
import com.firebase.client.core.ThreadInitializer;
import com.firebase.client.core.ThreadPoolEventTarget;
import com.firebase.client.core.persistence.PersistenceManager;
import com.firebase.client.utilities.DefaultLogger;
import com.firebase.client.utilities.DefaultRunLoop;
import com.firebase.client.utilities.LogWrapper;
import java.util.List;
import java.util.concurrent.Executors;

enum JvmPlatform implements Platform
{
    INSTANCE;


    @Override
    public Logger newLogger(Context ctx, Logger.Level level, List<String> components) {
        return new DefaultLogger(level, components);
    }

    @Override
    public EventTarget newEventTarget(Context ctx) {
        return new ThreadPoolEventTarget(Executors.defaultThreadFactory(), ThreadInitializer.defaultInstance);
    }

    @Override
    public RunLoop newRunLoop(Context context) {
        final LogWrapper logger = context.getLogger("RunLoop");
        return new DefaultRunLoop(){

            @Override
            public void handleException(Throwable e) {
                logger.error("Uncaught exception in Firebase runloop (" + Firebase.getSdkVersion() + "). Please report to support@firebase.com", e);
            }
        };
    }

    @Override
    public String getUserAgent(Context ctx) {
        String deviceName = System.getProperty("java.vm.name", "Unknown JVM");
        String systemVersion = System.getProperty("java.specification.version", "Unknown");
        return systemVersion + "/" + deviceName;
    }

    @Override
    public String getPlatformVersion() {
        return "jvm-" + Firebase.getSdkVersion();
    }

    @Override
    public PersistenceManager createPersistenceManager(Context ctx, String namespace) {
        return null;
    }

    @Override
    public CredentialStore newCredentialStore(Context ctx) {
        return new NoopCredentialStore(ctx);
    }

    @Override
    public void runBackgroundTask(final Context ctx, final Runnable r) {
        new Thread(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (Throwable e) {
                    ctx.getLogger("BackgroundTask").error("An unexpected error occurred. Please contact support@firebase.com. Details: ", e);
                    throw new RuntimeException(e);
                }
            }
        }.start();
    }
}

