/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.DataSnapshot;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseApp;
import com.firebase.client.FirebaseError;
import com.firebase.client.FirebaseException;
import com.firebase.client.MutableData;
import com.firebase.client.Transaction;
import com.firebase.client.ValueEventListener;
import com.firebase.client.authentication.AuthenticationManager;
import com.firebase.client.core.CompoundWrite;
import com.firebase.client.core.Constants;
import com.firebase.client.core.Context;
import com.firebase.client.core.EventRegistration;
import com.firebase.client.core.Path;
import com.firebase.client.core.PersistentConnection;
import com.firebase.client.core.RepoInfo;
import com.firebase.client.core.ServerValues;
import com.firebase.client.core.SnapshotHolder;
import com.firebase.client.core.SparseSnapshotTree;
import com.firebase.client.core.SyncTree;
import com.firebase.client.core.Tag;
import com.firebase.client.core.UserWriteRecord;
import com.firebase.client.core.ValueEventRegistration;
import com.firebase.client.core.persistence.NoopPersistenceManager;
import com.firebase.client.core.persistence.PersistenceManager;
import com.firebase.client.core.utilities.Tree;
import com.firebase.client.core.view.Event;
import com.firebase.client.core.view.EventRaiser;
import com.firebase.client.core.view.QuerySpec;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.EmptyNode;
import com.firebase.client.snapshot.IndexedNode;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.NodeUtilities;
import com.firebase.client.utilities.DefaultClock;
import com.firebase.client.utilities.LogWrapper;
import com.firebase.client.utilities.OffsetClock;
import com.firebase.client.utilities.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Repo
implements PersistentConnection.Delegate {
    private final RepoInfo repoInfo;
    private final OffsetClock serverClock = new OffsetClock(new DefaultClock(), 0L);
    private final PersistentConnection connection;
    private final AuthenticationManager authenticationManager;
    private SnapshotHolder infoData;
    private SparseSnapshotTree onDisconnect;
    private Tree<List<TransactionData>> transactionQueueTree;
    private boolean hijackHash = false;
    private final EventRaiser eventRaiser;
    private final Context ctx;
    private final LogWrapper operationLogger;
    private final LogWrapper transactionLogger;
    private final LogWrapper dataLogger;
    public long dataUpdateCount = 0L;
    private long nextWriteId = 1L;
    private SyncTree infoSyncTree;
    private SyncTree serverSyncTree;
    private FirebaseApp app;
    private boolean loggedTransactionPersistenceWarning = false;
    private static final int TRANSACTION_MAX_RETRIES = 25;
    private static final String TRANSACTION_TOO_MANY_RETRIES = "maxretries";
    private static final String TRANSACTION_OVERRIDE_BY_SET = "overriddenBySet";
    private long transactionOrder = 0L;

    Repo(RepoInfo repoInfo, Context ctx) {
        this.repoInfo = repoInfo;
        this.ctx = ctx;
        this.app = new FirebaseAppImpl(this);
        this.operationLogger = this.ctx.getLogger("RepoOperation");
        this.transactionLogger = this.ctx.getLogger("Transaction");
        this.dataLogger = this.ctx.getLogger("DataOperation");
        this.eventRaiser = new EventRaiser(this.ctx);
        this.connection = new PersistentConnection(ctx, repoInfo, this);
        this.authenticationManager = new AuthenticationManager(ctx, this, repoInfo, this.connection);
        this.authenticationManager.resumeSession();
        this.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Repo.this.deferredInitialization();
            }
        });
    }

    private void deferredInitialization() {
        this.connection.establishConnection();
        PersistenceManager persistenceManager = this.ctx.getPersistenceManager(this.repoInfo.host);
        this.infoData = new SnapshotHolder();
        this.onDisconnect = new SparseSnapshotTree();
        this.transactionQueueTree = new Tree();
        this.infoSyncTree = new SyncTree(this.ctx, new NoopPersistenceManager(), new SyncTree.ListenProvider(){

            @Override
            public void startListening(final QuerySpec query, Tag tag, SyncTree.SyncTreeHash hash, final SyncTree.CompletionListener onComplete) {
                Repo.this.scheduleNow(new Runnable(){

                    @Override
                    public void run() {
                        Node node = Repo.this.infoData.getNode(query.getPath());
                        if (!node.isEmpty()) {
                            List<? extends Event> infoEvents = Repo.this.infoSyncTree.applyServerOverwrite(query.getPath(), node);
                            Repo.this.postEvents(infoEvents);
                            onComplete.onListenComplete(null);
                        }
                    }
                });
            }

            @Override
            public void stopListening(QuerySpec query, Tag tag) {
            }
        });
        this.serverSyncTree = new SyncTree(this.ctx, persistenceManager, new SyncTree.ListenProvider(){

            @Override
            public void startListening(QuerySpec query, Tag tag, SyncTree.SyncTreeHash hash, final SyncTree.CompletionListener onListenComplete) {
                Repo.this.connection.listen(query, hash, tag, new PersistentConnection.RequestResultListener(){

                    @Override
                    public void onRequestResult(FirebaseError error) {
                        List<? extends Event> events = onListenComplete.onListenComplete(error);
                        Repo.this.postEvents(events);
                    }
                });
            }

            @Override
            public void stopListening(QuerySpec query, Tag tag) {
                Repo.this.connection.unlisten(query);
            }
        });
        this.restoreWrites(persistenceManager);
        boolean authenticated = this.authenticationManager.getAuth() != null;
        this.updateInfo(Constants.DOT_INFO_AUTHENTICATED, authenticated);
        this.updateInfo(Constants.DOT_INFO_CONNECTED, false);
    }

    private void restoreWrites(PersistenceManager persistenceManager) {
        List<UserWriteRecord> writes = persistenceManager.loadUserWrites();
        Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
        long lastWriteId = Long.MIN_VALUE;
        for (final UserWriteRecord write : writes) {
            Iterable<Map.Entry<Path, Node>> resolved;
            Firebase.CompletionListener onComplete = new Firebase.CompletionListener(){

                @Override
                public void onComplete(FirebaseError error, Firebase ref) {
                    Repo.this.warnIfWriteFailed("Persisted write", write.getPath(), error);
                    Repo.this.ackWriteAndRerunTransactions(write.getWriteId(), write.getPath(), error);
                }
            };
            if (lastWriteId >= write.getWriteId()) {
                throw new IllegalStateException("Write ids were not in order.");
            }
            lastWriteId = write.getWriteId();
            this.nextWriteId = write.getWriteId() + 1L;
            if (write.isOverwrite()) {
                if (this.operationLogger.logsDebug()) {
                    this.operationLogger.debug("Restoring overwrite with id " + write.getWriteId());
                }
                this.connection.put(write.getPath().toString(), write.getOverwrite().getValue(true), null, onComplete);
                resolved = ServerValues.resolveDeferredValueSnapshot(write.getOverwrite(), serverValues);
                this.serverSyncTree.applyUserOverwrite(write.getPath(), write.getOverwrite(), (Node)resolved, write.getWriteId(), true, false);
                continue;
            }
            if (this.operationLogger.logsDebug()) {
                this.operationLogger.debug("Restoring merge with id " + write.getWriteId());
            }
            this.connection.merge(write.getPath().toString(), write.getMerge().getValue(true), onComplete);
            resolved = ServerValues.resolveDeferredValueMerge(write.getMerge(), serverValues);
            this.serverSyncTree.applyUserMerge(write.getPath(), write.getMerge(), (CompoundWrite)resolved, write.getWriteId(), false);
        }
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public FirebaseApp getFirebaseApp() {
        return this.app;
    }

    public String toString() {
        return this.repoInfo.toString();
    }

    public void scheduleNow(Runnable r) {
        this.ctx.requireStarted();
        this.ctx.getRunLoop().scheduleNow(r);
    }

    public void postEvent(Runnable r) {
        this.ctx.requireStarted();
        this.ctx.getEventTarget().postEvent(r);
    }

    private void postEvents(List<? extends Event> events) {
        if (!events.isEmpty()) {
            this.eventRaiser.raiseEvents(events);
        }
    }

    public long getServerTime() {
        return this.serverClock.millis();
    }

    boolean hasListeners() {
        return !this.infoSyncTree.isEmpty() || !this.serverSyncTree.isEmpty();
    }

    @Override
    public void onDataUpdate(String pathString, Object message, boolean isMerge, Tag tag) {
        if (this.operationLogger.logsDebug()) {
            this.operationLogger.debug("onDataUpdate: " + pathString);
        }
        if (this.dataLogger.logsDebug()) {
            this.operationLogger.debug("onDataUpdate: " + pathString + " " + message);
        }
        ++this.dataUpdateCount;
        Path path = new Path(pathString);
        try {
            List<? extends Event> events;
            if (tag != null) {
                if (isMerge) {
                    HashMap<Path, Node> taggedChildren = new HashMap<Path, Node>();
                    Map rawMergeData = (Map)message;
                    for (Map.Entry entry : rawMergeData.entrySet()) {
                        Node newChildNode = NodeUtilities.NodeFromJSON(entry.getValue());
                        taggedChildren.put(new Path((String)entry.getKey()), newChildNode);
                    }
                    events = this.serverSyncTree.applyTaggedQueryMerge(path, taggedChildren, tag);
                } else {
                    Node taggedSnap = NodeUtilities.NodeFromJSON(message);
                    events = this.serverSyncTree.applyTaggedQueryOverwrite(path, taggedSnap, tag);
                }
            } else if (isMerge) {
                HashMap<Path, Node> changedChildren = new HashMap<Path, Node>();
                Map rawMergeData = (Map)message;
                for (Map.Entry entry : rawMergeData.entrySet()) {
                    Node newChildNode = NodeUtilities.NodeFromJSON(entry.getValue());
                    changedChildren.put(new Path((String)entry.getKey()), newChildNode);
                }
                events = this.serverSyncTree.applyServerMerge(path, changedChildren);
            } else {
                Node snap = NodeUtilities.NodeFromJSON(message);
                events = this.serverSyncTree.applyServerOverwrite(path, snap);
            }
            if (events.size() > 0) {
                this.rerunTransactions(path);
            }
            this.postEvents(events);
        }
        catch (FirebaseException e) {
            this.operationLogger.error("FIREBASE INTERNAL ERROR", e);
        }
    }

    void callOnComplete(final Firebase.CompletionListener onComplete, final FirebaseError error, Path path) {
        if (onComplete != null) {
            ChildKey last = path.getBack();
            final Firebase ref = last != null && last.isPriorityChildName() ? new Firebase(this, path.getParent()) : new Firebase(this, path);
            this.postEvent(new Runnable(){

                @Override
                public void run() {
                    onComplete.onComplete(error, ref);
                }
            });
        }
    }

    private void ackWriteAndRerunTransactions(long writeId, Path path, FirebaseError error) {
        if (error == null || error.getCode() != -25) {
            boolean success = error == null;
            List<? extends Event> clearEvents = this.serverSyncTree.ackUserWrite(writeId, !success, true, this.serverClock);
            if (clearEvents.size() > 0) {
                this.rerunTransactions(path);
            }
            this.postEvents(clearEvents);
        }
    }

    public void setValue(final Path path, Node newValueUnresolved, final Firebase.CompletionListener onComplete) {
        if (this.operationLogger.logsDebug()) {
            this.operationLogger.debug("set: " + path);
        }
        if (this.dataLogger.logsDebug()) {
            this.dataLogger.debug("set: " + path + " " + newValueUnresolved);
        }
        Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
        Node newValue = ServerValues.resolveDeferredValueSnapshot(newValueUnresolved, serverValues);
        final long writeId = this.getNextWriteId();
        List<? extends Event> events = this.serverSyncTree.applyUserOverwrite(path, newValueUnresolved, newValue, writeId, true, true);
        this.postEvents(events);
        this.connection.put(path.toString(), newValueUnresolved.getValue(true), new Firebase.CompletionListener(){

            @Override
            public void onComplete(FirebaseError error, Firebase ref) {
                Repo.this.warnIfWriteFailed("setValue", path, error);
                Repo.this.ackWriteAndRerunTransactions(writeId, path, error);
                Repo.this.callOnComplete(onComplete, error, path);
            }
        });
        Path affectedPath = this.abortTransactions(path, -9);
        this.rerunTransactions(affectedPath);
    }

    public void updateChildren(final Path path, CompoundWrite updates, final Firebase.CompletionListener onComplete, Map<String, Object> unParsedUpdates) {
        if (this.operationLogger.logsDebug()) {
            this.operationLogger.debug("update: " + path);
        }
        if (this.dataLogger.logsDebug()) {
            this.dataLogger.debug("update: " + path + " " + unParsedUpdates);
        }
        if (updates.isEmpty()) {
            if (this.operationLogger.logsDebug()) {
                this.operationLogger.debug("update called with no changes. No-op");
            }
            this.callOnComplete(onComplete, null, path);
            return;
        }
        Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
        CompoundWrite resolved = ServerValues.resolveDeferredValueMerge(updates, serverValues);
        final long writeId = this.getNextWriteId();
        List<? extends Event> events = this.serverSyncTree.applyUserMerge(path, updates, resolved, writeId, true);
        this.postEvents(events);
        this.connection.merge(path.toString(), unParsedUpdates, new Firebase.CompletionListener(){

            @Override
            public void onComplete(FirebaseError error, Firebase ref) {
                Repo.this.warnIfWriteFailed("updateChildren", path, error);
                Repo.this.ackWriteAndRerunTransactions(writeId, path, error);
                Repo.this.callOnComplete(onComplete, error, path);
            }
        });
        Path affectedPath = this.abortTransactions(path, -9);
        this.rerunTransactions(affectedPath);
    }

    public void purgeOutstandingWrites() {
        if (this.operationLogger.logsDebug()) {
            this.operationLogger.debug("Purging writes");
        }
        List<? extends Event> events = this.serverSyncTree.removeAllWrites();
        this.postEvents(events);
        this.abortTransactions(Path.getEmptyPath(), -25);
        this.connection.purgeOutstandingWrites();
    }

    public void removeEventCallback(QuerySpec query, EventRegistration eventRegistration) {
        List<Event> events = Constants.DOT_INFO.equals(query.getPath().getFront()) ? this.infoSyncTree.removeEventRegistration(query, eventRegistration) : this.serverSyncTree.removeEventRegistration(query, eventRegistration);
        this.postEvents(events);
    }

    public void onDisconnectSetValue(final Path path, final Node newValue, final Firebase.CompletionListener onComplete) {
        this.connection.onDisconnectPut(path, newValue.getValue(true), new Firebase.CompletionListener(){

            @Override
            public void onComplete(FirebaseError error, Firebase ref) {
                Repo.this.warnIfWriteFailed("onDisconnect().setValue", path, error);
                if (error == null) {
                    Repo.this.onDisconnect.remember(path, newValue);
                }
                Repo.this.callOnComplete(onComplete, error, path);
            }
        });
    }

    public void onDisconnectUpdate(final Path path, final Map<Path, Node> newChildren, final Firebase.CompletionListener listener, Map<String, Object> unParsedUpdates) {
        this.connection.onDisconnectMerge(path, unParsedUpdates, new Firebase.CompletionListener(){

            @Override
            public void onComplete(FirebaseError error, Firebase ref) {
                Repo.this.warnIfWriteFailed("onDisconnect().updateChildren", path, error);
                if (error == null) {
                    for (Map.Entry entry : newChildren.entrySet()) {
                        Repo.this.onDisconnect.remember(path.child((Path)entry.getKey()), (Node)entry.getValue());
                    }
                }
                Repo.this.callOnComplete(listener, error, path);
            }
        });
    }

    public void onDisconnectCancel(final Path path, final Firebase.CompletionListener onComplete) {
        this.connection.onDisconnectCancel(path, new Firebase.CompletionListener(){

            @Override
            public void onComplete(FirebaseError error, Firebase ref) {
                if (error == null) {
                    Repo.this.onDisconnect.forget(path);
                }
                Repo.this.callOnComplete(onComplete, error, path);
            }
        });
    }

    @Override
    public void onConnect() {
        this.onServerInfoUpdate(Constants.DOT_INFO_CONNECTED, true);
    }

    @Override
    public void onDisconnect() {
        this.onServerInfoUpdate(Constants.DOT_INFO_CONNECTED, false);
        this.runOnDisconnectEvents();
    }

    @Override
    public void onAuthStatus(boolean authOk) {
        this.onServerInfoUpdate(Constants.DOT_INFO_AUTHENTICATED, authOk);
    }

    public void onServerInfoUpdate(ChildKey key, Object value) {
        this.updateInfo(key, value);
    }

    @Override
    public void onServerInfoUpdate(Map<ChildKey, Object> updates) {
        for (Map.Entry<ChildKey, Object> entry : updates.entrySet()) {
            this.updateInfo(entry.getKey(), entry.getValue());
        }
    }

    void interrupt() {
        this.connection.interrupt();
    }

    void resume() {
        this.connection.resume();
    }

    public void addEventCallback(QuerySpec query, EventRegistration eventRegistration) {
        ChildKey front = query.getPath().getFront();
        List<? extends Event> events = front != null && front.equals(Constants.DOT_INFO) ? this.infoSyncTree.addEventRegistration(query, eventRegistration) : this.serverSyncTree.addEventRegistration(query, eventRegistration);
        this.postEvents(events);
    }

    public void keepSynced(QuerySpec query, boolean keep) {
        assert (query.getPath().isEmpty() || !query.getPath().getFront().equals(Constants.DOT_INFO));
        this.serverSyncTree.keepSynced(query, keep);
    }

    PersistentConnection getConnection() {
        return this.connection;
    }

    private void updateInfo(ChildKey childKey, Object value) {
        if (childKey.equals(Constants.DOT_INFO_SERVERTIME_OFFSET)) {
            this.serverClock.setOffset((Long)value);
        }
        Path path = new Path(Constants.DOT_INFO, childKey);
        try {
            Node node = NodeUtilities.NodeFromJSON(value);
            this.infoData.update(path, node);
            List<? extends Event> events = this.infoSyncTree.applyServerOverwrite(path, node);
            this.postEvents(events);
        }
        catch (FirebaseException e) {
            this.operationLogger.error("Failed to parse info update", e);
        }
    }

    private long getNextWriteId() {
        return this.nextWriteId++;
    }

    private void runOnDisconnectEvents() {
        Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
        SparseSnapshotTree resolvedTree = ServerValues.resolveDeferredValueTree(this.onDisconnect, serverValues);
        final ArrayList events = new ArrayList();
        resolvedTree.forEachTree(Path.getEmptyPath(), new SparseSnapshotTree.SparseSnapshotTreeVisitor(){

            @Override
            public void visitTree(Path prefixPath, Node node) {
                events.addAll(Repo.this.serverSyncTree.applyServerOverwrite(prefixPath, node));
                Path affectedPath = Repo.this.abortTransactions(prefixPath, -9);
                Repo.this.rerunTransactions(affectedPath);
            }
        });
        this.onDisconnect = new SparseSnapshotTree();
        this.postEvents(events);
    }

    private void warnIfWriteFailed(String writeType, Path path, FirebaseError error) {
        if (error != null && error.getCode() != -1 && error.getCode() != -25) {
            this.operationLogger.warn(writeType + " at " + path.toString() + " failed: " + error.toString());
        }
    }

    public void startTransaction(Path path, final Transaction.Handler handler, boolean applyLocally) {
        Transaction.Result result;
        if (this.operationLogger.logsDebug()) {
            this.operationLogger.debug("transaction: " + path);
        }
        if (this.dataLogger.logsDebug()) {
            this.operationLogger.debug("transaction: " + path);
        }
        if (this.ctx.isPersistenceEnabled() && !this.loggedTransactionPersistenceWarning) {
            this.loggedTransactionPersistenceWarning = true;
            this.transactionLogger.info("runTransaction() usage detected while persistence is enabled. Please be aware that transactions *will not* be persisted across app restarts.  See https://www.firebase.com/docs/android/guide/offline-capabilities.html#section-handling-transactions-offline for more details.");
        }
        Firebase watchRef = new Firebase(this, path);
        ValueEventListener listener = new ValueEventListener(){

            @Override
            public void onDataChange(DataSnapshot snapshot) {
            }

            @Override
            public void onCancelled(FirebaseError error) {
            }
        };
        this.addEventCallback(watchRef.getSpec(), new ValueEventRegistration(this, listener));
        TransactionData transaction = new TransactionData(path, handler, listener, TransactionStatus.INITIALIZING, applyLocally, this.nextTransactionOrder());
        Node currentState = this.getLatestState(path);
        transaction.currentInputSnapshot = currentState;
        MutableData mutableCurrent = new MutableData(currentState);
        FirebaseError error = null;
        try {
            result = handler.doTransaction(mutableCurrent);
            if (result == null) {
                throw new NullPointerException("Transaction returned null as result");
            }
        }
        catch (Throwable e) {
            error = FirebaseError.fromException(e);
            result = Transaction.abort();
        }
        if (!result.isSuccess()) {
            transaction.currentOutputSnapshotRaw = null;
            transaction.currentOutputSnapshotResolved = null;
            final FirebaseError innerClassError = error;
            final DataSnapshot snap = new DataSnapshot(watchRef, IndexedNode.from(transaction.currentInputSnapshot));
            this.postEvent(new Runnable(){

                @Override
                public void run() {
                    handler.onComplete(innerClassError, false, snap);
                }
            });
        } else {
            transaction.status = TransactionStatus.RUN;
            Tree<List<TransactionData>> queueNode = this.transactionQueueTree.subTree(path);
            List<TransactionData> nodeQueue = queueNode.getValue();
            if (nodeQueue == null) {
                nodeQueue = new ArrayList<TransactionData>();
            }
            nodeQueue.add(transaction);
            queueNode.setValue(nodeQueue);
            Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
            Node newNodeUnresolved = result.getNode();
            Node newNode = ServerValues.resolveDeferredValueSnapshot(newNodeUnresolved, serverValues);
            transaction.currentOutputSnapshotRaw = newNodeUnresolved;
            transaction.currentOutputSnapshotResolved = newNode;
            transaction.currentWriteId = this.getNextWriteId();
            List<? extends Event> events = this.serverSyncTree.applyUserOverwrite(path, newNodeUnresolved, newNode, transaction.currentWriteId, applyLocally, false);
            this.postEvents(events);
            this.sendAllReadyTransactions();
        }
    }

    private Node getLatestState(Path path) {
        return this.getLatestState(path, new ArrayList<Long>());
    }

    private Node getLatestState(Path path, List<Long> excudeSets) {
        Node state = this.serverSyncTree.calcCompleteEventCache(path, excudeSets);
        if (state == null) {
            state = EmptyNode.Empty();
        }
        return state;
    }

    public void setHijackHash(boolean hijackHash) {
        this.hijackHash = hijackHash;
    }

    private void sendAllReadyTransactions() {
        Tree<List<TransactionData>> node = this.transactionQueueTree;
        this.pruneCompletedTransactions(node);
        this.sendReadyTransactions(node);
    }

    private void sendReadyTransactions(Tree<List<TransactionData>> node) {
        List<TransactionData> queue = node.getValue();
        if (queue != null) {
            queue = this.buildTransactionQueue(node);
            assert (queue.size() > 0);
            Boolean allRun = true;
            for (TransactionData transaction : queue) {
                if (transaction.status == TransactionStatus.RUN) continue;
                allRun = false;
                break;
            }
            if (allRun.booleanValue()) {
                this.sendTransactionQueue(queue, node.getPath());
            }
        } else if (node.hasChildren()) {
            node.forEachChild(new Tree.TreeVisitor<List<TransactionData>>(){

                @Override
                public void visitTree(Tree<List<TransactionData>> tree) {
                    Repo.this.sendReadyTransactions(tree);
                }
            });
        }
    }

    private void sendTransactionQueue(final List<TransactionData> queue, final Path path) {
        Node latestState;
        ArrayList<Long> setsToIgnore = new ArrayList<Long>();
        for (TransactionData txn : queue) {
            setsToIgnore.add(txn.currentWriteId);
        }
        Node snapToSend = latestState = this.getLatestState(path, setsToIgnore);
        String latestHash = "badhash";
        if (!this.hijackHash) {
            latestHash = latestState.getHash();
        }
        for (TransactionData txn : queue) {
            assert (txn.status == TransactionStatus.RUN);
            txn.status = TransactionStatus.SENT;
            txn.retryCount++;
            Path relativePath = Path.getRelative(path, txn.path);
            snapToSend = snapToSend.updateChild(relativePath, txn.currentOutputSnapshotRaw);
        }
        Object dataToSend = snapToSend.getValue(true);
        final Repo repo = this;
        long writeId = this.getNextWriteId();
        this.connection.put(path.toString(), dataToSend, latestHash, new Firebase.CompletionListener(){

            @Override
            public void onComplete(FirebaseError error, Firebase ref) {
                Repo.this.warnIfWriteFailed("Transaction", path, error);
                ArrayList<? extends Event> events = new ArrayList<Event>();
                if (error == null) {
                    ArrayList<1> callbacks = new ArrayList<1>();
                    for (final TransactionData txn : queue) {
                        txn.status = TransactionStatus.COMPLETED;
                        events.addAll(Repo.this.serverSyncTree.ackUserWrite(txn.currentWriteId, false, false, Repo.this.serverClock));
                        Node node = txn.currentOutputSnapshotResolved;
                        final DataSnapshot snap = new DataSnapshot(new Firebase(repo, txn.path), IndexedNode.from(node));
                        callbacks.add(new Runnable(){

                            @Override
                            public void run() {
                                txn.handler.onComplete(null, true, snap);
                            }
                        });
                        Repo.this.removeEventCallback(QuerySpec.defaultQueryAtPath(txn.path), new ValueEventRegistration(Repo.this, txn.outstandingListener));
                    }
                    Repo.this.pruneCompletedTransactions(Repo.this.transactionQueueTree.subTree(path));
                    Repo.this.sendAllReadyTransactions();
                    repo.postEvents(events);
                    for (int i = 0; i < callbacks.size(); ++i) {
                        Repo.this.postEvent((Runnable)callbacks.get(i));
                    }
                } else {
                    if (error.getCode() == -1) {
                        for (TransactionData transaction : queue) {
                            if (transaction.status == TransactionStatus.SENT_NEEDS_ABORT) {
                                transaction.status = TransactionStatus.NEEDS_ABORT;
                                continue;
                            }
                            transaction.status = TransactionStatus.RUN;
                        }
                    } else {
                        for (TransactionData transaction : queue) {
                            transaction.status = TransactionStatus.NEEDS_ABORT;
                            transaction.abortReason = error;
                        }
                    }
                    Repo.this.rerunTransactions(path);
                }
            }
        });
    }

    private void pruneCompletedTransactions(Tree<List<TransactionData>> node) {
        List<TransactionData> queue = node.getValue();
        if (queue != null) {
            int i = 0;
            while (i < queue.size()) {
                TransactionData transaction = queue.get(i);
                if (transaction.status == TransactionStatus.COMPLETED) {
                    queue.remove(i);
                    continue;
                }
                ++i;
            }
            if (queue.size() > 0) {
                node.setValue(queue);
            } else {
                node.setValue(null);
            }
        }
        node.forEachChild(new Tree.TreeVisitor<List<TransactionData>>(){

            @Override
            public void visitTree(Tree<List<TransactionData>> tree) {
                Repo.this.pruneCompletedTransactions(tree);
            }
        });
    }

    private long nextTransactionOrder() {
        return this.transactionOrder++;
    }

    private Path rerunTransactions(Path changedPath) {
        Tree<List<TransactionData>> rootMostTransactionNode = this.getAncestorTransactionNode(changedPath);
        Path path = rootMostTransactionNode.getPath();
        List<TransactionData> queue = this.buildTransactionQueue(rootMostTransactionNode);
        this.rerunTransactionQueue(queue, path);
        return path;
    }

    private void rerunTransactionQueue(List<TransactionData> queue, Path path) {
        if (queue.isEmpty()) {
            return;
        }
        ArrayList<18> callbacks = new ArrayList<18>();
        ArrayList<Long> setsToIgnore = new ArrayList<Long>();
        for (final TransactionData transaction : queue) {
            setsToIgnore.add(transaction.currentWriteId);
        }
        for (final TransactionData transaction : queue) {
            Path relativePath = Path.getRelative(path, transaction.path);
            boolean abortTransaction = false;
            FirebaseError abortReason = null;
            ArrayList<? extends Event> events = new ArrayList<Event>();
            assert (relativePath != null);
            if (transaction.status == TransactionStatus.NEEDS_ABORT) {
                abortTransaction = true;
                abortReason = transaction.abortReason;
                if (abortReason.getCode() != -25) {
                    events.addAll(this.serverSyncTree.ackUserWrite(transaction.currentWriteId, true, false, this.serverClock));
                }
            } else if (transaction.status == TransactionStatus.RUN) {
                if (transaction.retryCount >= 25) {
                    abortTransaction = true;
                    abortReason = FirebaseError.fromStatus(TRANSACTION_TOO_MANY_RETRIES);
                    events.addAll(this.serverSyncTree.ackUserWrite(transaction.currentWriteId, true, false, this.serverClock));
                } else {
                    Transaction.Result result;
                    Node currentNode = this.getLatestState(transaction.path, setsToIgnore);
                    transaction.currentInputSnapshot = currentNode;
                    MutableData mutableCurrent = new MutableData(currentNode);
                    FirebaseError error = null;
                    try {
                        result = transaction.handler.doTransaction(mutableCurrent);
                    }
                    catch (Throwable e) {
                        error = FirebaseError.fromException(e);
                        result = Transaction.abort();
                    }
                    if (result.isSuccess()) {
                        Long oldWriteId = transaction.currentWriteId;
                        Map<String, Object> serverValues = ServerValues.generateServerValues(this.serverClock);
                        Node newDataNode = result.getNode();
                        Node newNodeResolved = ServerValues.resolveDeferredValueSnapshot(newDataNode, serverValues);
                        transaction.currentOutputSnapshotRaw = newDataNode;
                        transaction.currentOutputSnapshotResolved = newNodeResolved;
                        transaction.currentWriteId = this.getNextWriteId();
                        setsToIgnore.remove(oldWriteId);
                        events.addAll(this.serverSyncTree.applyUserOverwrite(transaction.path, newDataNode, newNodeResolved, transaction.currentWriteId, transaction.applyLocally, false));
                        events.addAll(this.serverSyncTree.ackUserWrite(oldWriteId, true, false, this.serverClock));
                    } else {
                        abortTransaction = true;
                        abortReason = error;
                        events.addAll(this.serverSyncTree.ackUserWrite(transaction.currentWriteId, true, false, this.serverClock));
                    }
                }
            }
            this.postEvents(events);
            if (!abortTransaction) continue;
            transaction.status = TransactionStatus.COMPLETED;
            Firebase ref = new Firebase(this, transaction.path);
            Node lastInput = transaction.currentInputSnapshot;
            final DataSnapshot snapshot = new DataSnapshot(ref, IndexedNode.from(lastInput));
            this.scheduleNow(new Runnable(){

                @Override
                public void run() {
                    Repo.this.removeEventCallback(QuerySpec.defaultQueryAtPath(transaction.path), new ValueEventRegistration(Repo.this, transaction.outstandingListener));
                }
            });
            final FirebaseError callbackError = abortReason;
            callbacks.add(new Runnable(){

                @Override
                public void run() {
                    transaction.handler.onComplete(callbackError, false, snapshot);
                }
            });
        }
        this.pruneCompletedTransactions(this.transactionQueueTree);
        for (int i = 0; i < callbacks.size(); ++i) {
            this.postEvent((Runnable)callbacks.get(i));
        }
        this.sendAllReadyTransactions();
    }

    private Tree<List<TransactionData>> getAncestorTransactionNode(Path path) {
        Tree<List<TransactionData>> transactionNode = this.transactionQueueTree;
        while (!path.isEmpty() && transactionNode.getValue() == null) {
            transactionNode = transactionNode.subTree(new Path(path.getFront()));
            path = path.popFront();
        }
        return transactionNode;
    }

    private List<TransactionData> buildTransactionQueue(Tree<List<TransactionData>> transactionNode) {
        ArrayList<TransactionData> queue = new ArrayList<TransactionData>();
        this.aggregateTransactionQueues(queue, transactionNode);
        Collections.sort(queue);
        return queue;
    }

    private void aggregateTransactionQueues(final List<TransactionData> queue, Tree<List<TransactionData>> node) {
        List<TransactionData> childQueue = node.getValue();
        if (childQueue != null) {
            queue.addAll(childQueue);
        }
        node.forEachChild(new Tree.TreeVisitor<List<TransactionData>>(){

            @Override
            public void visitTree(Tree<List<TransactionData>> tree) {
                Repo.this.aggregateTransactionQueues(queue, tree);
            }
        });
    }

    private Path abortTransactions(Path path, final int reason) {
        Path affectedPath = this.getAncestorTransactionNode(path).getPath();
        if (this.transactionLogger.logsDebug()) {
            this.operationLogger.debug("Aborting transactions for path: " + path + ". Affected: " + affectedPath);
        }
        Tree<List<TransactionData>> transactionNode = this.transactionQueueTree.subTree(path);
        transactionNode.forEachAncestor(new Tree.TreeFilter<List<TransactionData>>(){

            @Override
            public boolean filterTreeNode(Tree<List<TransactionData>> tree) {
                Repo.this.abortTransactionsAtNode(tree, reason);
                return false;
            }
        });
        this.abortTransactionsAtNode(transactionNode, reason);
        transactionNode.forEachDescendant(new Tree.TreeVisitor<List<TransactionData>>(){

            @Override
            public void visitTree(Tree<List<TransactionData>> tree) {
                Repo.this.abortTransactionsAtNode(tree, reason);
            }
        });
        return affectedPath;
    }

    private void abortTransactionsAtNode(Tree<List<TransactionData>> node, int reason) {
        List<TransactionData> queue = node.getValue();
        ArrayList<? extends Event> events = new ArrayList<Event>();
        if (queue != null) {
            FirebaseError abortError;
            ArrayList<22> callbacks = new ArrayList<22>();
            if (reason == -9) {
                abortError = FirebaseError.fromStatus(TRANSACTION_OVERRIDE_BY_SET);
            } else {
                Utilities.hardAssert(reason == -25, "Unknown transaction abort reason: " + reason);
                abortError = FirebaseError.fromCode(-25);
            }
            int lastSent = -1;
            for (int i = 0; i < queue.size(); ++i) {
                final TransactionData transactionData = queue.get(i);
                if (transactionData.status == TransactionStatus.SENT_NEEDS_ABORT) continue;
                if (transactionData.status == TransactionStatus.SENT) {
                    assert (lastSent == i - 1);
                    lastSent = i;
                    transactionData.status = TransactionStatus.SENT_NEEDS_ABORT;
                    transactionData.abortReason = abortError;
                    continue;
                }
                assert (transactionData.status == TransactionStatus.RUN);
                this.removeEventCallback(QuerySpec.defaultQueryAtPath(transactionData.path), new ValueEventRegistration(this, transactionData.outstandingListener));
                if (reason == -9) {
                    events.addAll(this.serverSyncTree.ackUserWrite(transactionData.currentWriteId, true, false, this.serverClock));
                } else {
                    Utilities.hardAssert(reason == -25, "Unknown transaction abort reason: " + reason);
                }
                callbacks.add(new Runnable(){

                    @Override
                    public void run() {
                        transactionData.handler.onComplete(abortError, false, null);
                    }
                });
            }
            if (lastSent == -1) {
                node.setValue(null);
            } else {
                node.setValue(queue.subList(0, lastSent + 1));
            }
            this.postEvents(events);
            for (Runnable runnable : callbacks) {
                this.postEvent(runnable);
            }
        }
    }

    private static class TransactionData
    implements Comparable<TransactionData> {
        private Path path;
        private Transaction.Handler handler;
        private ValueEventListener outstandingListener;
        private TransactionStatus status;
        private long order;
        private boolean applyLocally;
        private int retryCount;
        private FirebaseError abortReason;
        private long currentWriteId;
        private Node currentInputSnapshot;
        private Node currentOutputSnapshotRaw;
        private Node currentOutputSnapshotResolved;

        private TransactionData(Path path, Transaction.Handler handler, ValueEventListener outstandingListener, TransactionStatus status, boolean applyLocally, long order) {
            this.path = path;
            this.handler = handler;
            this.outstandingListener = outstandingListener;
            this.status = status;
            this.retryCount = 0;
            this.applyLocally = applyLocally;
            this.order = order;
            this.abortReason = null;
            this.currentInputSnapshot = null;
            this.currentOutputSnapshotRaw = null;
            this.currentOutputSnapshotResolved = null;
        }

        @Override
        public int compareTo(TransactionData o) {
            if (this.order < o.order) {
                return -1;
            }
            if (this.order == o.order) {
                return 0;
            }
            return 1;
        }
    }

    private static enum TransactionStatus {
        INITIALIZING,
        RUN,
        SENT,
        COMPLETED,
        SENT_NEEDS_ABORT,
        NEEDS_ABORT;

    }

    private static class FirebaseAppImpl
    extends FirebaseApp {
        protected FirebaseAppImpl(Repo repo) {
            super(repo);
        }
    }
}

