/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.FirebaseException;
import com.firebase.client.RunLoop;
import com.firebase.client.core.Context;
import com.firebase.client.core.Repo;
import com.firebase.client.core.RepoInfo;
import java.util.HashMap;
import java.util.Map;

public class RepoManager {
    private static final RepoManager instance = new RepoManager();
    private final Map<Context, Map<String, Repo>> repos = new HashMap<Context, Map<String, Repo>>();

    public static Repo getRepo(Context ctx, RepoInfo info) throws FirebaseException {
        return instance.getLocalRepo(ctx, info);
    }

    public static void interrupt(Context ctx) {
        instance.interruptInternal(ctx);
    }

    public static void interrupt(final Repo repo) {
        repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                repo.interrupt();
            }
        });
    }

    public static void resume(final Repo repo) {
        repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                repo.resume();
            }
        });
    }

    public static void resume(Context ctx) {
        instance.resumeInternal(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Repo getLocalRepo(Context ctx, RepoInfo info) throws FirebaseException {
        ctx.freeze();
        String repoHash = "https://" + info.host + "/" + info.namespace;
        Map<Context, Map<String, Repo>> map = this.repos;
        synchronized (map) {
            Map<Object, Object> innerMap;
            if (!this.repos.containsKey(ctx)) {
                innerMap = new HashMap();
                this.repos.put(ctx, innerMap);
            }
            if (!(innerMap = this.repos.get(ctx)).containsKey(repoHash)) {
                Repo repo = new Repo(info, ctx);
                innerMap.put(repoHash, repo);
                return repo;
            }
            return (Repo)innerMap.get(repoHash);
        }
    }

    private void interruptInternal(final Context ctx) {
        RunLoop runLoop = ctx.getRunLoop();
        if (runLoop != null) {
            runLoop.scheduleNow(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = RepoManager.this.repos;
                    synchronized (map) {
                        boolean allEmpty = true;
                        if (RepoManager.this.repos.containsKey(ctx)) {
                            for (Repo repo : ((Map)RepoManager.this.repos.get(ctx)).values()) {
                                repo.interrupt();
                                allEmpty = allEmpty && !repo.hasListeners();
                            }
                            if (allEmpty) {
                                ctx.stop();
                            }
                        }
                    }
                }
            });
        }
    }

    private void resumeInternal(final Context ctx) {
        RunLoop runLoop = ctx.getRunLoop();
        if (runLoop != null) {
            runLoop.scheduleNow(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = RepoManager.this.repos;
                    synchronized (map) {
                        if (RepoManager.this.repos.containsKey(ctx)) {
                            for (Repo repo : ((Map)RepoManager.this.repos.get(ctx)).values()) {
                                repo.resume();
                            }
                        }
                    }
                }
            });
        }
    }
}

