/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.FirebaseError;
import com.firebase.client.collection.LLRBNode;
import com.firebase.client.core.CompoundWrite;
import com.firebase.client.core.Context;
import com.firebase.client.core.EventRegistration;
import com.firebase.client.core.Path;
import com.firebase.client.core.ServerValues;
import com.firebase.client.core.SyncPoint;
import com.firebase.client.core.Tag;
import com.firebase.client.core.UserWriteRecord;
import com.firebase.client.core.WriteTree;
import com.firebase.client.core.WriteTreeRef;
import com.firebase.client.core.operation.AckUserWrite;
import com.firebase.client.core.operation.ListenComplete;
import com.firebase.client.core.operation.Merge;
import com.firebase.client.core.operation.Operation;
import com.firebase.client.core.operation.OperationSource;
import com.firebase.client.core.operation.Overwrite;
import com.firebase.client.core.persistence.PersistenceManager;
import com.firebase.client.core.utilities.ImmutableTree;
import com.firebase.client.core.view.CacheNode;
import com.firebase.client.core.view.Change;
import com.firebase.client.core.view.DataEvent;
import com.firebase.client.core.view.Event;
import com.firebase.client.core.view.QuerySpec;
import com.firebase.client.core.view.View;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.EmptyNode;
import com.firebase.client.snapshot.IndexedNode;
import com.firebase.client.snapshot.NamedNode;
import com.firebase.client.snapshot.Node;
import com.firebase.client.utilities.Clock;
import com.firebase.client.utilities.LogWrapper;
import com.firebase.client.utilities.Pair;
import com.firebase.client.utilities.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class SyncTree {
    private ImmutableTree<SyncPoint> syncPointTree = ImmutableTree.emptyInstance();
    private final WriteTree pendingWriteTree = new WriteTree();
    private final Map<Tag, QuerySpec> tagToQueryMap = new HashMap<Tag, QuerySpec>();
    private final Map<QuerySpec, Tag> queryToTagMap = new HashMap<QuerySpec, Tag>();
    private final Set<QuerySpec> keepSyncedQueries = new HashSet<QuerySpec>();
    private final ListenProvider listenProvider;
    private final PersistenceManager persistenceManager;
    private final LogWrapper logger;
    private static final EventRegistration keepSyncedEventRegistration = new EventRegistration(){

        @Override
        public boolean respondsTo(Event.EventType eventType) {
            return false;
        }

        @Override
        public DataEvent createEvent(Change change, QuerySpec query) {
            return null;
        }

        @Override
        public void fireEvent(DataEvent dataEvent) {
        }

        @Override
        public void fireCancelEvent(FirebaseError error) {
        }
    };
    private long nextQueryTag = 1L;

    public SyncTree(Context context, PersistenceManager persistenceManager, ListenProvider listenProvider) {
        this.listenProvider = listenProvider;
        this.persistenceManager = persistenceManager;
        this.logger = context.getLogger("SyncTree");
    }

    public boolean isEmpty() {
        return this.syncPointTree.isEmpty();
    }

    public List<? extends Event> applyUserOverwrite(final Path path, final Node newDataUnresolved, final Node newData, final long writeId, final boolean visible, final boolean persist) {
        Utilities.hardAssert(visible || !persist, "We shouldn't be persisting non-visible writes.");
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                if (persist) {
                    SyncTree.this.persistenceManager.saveUserOverwrite(path, newDataUnresolved, writeId);
                }
                SyncTree.this.pendingWriteTree.addOverwrite(path, newData, writeId, visible);
                if (!visible) {
                    return Collections.emptyList();
                }
                return SyncTree.this.applyOperationToSyncPoints(new Overwrite(OperationSource.USER, path, newData));
            }
        });
    }

    public List<? extends Event> applyUserMerge(final Path path, final CompoundWrite unresolvedChildren, final CompoundWrite children, final long writeId, final boolean persist) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() throws Exception {
                if (persist) {
                    SyncTree.this.persistenceManager.saveUserMerge(path, unresolvedChildren, writeId);
                }
                SyncTree.this.pendingWriteTree.addMerge(path, children, writeId);
                return SyncTree.this.applyOperationToSyncPoints(new Merge(OperationSource.USER, path, children));
            }
        });
    }

    public List<? extends Event> ackUserWrite(final long writeId, final boolean revert, final boolean persist, final Clock serverClock) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                if (persist) {
                    SyncTree.this.persistenceManager.removeUserWrite(writeId);
                }
                UserWriteRecord write = SyncTree.this.pendingWriteTree.getWrite(writeId);
                boolean needToReevaluate = SyncTree.this.pendingWriteTree.removeWrite(writeId);
                if (write.isVisible() && !revert) {
                    Map<String, Object> serverValues = ServerValues.generateServerValues(serverClock);
                    if (write.isOverwrite()) {
                        Node resolvedNode = ServerValues.resolveDeferredValueSnapshot(write.getOverwrite(), serverValues);
                        SyncTree.this.persistenceManager.applyUserWriteToServerCache(write.getPath(), resolvedNode);
                    } else {
                        CompoundWrite resolvedMerge = ServerValues.resolveDeferredValueMerge(write.getMerge(), serverValues);
                        SyncTree.this.persistenceManager.applyUserWriteToServerCache(write.getPath(), resolvedMerge);
                    }
                }
                if (!needToReevaluate) {
                    return Collections.emptyList();
                }
                ImmutableTree<Boolean> affectedTree = ImmutableTree.emptyInstance();
                if (write.isOverwrite()) {
                    affectedTree = affectedTree.set(Path.getEmptyPath(), true);
                } else {
                    for (Map.Entry<Path, Node> entry : write.getMerge()) {
                        affectedTree = affectedTree.set(entry.getKey(), true);
                    }
                }
                return SyncTree.this.applyOperationToSyncPoints(new AckUserWrite(write.getPath(), affectedTree, revert));
            }
        });
    }

    public List<? extends Event> removeAllWrites() {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() throws Exception {
                SyncTree.this.persistenceManager.removeAllUserWrites();
                List<UserWriteRecord> purgedWrites = SyncTree.this.pendingWriteTree.purgeAllWrites();
                if (purgedWrites.isEmpty()) {
                    return Collections.emptyList();
                }
                ImmutableTree<Boolean> affectedTree = new ImmutableTree<Boolean>(true);
                return SyncTree.this.applyOperationToSyncPoints(new AckUserWrite(Path.getEmptyPath(), affectedTree, true));
            }
        });
    }

    public List<? extends Event> applyServerOverwrite(final Path path, final Node newData) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                SyncTree.this.persistenceManager.updateServerCache(QuerySpec.defaultQueryAtPath(path), newData);
                return SyncTree.this.applyOperationToSyncPoints(new Overwrite(OperationSource.SERVER, path, newData));
            }
        });
    }

    public List<? extends Event> applyServerMerge(final Path path, final Map<Path, Node> changedChildren) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                CompoundWrite merge = CompoundWrite.fromPathMerge(changedChildren);
                SyncTree.this.persistenceManager.updateServerCache(path, merge);
                return SyncTree.this.applyOperationToSyncPoints(new Merge(OperationSource.SERVER, path, merge));
            }
        });
    }

    public List<? extends Event> applyListenComplete(final Path path) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                SyncTree.this.persistenceManager.setQueryComplete(QuerySpec.defaultQueryAtPath(path));
                return SyncTree.this.applyOperationToSyncPoints(new ListenComplete(OperationSource.SERVER, path));
            }
        });
    }

    public List<? extends Event> applyTaggedListenComplete(final Tag tag) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                QuerySpec query = SyncTree.this.queryForTag(tag);
                if (query != null) {
                    SyncTree.this.persistenceManager.setQueryComplete(query);
                    ListenComplete op = new ListenComplete(OperationSource.forServerTaggedQuery(query.getParams()), Path.getEmptyPath());
                    return SyncTree.this.applyTaggedOperation(query, op);
                }
                return Collections.emptyList();
            }
        });
    }

    private List<? extends Event> applyTaggedOperation(QuerySpec query, Operation operation) {
        Path queryPath = query.getPath();
        SyncPoint syncPoint = this.syncPointTree.get(queryPath);
        assert (syncPoint != null) : "Missing sync point for query tag that we're tracking";
        WriteTreeRef writesCache = this.pendingWriteTree.childWrites(queryPath);
        return syncPoint.applyOperation(operation, writesCache, null);
    }

    public List<? extends Event> applyTaggedQueryOverwrite(final Path path, final Node snap, final Tag tag) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                QuerySpec query = SyncTree.this.queryForTag(tag);
                if (query != null) {
                    Path relativePath = Path.getRelative(query.getPath(), path);
                    QuerySpec queryToOverwrite = relativePath.isEmpty() ? query : QuerySpec.defaultQueryAtPath(path);
                    SyncTree.this.persistenceManager.updateServerCache(queryToOverwrite, snap);
                    Overwrite op = new Overwrite(OperationSource.forServerTaggedQuery(query.getParams()), relativePath, snap);
                    return SyncTree.this.applyTaggedOperation(query, op);
                }
                return Collections.emptyList();
            }
        });
    }

    public List<? extends Event> applyTaggedQueryMerge(final Path path, final Map<Path, Node> changedChildren, final Tag tag) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                QuerySpec query = SyncTree.this.queryForTag(tag);
                if (query != null) {
                    Path relativePath = Path.getRelative(query.getPath(), path);
                    CompoundWrite merge = CompoundWrite.fromPathMerge(changedChildren);
                    SyncTree.this.persistenceManager.updateServerCache(path, merge);
                    Merge op = new Merge(OperationSource.forServerTaggedQuery(query.getParams()), relativePath, merge);
                    return SyncTree.this.applyTaggedOperation(query, op);
                }
                return Collections.emptyList();
            }
        });
    }

    public List<? extends Event> addEventRegistration(final QuerySpec query, final EventRegistration eventRegistration) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                CacheNode serverCache;
                Path path = query.getPath();
                Node serverCacheNode = null;
                boolean foundAncestorDefaultView = false;
                ImmutableTree tree = SyncTree.this.syncPointTree;
                Path currentPath = path;
                while (!tree.isEmpty() && serverCacheNode == null) {
                    SyncPoint currentSyncPoint = (SyncPoint)tree.getValue();
                    if (currentSyncPoint != null) {
                        serverCacheNode = currentSyncPoint.getCompleteServerCache(currentPath);
                        foundAncestorDefaultView = foundAncestorDefaultView || currentSyncPoint.hasCompleteView();
                    }
                    ChildKey front = currentPath.isEmpty() ? ChildKey.fromString("") : currentPath.getFront();
                    tree = tree.getChild(front);
                    currentPath = currentPath.popFront();
                }
                SyncPoint syncPoint = (SyncPoint)SyncTree.this.syncPointTree.get(path);
                if (syncPoint == null) {
                    syncPoint = new SyncPoint(SyncTree.this.persistenceManager);
                    SyncTree.this.syncPointTree = SyncTree.this.syncPointTree.set(path, syncPoint);
                } else {
                    foundAncestorDefaultView = foundAncestorDefaultView || syncPoint.hasCompleteView();
                    serverCacheNode = serverCacheNode != null ? serverCacheNode : syncPoint.getCompleteServerCache(Path.getEmptyPath());
                }
                SyncTree.this.persistenceManager.setQueryActive(query);
                if (serverCacheNode != null) {
                    serverCache = new CacheNode(IndexedNode.from(serverCacheNode, query.getIndex()), true, false);
                } else {
                    CacheNode persistentServerCache = SyncTree.this.persistenceManager.serverCache(query);
                    if (persistentServerCache.isFullyInitialized()) {
                        serverCache = persistentServerCache;
                    } else {
                        serverCacheNode = EmptyNode.Empty();
                        ImmutableTree subtree = SyncTree.this.syncPointTree.subtree(path);
                        for (Map.Entry entry : subtree.getChildren()) {
                            Node completeCache;
                            SyncPoint childSyncPoint = (SyncPoint)entry.getValue().getValue();
                            if (childSyncPoint == null || (completeCache = childSyncPoint.getCompleteServerCache(Path.getEmptyPath())) == null) continue;
                            serverCacheNode = serverCacheNode.updateImmediateChild(entry.getKey(), completeCache);
                        }
                        for (NamedNode namedNode : persistentServerCache.getNode()) {
                            if (serverCacheNode.hasChild(namedNode.getName())) continue;
                            serverCacheNode = serverCacheNode.updateImmediateChild(namedNode.getName(), namedNode.getNode());
                        }
                        serverCache = new CacheNode(IndexedNode.from(serverCacheNode, query.getIndex()), false, false);
                    }
                }
                boolean viewAlreadyExists = syncPoint.viewExistsForQuery(query);
                if (!viewAlreadyExists && !query.loadsAllData()) {
                    assert (!SyncTree.this.queryToTagMap.containsKey(query)) : "View does not exist but we have a tag";
                    Tag tag = SyncTree.this.getNextQueryTag();
                    SyncTree.this.queryToTagMap.put(query, tag);
                    SyncTree.this.tagToQueryMap.put(tag, query);
                }
                WriteTreeRef writesCache = SyncTree.this.pendingWriteTree.childWrites(path);
                List<DataEvent> events = syncPoint.addEventRegistration(query, eventRegistration, writesCache, serverCache);
                if (!viewAlreadyExists && !foundAncestorDefaultView) {
                    View view = syncPoint.viewForQuery(query);
                    SyncTree.this.setupListener(query, view);
                }
                return events;
            }
        });
    }

    public List<Event> removeEventRegistration(QuerySpec query, EventRegistration eventRegistration) {
        return this.removeEventRegistration(query, eventRegistration, null);
    }

    public List<Event> removeEventRegistration(final QuerySpec query, final EventRegistration eventRegistration, final FirebaseError cancelError) {
        return this.persistenceManager.runInTransaction(new Callable<List<Event>>(){

            @Override
            public List<Event> call() {
                Path path = query.getPath();
                SyncPoint maybeSyncPoint = (SyncPoint)SyncTree.this.syncPointTree.get(path);
                List<Event> cancelEvents = new ArrayList<Event>();
                if (maybeSyncPoint != null && (query.isDefault() || maybeSyncPoint.viewExistsForQuery(query))) {
                    ImmutableTree subtree;
                    Pair<List<QuerySpec>, List<Event>> removedAndEvents = maybeSyncPoint.removeEventRegistration(query, eventRegistration, cancelError);
                    if (maybeSyncPoint.isEmpty()) {
                        SyncTree.this.syncPointTree = SyncTree.this.syncPointTree.remove(path);
                    }
                    List<QuerySpec> removed = removedAndEvents.getFirst();
                    cancelEvents = removedAndEvents.getSecond();
                    boolean removingDefault = false;
                    for (QuerySpec queryRemoved : removed) {
                        SyncTree.this.persistenceManager.setQueryInactive(query);
                        removingDefault = removingDefault || queryRemoved.loadsAllData();
                    }
                    ImmutableTree currentTree = SyncTree.this.syncPointTree;
                    boolean covered = currentTree.getValue() != null && ((SyncPoint)currentTree.getValue()).hasCompleteView();
                    for (ChildKey component : path) {
                        currentTree = currentTree.getChild(component);
                        boolean bl = covered = covered || currentTree.getValue() != null && ((SyncPoint)currentTree.getValue()).hasCompleteView();
                        if (!covered && !currentTree.isEmpty()) continue;
                        break;
                    }
                    if (removingDefault && !covered && !(subtree = SyncTree.this.syncPointTree.subtree(path)).isEmpty()) {
                        List newViews = SyncTree.this.collectDistinctViewsForSubTree(subtree);
                        for (View view : newViews) {
                            ListenContainer container = new ListenContainer(view);
                            QuerySpec newQuery = view.getQuery();
                            SyncTree.this.listenProvider.startListening(SyncTree.this.queryForListening(newQuery), container.tag, container, container);
                        }
                    }
                    if (!covered && !removed.isEmpty() && cancelError == null) {
                        if (removingDefault) {
                            SyncTree.this.listenProvider.stopListening(SyncTree.this.queryForListening(query), null);
                        } else {
                            for (QuerySpec queryToRemove : removed) {
                                Tag tag = SyncTree.this.tagForQuery(queryToRemove);
                                assert (tag != null);
                                SyncTree.this.listenProvider.stopListening(SyncTree.this.queryForListening(queryToRemove), tag);
                            }
                        }
                    }
                    SyncTree.this.removeTags(removed);
                }
                return cancelEvents;
            }
        });
    }

    public void keepSynced(QuerySpec query, boolean keep) {
        if (keep && !this.keepSyncedQueries.contains(query)) {
            this.addEventRegistration(query, keepSyncedEventRegistration);
            this.keepSyncedQueries.add(query);
        } else if (!keep && this.keepSyncedQueries.contains(query)) {
            this.removeEventRegistration(query, keepSyncedEventRegistration);
            this.keepSyncedQueries.remove(query);
        }
    }

    private List<View> collectDistinctViewsForSubTree(ImmutableTree<SyncPoint> subtree) {
        ArrayList<View> accumulator = new ArrayList<View>();
        this.collectDistinctViewsForSubTree(subtree, accumulator);
        return accumulator;
    }

    private void collectDistinctViewsForSubTree(ImmutableTree<SyncPoint> subtree, List<View> accumulator) {
        SyncPoint maybeSyncPoint = subtree.getValue();
        if (maybeSyncPoint != null && maybeSyncPoint.hasCompleteView()) {
            accumulator.add(maybeSyncPoint.getCompleteView());
        } else {
            if (maybeSyncPoint != null) {
                accumulator.addAll(maybeSyncPoint.getQueryViews());
            }
            for (Map.Entry<ChildKey, ImmutableTree<SyncPoint>> entry : subtree.getChildren()) {
                this.collectDistinctViewsForSubTree(entry.getValue(), accumulator);
            }
        }
    }

    private void removeTags(List<QuerySpec> queries) {
        for (QuerySpec removedQuery : queries) {
            if (removedQuery.loadsAllData()) continue;
            Tag tag = this.tagForQuery(removedQuery);
            assert (tag != null);
            this.queryToTagMap.remove(removedQuery);
            this.tagToQueryMap.remove(tag);
        }
    }

    private QuerySpec queryForListening(QuerySpec query) {
        if (query.loadsAllData() && !query.isDefault()) {
            return QuerySpec.defaultQueryAtPath(query.getPath());
        }
        return query;
    }

    private void setupListener(QuerySpec query, View view) {
        Path path = query.getPath();
        Tag tag = this.tagForQuery(query);
        ListenContainer container = new ListenContainer(view);
        this.listenProvider.startListening(this.queryForListening(query), tag, container, container);
        ImmutableTree<SyncPoint> subtree = this.syncPointTree.subtree(path);
        if (tag != null) {
            assert (!subtree.getValue().hasCompleteView()) : "If we're adding a query, it shouldn't be shadowed";
        } else {
            subtree.foreach(new ImmutableTree.TreeVisitor<SyncPoint, Void>(){

                @Override
                public Void onNodeValue(Path relativePath, SyncPoint maybeChildSyncPoint, Void accum) {
                    if (!relativePath.isEmpty() && maybeChildSyncPoint.hasCompleteView()) {
                        QuerySpec query = maybeChildSyncPoint.getCompleteView().getQuery();
                        SyncTree.this.listenProvider.stopListening(SyncTree.this.queryForListening(query), SyncTree.this.tagForQuery(query));
                    } else {
                        for (View syncPointView : maybeChildSyncPoint.getQueryViews()) {
                            QuerySpec childQuery = syncPointView.getQuery();
                            SyncTree.this.listenProvider.stopListening(SyncTree.this.queryForListening(childQuery), SyncTree.this.tagForQuery(childQuery));
                        }
                    }
                    return null;
                }
            });
        }
    }

    private QuerySpec queryForTag(Tag tag) {
        return this.tagToQueryMap.get(tag);
    }

    private Tag tagForQuery(QuerySpec query) {
        return this.queryToTagMap.get(query);
    }

    public Node calcCompleteEventCache(Path path, List<Long> writeIdsToExclude) {
        ImmutableTree<SyncPoint> tree = this.syncPointTree;
        SyncPoint currentSyncPoint = tree.getValue();
        Node serverCache = null;
        Path pathToFollow = path;
        Path pathSoFar = Path.getEmptyPath();
        do {
            ChildKey front = pathToFollow.getFront();
            pathToFollow = pathToFollow.popFront();
            pathSoFar = pathSoFar.child(front);
            Path relativePath = Path.getRelative(pathSoFar, path);
            tree = front != null ? tree.getChild(front) : ImmutableTree.emptyInstance();
            currentSyncPoint = tree.getValue();
            if (currentSyncPoint == null) continue;
            serverCache = currentSyncPoint.getCompleteServerCache(relativePath);
        } while (!pathToFollow.isEmpty() && serverCache == null);
        return this.pendingWriteTree.calcCompleteEventCache(path, serverCache, writeIdsToExclude, true);
    }

    private Tag getNextQueryTag() {
        return new Tag(this.nextQueryTag++);
    }

    private List<Event> applyOperationToSyncPoints(Operation operation) {
        return this.applyOperationHelper(operation, this.syncPointTree, null, this.pendingWriteTree.childWrites(Path.getEmptyPath()));
    }

    private List<Event> applyOperationHelper(Operation operation, ImmutableTree<SyncPoint> syncPointTree, Node serverCache, WriteTreeRef writesCache) {
        if (operation.getPath().isEmpty()) {
            return this.applyOperationDescendantsHelper(operation, syncPointTree, serverCache, writesCache);
        }
        SyncPoint syncPoint = syncPointTree.getValue();
        if (serverCache == null && syncPoint != null) {
            serverCache = syncPoint.getCompleteServerCache(Path.getEmptyPath());
        }
        ArrayList<Event> events = new ArrayList<Event>();
        ChildKey childKey = operation.getPath().getFront();
        Operation childOperation = operation.operationForChild(childKey);
        ImmutableTree<SyncPoint> childTree = syncPointTree.getChildren().get(childKey);
        if (childTree != null && childOperation != null) {
            Node childServerCache = serverCache != null ? serverCache.getImmediateChild(childKey) : null;
            WriteTreeRef childWritesCache = writesCache.child(childKey);
            events.addAll(this.applyOperationHelper(childOperation, childTree, childServerCache, childWritesCache));
        }
        if (syncPoint != null) {
            events.addAll(syncPoint.applyOperation(operation, writesCache, serverCache));
        }
        return events;
    }

    private List<Event> applyOperationDescendantsHelper(final Operation operation, ImmutableTree<SyncPoint> syncPointTree, Node serverCache, final WriteTreeRef writesCache) {
        SyncPoint syncPoint = syncPointTree.getValue();
        final Node resolvedServerCache = serverCache == null && syncPoint != null ? syncPoint.getCompleteServerCache(Path.getEmptyPath()) : serverCache;
        final ArrayList<Event> events = new ArrayList<Event>();
        syncPointTree.getChildren().inOrderTraversal(new LLRBNode.NodeVisitor<ChildKey, ImmutableTree<SyncPoint>>(){

            @Override
            public void visitEntry(ChildKey key, ImmutableTree<SyncPoint> childTree) {
                Node childServerCache = null;
                if (resolvedServerCache != null) {
                    childServerCache = resolvedServerCache.getImmediateChild(key);
                }
                WriteTreeRef childWritesCache = writesCache.child(key);
                Operation childOperation = operation.operationForChild(key);
                if (childOperation != null) {
                    events.addAll(SyncTree.this.applyOperationDescendantsHelper(childOperation, childTree, childServerCache, childWritesCache));
                }
            }
        });
        if (syncPoint != null) {
            events.addAll(syncPoint.applyOperation(operation, writesCache, resolvedServerCache));
        }
        return events;
    }

    private class ListenContainer
    implements SyncTreeHash,
    CompletionListener {
        private final View view;
        private final Tag tag;

        public ListenContainer(View view) {
            this.view = view;
            this.tag = SyncTree.this.tagForQuery(view.getQuery());
        }

        @Override
        public String getHash() {
            Node cache = this.view.getServerCache();
            if (cache == null) {
                cache = EmptyNode.Empty();
            }
            return cache.getHash();
        }

        @Override
        public List<? extends Event> onListenComplete(FirebaseError error) {
            if (error == null) {
                QuerySpec query = this.view.getQuery();
                if (this.tag != null) {
                    return SyncTree.this.applyTaggedListenComplete(this.tag);
                }
                return SyncTree.this.applyListenComplete(query.getPath());
            }
            SyncTree.this.logger.warn("Listen at " + this.view.getQuery().getPath() + " failed: " + error.toString());
            return SyncTree.this.removeEventRegistration(this.view.getQuery(), null, error);
        }
    }

    public static interface ListenProvider {
        public void startListening(QuerySpec var1, Tag var2, SyncTreeHash var3, CompletionListener var4);

        public void stopListening(QuerySpec var1, Tag var2);
    }

    public static interface CompletionListener {
        public List<? extends Event> onListenComplete(FirebaseError var1);
    }

    public static interface SyncTreeHash {
        public String getHash();
    }
}

