/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.core.CompoundWrite;
import com.firebase.client.core.Path;
import com.firebase.client.snapshot.Node;

public class UserWriteRecord {
    private final long writeId;
    private final Path path;
    private final Node overwrite;
    private final CompoundWrite merge;
    private final boolean visible;

    public UserWriteRecord(long writeId, Path path, Node overwrite, boolean visible) {
        this.writeId = writeId;
        this.path = path;
        this.overwrite = overwrite;
        this.merge = null;
        this.visible = visible;
    }

    public UserWriteRecord(long writeId, Path path, CompoundWrite merge) {
        this.writeId = writeId;
        this.path = path;
        this.overwrite = null;
        this.merge = merge;
        this.visible = true;
    }

    public long getWriteId() {
        return this.writeId;
    }

    public Path getPath() {
        return this.path;
    }

    public Node getOverwrite() {
        if (this.overwrite == null) {
            throw new IllegalArgumentException("Can't access overwrite when write is a merge!");
        }
        return this.overwrite;
    }

    public CompoundWrite getMerge() {
        if (this.merge == null) {
            throw new IllegalArgumentException("Can't access merge when write is an overwrite!");
        }
        return this.merge;
    }

    public boolean isMerge() {
        return this.merge != null;
    }

    public boolean isOverwrite() {
        return this.overwrite != null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserWriteRecord record = (UserWriteRecord)o;
        if (this.writeId != record.writeId) {
            return false;
        }
        if (!this.path.equals(record.path)) {
            return false;
        }
        if (this.visible != record.visible) {
            return false;
        }
        if (!(this.overwrite == null ? record.overwrite == null : this.overwrite.equals(record.overwrite))) {
            return false;
        }
        return this.merge == null ? record.merge == null : this.merge.equals(record.merge);
    }

    public int hashCode() {
        int result = Long.valueOf(this.writeId).hashCode();
        result = 31 * result + Boolean.valueOf(this.visible).hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + (this.overwrite != null ? this.overwrite.hashCode() : 0);
        result = 31 * result + (this.merge != null ? this.merge.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UserWriteRecord{id=" + this.writeId + " path=" + this.path + " visible=" + this.visible + " overwrite=" + this.overwrite + " merge=" + this.merge + "}";
    }
}

