/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.DataSnapshot;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.firebase.client.ValueEventListener;
import com.firebase.client.core.EventRegistration;
import com.firebase.client.core.Repo;
import com.firebase.client.core.view.Change;
import com.firebase.client.core.view.DataEvent;
import com.firebase.client.core.view.Event;
import com.firebase.client.core.view.QuerySpec;

public class ValueEventRegistration
implements EventRegistration {
    private final Repo repo;
    private final ValueEventListener eventListener;

    public ValueEventRegistration(Repo repo, ValueEventListener eventListener) {
        this.repo = repo;
        this.eventListener = eventListener;
    }

    @Override
    public boolean respondsTo(Event.EventType eventType) {
        return eventType == Event.EventType.VALUE;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueEventRegistration && ((ValueEventRegistration)other).eventListener.equals(this.eventListener);
    }

    public int hashCode() {
        return this.eventListener.hashCode();
    }

    @Override
    public DataEvent createEvent(Change change, QuerySpec query) {
        Firebase ref = new Firebase(this.repo, query.getPath());
        DataSnapshot dataSnapshot = new DataSnapshot(ref, change.getIndexedNode());
        return new DataEvent(Event.EventType.VALUE, this, dataSnapshot, null);
    }

    @Override
    public void fireEvent(DataEvent eventData) {
        this.eventListener.onDataChange(eventData.getSnapshot());
    }

    @Override
    public void fireCancelEvent(FirebaseError error) {
        this.eventListener.onCancelled(error);
    }

    public String toString() {
        return "ValueEventRegistration";
    }
}

