/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core.operation;

import com.firebase.client.core.Path;
import com.firebase.client.core.operation.Operation;
import com.firebase.client.core.operation.OperationSource;
import com.firebase.client.core.utilities.ImmutableTree;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.utilities.Utilities;

public class AckUserWrite
extends Operation {
    private final boolean revert;
    private final ImmutableTree<Boolean> affectedTree;

    public AckUserWrite(Path path, ImmutableTree<Boolean> affectedTree, boolean revert) {
        super(Operation.OperationType.AckUserWrite, OperationSource.USER, path);
        this.affectedTree = affectedTree;
        this.revert = revert;
    }

    public ImmutableTree<Boolean> getAffectedTree() {
        return this.affectedTree;
    }

    public boolean isRevert() {
        return this.revert;
    }

    @Override
    public Operation operationForChild(ChildKey childKey) {
        if (!this.path.isEmpty()) {
            Utilities.hardAssert(this.path.getFront().equals(childKey), "operationForChild called for unrelated child.");
            return new AckUserWrite(this.path.popFront(), this.affectedTree, this.revert);
        }
        if (this.affectedTree.getValue() != null) {
            Utilities.hardAssert(this.affectedTree.getChildren().isEmpty(), "affectedTree should not have overlapping affected paths.");
            return this;
        }
        ImmutableTree<Boolean> childTree = this.affectedTree.subtree(new Path(childKey));
        return new AckUserWrite(Path.getEmptyPath(), childTree, this.revert);
    }

    public String toString() {
        return String.format("AckUserWrite { path=%s, revert=%s, affectedTree=%s }", this.getPath(), this.revert, this.affectedTree);
    }
}

