/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core.operation;

import com.firebase.client.core.CompoundWrite;
import com.firebase.client.core.Path;
import com.firebase.client.core.operation.Operation;
import com.firebase.client.core.operation.OperationSource;
import com.firebase.client.core.operation.Overwrite;
import com.firebase.client.snapshot.ChildKey;

public class Merge
extends Operation {
    private final CompoundWrite children;

    public Merge(OperationSource source, Path path, CompoundWrite children) {
        super(Operation.OperationType.Merge, source, path);
        this.children = children;
    }

    public CompoundWrite getChildren() {
        return this.children;
    }

    @Override
    public Operation operationForChild(ChildKey childKey) {
        if (this.path.isEmpty()) {
            CompoundWrite childTree = this.children.childCompoundWrite(new Path(childKey));
            if (childTree.isEmpty()) {
                return null;
            }
            if (childTree.rootWrite() != null) {
                return new Overwrite(this.source, Path.getEmptyPath(), childTree.rootWrite());
            }
            return new Merge(this.source, Path.getEmptyPath(), childTree);
        }
        if (this.path.getFront().equals(childKey)) {
            return new Merge(this.source, this.path.popFront(), this.children);
        }
        return null;
    }

    public String toString() {
        return String.format("Merge { path=%s, source=%s, children=%s }", this.getPath(), this.getSource(), this.children);
    }
}

