/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core.persistence;

import com.firebase.client.core.Path;
import com.firebase.client.core.persistence.CachePolicy;
import com.firebase.client.core.persistence.PersistenceStorageEngine;
import com.firebase.client.core.persistence.PruneForest;
import com.firebase.client.core.persistence.TrackedQuery;
import com.firebase.client.core.utilities.ImmutableTree;
import com.firebase.client.core.utilities.Predicate;
import com.firebase.client.core.view.QueryParams;
import com.firebase.client.core.view.QuerySpec;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.utilities.Clock;
import com.firebase.client.utilities.LogWrapper;
import com.firebase.client.utilities.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TrackedQueryManager {
    private static final Predicate<Map<QueryParams, TrackedQuery>> HAS_DEFAULT_COMPLETE_PREDICATE = new Predicate<Map<QueryParams, TrackedQuery>>(){

        @Override
        public boolean evaluate(Map<QueryParams, TrackedQuery> trackedQueries) {
            TrackedQuery trackedQuery = trackedQueries.get(QueryParams.DEFAULT_PARAMS);
            return trackedQuery != null && trackedQuery.complete;
        }
    };
    private static final Predicate<Map<QueryParams, TrackedQuery>> HAS_ACTIVE_DEFAULT_PREDICATE = new Predicate<Map<QueryParams, TrackedQuery>>(){

        @Override
        public boolean evaluate(Map<QueryParams, TrackedQuery> trackedQueries) {
            TrackedQuery trackedQuery = trackedQueries.get(QueryParams.DEFAULT_PARAMS);
            return trackedQuery != null && trackedQuery.active;
        }
    };
    private static final Predicate<TrackedQuery> IS_QUERY_PRUNABLE_PREDICATE = new Predicate<TrackedQuery>(){

        @Override
        public boolean evaluate(TrackedQuery query) {
            return !query.active;
        }
    };
    private static final Predicate<TrackedQuery> IS_QUERY_UNPRUNABLE_PREDICATE = new Predicate<TrackedQuery>(){

        @Override
        public boolean evaluate(TrackedQuery query) {
            return !IS_QUERY_PRUNABLE_PREDICATE.evaluate(query);
        }
    };
    private ImmutableTree<Map<QueryParams, TrackedQuery>> trackedQueryTree;
    private final PersistenceStorageEngine storageLayer;
    private final LogWrapper logger;
    private final Clock clock;
    private long currentQueryId = 0L;

    private static void assertValidTrackedQuery(QuerySpec query) {
        Utilities.hardAssert(!query.loadsAllData() || query.isDefault(), "Can't have tracked non-default query that loads all data");
    }

    private static QuerySpec normalizeQuery(QuerySpec query) {
        return query.loadsAllData() ? QuerySpec.defaultQueryAtPath(query.getPath()) : query;
    }

    public TrackedQueryManager(PersistenceStorageEngine storageLayer, LogWrapper logger, Clock clock) {
        this.storageLayer = storageLayer;
        this.logger = logger;
        this.clock = clock;
        this.trackedQueryTree = new ImmutableTree<Object>(null);
        this.resetPreviouslyActiveTrackedQueries();
        List<TrackedQuery> trackedQueries = this.storageLayer.loadTrackedQueries();
        for (TrackedQuery query : trackedQueries) {
            this.currentQueryId = Math.max(query.id + 1L, this.currentQueryId);
            this.cacheTrackedQuery(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPreviouslyActiveTrackedQueries() {
        try {
            this.storageLayer.beginTransaction();
            this.storageLayer.resetPreviouslyActiveTrackedQueries(this.clock.millis());
            this.storageLayer.setTransactionSuccessful();
        }
        finally {
            this.storageLayer.endTransaction();
        }
    }

    public TrackedQuery findTrackedQuery(QuerySpec query) {
        Map<QueryParams, TrackedQuery> set = this.trackedQueryTree.get((query = TrackedQueryManager.normalizeQuery(query)).getPath());
        return set != null ? set.get(query.getParams()) : null;
    }

    public void removeTrackedQuery(QuerySpec query) {
        query = TrackedQueryManager.normalizeQuery(query);
        TrackedQuery trackedQuery = this.findTrackedQuery(query);
        assert (trackedQuery != null) : "Query must exist to be removed.";
        this.storageLayer.deleteTrackedQuery(trackedQuery.id);
        Map<QueryParams, TrackedQuery> trackedQueries = this.trackedQueryTree.get(query.getPath());
        trackedQueries.remove(query.getParams());
        if (trackedQueries.isEmpty()) {
            this.trackedQueryTree = this.trackedQueryTree.remove(query.getPath());
        }
    }

    public void setQueryActive(QuerySpec query) {
        this.setQueryActiveFlag(query, true);
    }

    public void setQueryInactive(QuerySpec query) {
        this.setQueryActiveFlag(query, false);
    }

    private void setQueryActiveFlag(QuerySpec query, boolean isActive) {
        query = TrackedQueryManager.normalizeQuery(query);
        TrackedQuery trackedQuery = this.findTrackedQuery(query);
        long lastUse = this.clock.millis();
        if (trackedQuery != null) {
            trackedQuery = trackedQuery.updateLastUse(lastUse).setActiveState(isActive);
        } else {
            assert (isActive) : "If we're setting the query to inactive, we should already be tracking it!";
            trackedQuery = new TrackedQuery(this.currentQueryId++, query, lastUse, false, isActive);
        }
        this.saveTrackedQuery(trackedQuery);
    }

    public void setQueryCompleteIfExists(QuerySpec query) {
        TrackedQuery trackedQuery = this.findTrackedQuery(query = TrackedQueryManager.normalizeQuery(query));
        if (trackedQuery != null && !trackedQuery.complete) {
            this.saveTrackedQuery(trackedQuery.setComplete());
        }
    }

    public void setQueriesComplete(Path path) {
        this.trackedQueryTree.subtree(path).foreach(new ImmutableTree.TreeVisitor<Map<QueryParams, TrackedQuery>, Void>(){

            @Override
            public Void onNodeValue(Path relativePath, Map<QueryParams, TrackedQuery> value, Void accum) {
                for (Map.Entry<QueryParams, TrackedQuery> e : value.entrySet()) {
                    TrackedQuery trackedQuery = e.getValue();
                    if (trackedQuery.complete) continue;
                    TrackedQueryManager.this.saveTrackedQuery(trackedQuery.setComplete());
                }
                return null;
            }
        });
    }

    public boolean isQueryComplete(QuerySpec query) {
        if (this.includedInDefaultCompleteQuery(query.getPath())) {
            return true;
        }
        if (query.loadsAllData()) {
            return false;
        }
        Map<QueryParams, TrackedQuery> trackedQueries = this.trackedQueryTree.get(query.getPath());
        return trackedQueries != null && trackedQueries.containsKey(query.getParams()) && trackedQueries.get((Object)query.getParams()).complete;
    }

    public PruneForest pruneOldQueries(CachePolicy cachePolicy) {
        List<TrackedQuery> prunable = this.getQueriesMatching(IS_QUERY_PRUNABLE_PREDICATE);
        long countToPrune = TrackedQueryManager.calculateCountToPrune(cachePolicy, prunable.size());
        PruneForest forest = new PruneForest();
        if (this.logger.logsDebug()) {
            this.logger.debug("Pruning old queries.  Prunable: " + prunable.size() + " Count to prune: " + countToPrune);
        }
        Collections.sort(prunable, new Comparator<TrackedQuery>(){

            @Override
            public int compare(TrackedQuery q1, TrackedQuery q2) {
                return Utilities.compareLongs(q1.lastUse, q2.lastUse);
            }
        });
        int i = 0;
        while ((long)i < countToPrune) {
            TrackedQuery toPrune = prunable.get(i);
            forest = forest.prune(toPrune.querySpec.getPath());
            this.removeTrackedQuery(toPrune.querySpec);
            ++i;
        }
        for (i = (int)countToPrune; i < prunable.size(); ++i) {
            TrackedQuery toKeep = prunable.get(i);
            forest = forest.keep(toKeep.querySpec.getPath());
        }
        List<TrackedQuery> unprunable = this.getQueriesMatching(IS_QUERY_UNPRUNABLE_PREDICATE);
        if (this.logger.logsDebug()) {
            this.logger.debug("Unprunable queries: " + unprunable.size());
        }
        for (TrackedQuery toKeep : unprunable) {
            forest = forest.keep(toKeep.querySpec.getPath());
        }
        return forest;
    }

    private static long calculateCountToPrune(CachePolicy cachePolicy, long prunableCount) {
        long countToKeep = prunableCount;
        float percentToKeep = 1.0f - cachePolicy.getPercentOfQueriesToPruneAtOnce();
        countToKeep = (long)Math.floor((float)countToKeep * percentToKeep);
        countToKeep = Math.min(countToKeep, cachePolicy.getMaxNumberOfQueriesToKeep());
        return prunableCount - countToKeep;
    }

    public Set<ChildKey> getKnownCompleteChildren(Path path) {
        assert (!this.isQueryComplete(QuerySpec.defaultQueryAtPath(path))) : "Path is fully complete.";
        HashSet<ChildKey> completeChildren = new HashSet<ChildKey>();
        Set<Long> queryIds = this.filteredQueryIdsAtPath(path);
        if (!queryIds.isEmpty()) {
            completeChildren.addAll(this.storageLayer.loadTrackedQueryKeys(queryIds));
        }
        for (Map.Entry<ChildKey, ImmutableTree<Map<QueryParams, TrackedQuery>>> entry : this.trackedQueryTree.subtree(path).getChildren()) {
            ChildKey childKey = entry.getKey();
            ImmutableTree<Map<QueryParams, TrackedQuery>> childTree = entry.getValue();
            if (childTree.getValue() == null || !HAS_DEFAULT_COMPLETE_PREDICATE.evaluate(childTree.getValue())) continue;
            completeChildren.add(childKey);
        }
        return completeChildren;
    }

    public void ensureCompleteTrackedQuery(Path path) {
        if (!this.includedInDefaultCompleteQuery(path)) {
            QuerySpec querySpec = QuerySpec.defaultQueryAtPath(path);
            TrackedQuery trackedQuery = this.findTrackedQuery(querySpec);
            if (trackedQuery == null) {
                trackedQuery = new TrackedQuery(this.currentQueryId++, querySpec, this.clock.millis(), true, false);
            } else {
                assert (!trackedQuery.complete) : "This should have been handled above!";
                trackedQuery = trackedQuery.setComplete();
            }
            this.saveTrackedQuery(trackedQuery);
        }
    }

    public boolean hasActiveDefaultQuery(Path path) {
        return this.trackedQueryTree.rootMostValueMatching(path, HAS_ACTIVE_DEFAULT_PREDICATE) != null;
    }

    public long countOfPrunableQueries() {
        return this.getQueriesMatching(IS_QUERY_PRUNABLE_PREDICATE).size();
    }

    void verifyCache() {
        List<TrackedQuery> storedTrackedQueries = this.storageLayer.loadTrackedQueries();
        final ArrayList trackedQueries = new ArrayList();
        this.trackedQueryTree.foreach(new ImmutableTree.TreeVisitor<Map<QueryParams, TrackedQuery>, Void>(){

            @Override
            public Void onNodeValue(Path relativePath, Map<QueryParams, TrackedQuery> value, Void accum) {
                for (TrackedQuery trackedQuery : value.values()) {
                    trackedQueries.add(trackedQuery);
                }
                return null;
            }
        });
        Collections.sort(trackedQueries, new Comparator<TrackedQuery>(){

            @Override
            public int compare(TrackedQuery o1, TrackedQuery o2) {
                return Utilities.compareLongs(o1.id, o2.id);
            }
        });
        Utilities.hardAssert(storedTrackedQueries.equals(trackedQueries), "Tracked queries out of sync.  Tracked queries: " + trackedQueries + " Stored queries: " + storedTrackedQueries);
    }

    private boolean includedInDefaultCompleteQuery(Path path) {
        return this.trackedQueryTree.findRootMostMatchingPath(path, HAS_DEFAULT_COMPLETE_PREDICATE) != null;
    }

    private Set<Long> filteredQueryIdsAtPath(Path path) {
        HashSet<Long> ids = new HashSet<Long>();
        Map<QueryParams, TrackedQuery> queries = this.trackedQueryTree.get(path);
        if (queries != null) {
            for (TrackedQuery query : queries.values()) {
                if (query.querySpec.loadsAllData()) continue;
                ids.add(query.id);
            }
        }
        return ids;
    }

    private void cacheTrackedQuery(TrackedQuery query) {
        TrackedQuery existing;
        TrackedQueryManager.assertValidTrackedQuery(query.querySpec);
        Map<QueryParams, TrackedQuery> trackedSet = this.trackedQueryTree.get(query.querySpec.getPath());
        if (trackedSet == null) {
            trackedSet = new HashMap<QueryParams, TrackedQuery>();
            this.trackedQueryTree = this.trackedQueryTree.set(query.querySpec.getPath(), trackedSet);
        }
        Utilities.hardAssert((existing = trackedSet.get(query.querySpec.getParams())) == null || existing.id == query.id);
        trackedSet.put(query.querySpec.getParams(), query);
    }

    private void saveTrackedQuery(TrackedQuery query) {
        this.cacheTrackedQuery(query);
        this.storageLayer.saveTrackedQuery(query);
    }

    private List<TrackedQuery> getQueriesMatching(Predicate<TrackedQuery> predicate) {
        ArrayList<TrackedQuery> matching = new ArrayList<TrackedQuery>();
        for (Map.Entry<Path, Map<QueryParams, TrackedQuery>> entry : this.trackedQueryTree) {
            for (TrackedQuery query : entry.getValue().values()) {
                if (!predicate.evaluate(query)) continue;
                matching.add(query);
            }
        }
        return matching;
    }
}

