/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core.view.filter;

import com.firebase.client.core.Path;
import com.firebase.client.core.view.Change;
import com.firebase.client.core.view.QueryParams;
import com.firebase.client.core.view.filter.ChildChangeAccumulator;
import com.firebase.client.core.view.filter.NodeFilter;
import com.firebase.client.core.view.filter.RangedFilter;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.EmptyNode;
import com.firebase.client.snapshot.Index;
import com.firebase.client.snapshot.IndexedNode;
import com.firebase.client.snapshot.NamedNode;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.PriorityUtilities;
import java.util.Iterator;

public class LimitedFilter
implements NodeFilter {
    private final RangedFilter rangedFilter;
    private final Index index;
    private final int limit;
    private final boolean reverse;

    public LimitedFilter(QueryParams params) {
        this.rangedFilter = new RangedFilter(params);
        this.index = params.getIndex();
        this.limit = params.getLimit();
        this.reverse = !params.isViewFromLeft();
    }

    @Override
    public IndexedNode updateChild(IndexedNode snap, ChildKey key, Node newChild, Path affectedPath, NodeFilter.CompleteChildSource source, ChildChangeAccumulator optChangeAccumulator) {
        if (!this.rangedFilter.matches(new NamedNode(key, newChild))) {
            newChild = EmptyNode.Empty();
        }
        if (snap.getNode().getImmediateChild(key).equals(newChild)) {
            return snap;
        }
        if (snap.getNode().getChildCount() < this.limit) {
            return this.rangedFilter.getIndexedFilter().updateChild(snap, key, newChild, affectedPath, source, optChangeAccumulator);
        }
        return this.fullLimitUpdateChild(snap, key, newChild, source, optChangeAccumulator);
    }

    private IndexedNode fullLimitUpdateChild(IndexedNode oldIndexed, ChildKey childKey, Node childSnap, NodeFilter.CompleteChildSource source, ChildChangeAccumulator optChangeAccumulator) {
        assert (oldIndexed.getNode().getChildCount() == this.limit);
        NamedNode newChildNamedNode = new NamedNode(childKey, childSnap);
        NamedNode windowBoundary = this.reverse ? oldIndexed.getFirstChild() : oldIndexed.getLastChild();
        boolean inRange = this.rangedFilter.matches(newChildNamedNode);
        if (oldIndexed.getNode().hasChild(childKey)) {
            boolean nextChildInRange;
            boolean remainsInWindow;
            Node oldChildSnap = oldIndexed.getNode().getImmediateChild(childKey);
            NamedNode nextChild = source.getChildAfterChild(this.index, windowBoundary, this.reverse);
            while (nextChild != null && (nextChild.getName().equals(childKey) || oldIndexed.getNode().hasChild(nextChild.getName()))) {
                nextChild = source.getChildAfterChild(this.index, nextChild, this.reverse);
            }
            int compareNext = nextChild == null ? 1 : this.index.compare(nextChild, newChildNamedNode, this.reverse);
            boolean bl = remainsInWindow = inRange && !childSnap.isEmpty() && compareNext >= 0;
            if (remainsInWindow) {
                if (optChangeAccumulator != null) {
                    optChangeAccumulator.trackChildChange(Change.childChangedChange(childKey, childSnap, oldChildSnap));
                }
                return oldIndexed.updateChild(childKey, childSnap);
            }
            if (optChangeAccumulator != null) {
                optChangeAccumulator.trackChildChange(Change.childRemovedChange(childKey, oldChildSnap));
            }
            IndexedNode newIndexed = oldIndexed.updateChild(childKey, EmptyNode.Empty());
            boolean bl2 = nextChildInRange = nextChild != null && this.rangedFilter.matches(nextChild);
            if (nextChildInRange) {
                if (optChangeAccumulator != null) {
                    optChangeAccumulator.trackChildChange(Change.childAddedChange(nextChild.getName(), nextChild.getNode()));
                }
                return newIndexed.updateChild(nextChild.getName(), nextChild.getNode());
            }
            return newIndexed;
        }
        if (childSnap.isEmpty()) {
            return oldIndexed;
        }
        if (inRange) {
            if (this.index.compare(windowBoundary, newChildNamedNode, this.reverse) >= 0) {
                if (optChangeAccumulator != null) {
                    optChangeAccumulator.trackChildChange(Change.childRemovedChange(windowBoundary.getName(), windowBoundary.getNode()));
                    optChangeAccumulator.trackChildChange(Change.childAddedChange(childKey, childSnap));
                }
                return oldIndexed.updateChild(childKey, childSnap).updateChild(windowBoundary.getName(), EmptyNode.Empty());
            }
            return oldIndexed;
        }
        return oldIndexed;
    }

    @Override
    public IndexedNode updateFullNode(IndexedNode oldSnap, IndexedNode newSnap, ChildChangeAccumulator optChangeAccumulator) {
        IndexedNode filtered;
        if (newSnap.getNode().isLeafNode() || newSnap.getNode().isEmpty()) {
            filtered = IndexedNode.from(EmptyNode.Empty(), this.index);
        } else {
            int sign;
            NamedNode endPost;
            NamedNode startPost;
            Iterator<NamedNode> iterator;
            filtered = newSnap;
            filtered = filtered.updatePriority(PriorityUtilities.NullPriority());
            if (this.reverse) {
                iterator = newSnap.reverseIterator();
                startPost = this.rangedFilter.getEndPost();
                endPost = this.rangedFilter.getStartPost();
                sign = -1;
            } else {
                iterator = newSnap.iterator();
                startPost = this.rangedFilter.getStartPost();
                endPost = this.rangedFilter.getEndPost();
                sign = 1;
            }
            int count = 0;
            boolean foundStartPost = false;
            while (iterator.hasNext()) {
                boolean inRange;
                NamedNode next = iterator.next();
                if (!foundStartPost && this.index.compare(startPost, next) * sign <= 0) {
                    foundStartPost = true;
                }
                boolean bl = inRange = foundStartPost && count < this.limit && this.index.compare(next, endPost) * sign <= 0;
                if (inRange) {
                    ++count;
                    continue;
                }
                filtered = filtered.updateChild(next.getName(), EmptyNode.Empty());
            }
        }
        return this.rangedFilter.getIndexedFilter().updateFullNode(oldSnap, filtered, optChangeAccumulator);
    }

    @Override
    public IndexedNode updatePriority(IndexedNode oldSnap, Node newPriority) {
        return oldSnap;
    }

    @Override
    public NodeFilter getIndexedFilter() {
        return this.rangedFilter.getIndexedFilter();
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public boolean filtersNodes() {
        return true;
    }
}

