/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.realtime;

import com.firebase.client.core.Context;
import com.firebase.client.core.RepoInfo;
import com.firebase.client.realtime.WebsocketConnection;
import com.firebase.client.utilities.LogWrapper;
import java.util.HashMap;
import java.util.Map;

public class Connection
implements WebsocketConnection.Delegate {
    private static long connectionIds = 0L;
    private static final String REQUEST_TYPE = "t";
    private static final String REQUEST_TYPE_DATA = "d";
    private static final String REQUEST_PAYLOAD = "d";
    private static final String SERVER_ENVELOPE_TYPE = "t";
    private static final String SERVER_DATA_MESSAGE = "d";
    private static final String SERVER_CONTROL_MESSAGE = "c";
    private static final String SERVER_ENVELOPE_DATA = "d";
    private static final String SERVER_CONTROL_MESSAGE_TYPE = "t";
    private static final String SERVER_CONTROL_MESSAGE_SHUTDOWN = "s";
    private static final String SERVER_CONTROL_MESSAGE_RESET = "r";
    private static final String SERVER_CONTROL_MESSAGE_HELLO = "h";
    private static final String SERVER_CONTROL_MESSAGE_DATA = "d";
    private static final String SERVER_HELLO_TIMESTAMP = "ts";
    private static final String SERVER_HELLO_HOST = "h";
    private static final String SERVER_HELLO_SESSION_ID = "s";
    private RepoInfo repoInfo;
    private WebsocketConnection conn;
    private Delegate delegate;
    private State state;
    private LogWrapper logger;

    public Connection(Context ctx, RepoInfo repoInfo, Delegate delegate, String optLastSessionId) {
        long connId = connectionIds++;
        this.repoInfo = repoInfo;
        this.delegate = delegate;
        this.logger = ctx.getLogger("Connection", "conn_" + connId);
        this.state = State.REALTIME_CONNECTING;
        this.conn = new WebsocketConnection(ctx, repoInfo, this, optLastSessionId);
    }

    public void open() {
        if (this.logger.logsDebug()) {
            this.logger.debug("Opening a connection");
        }
        this.conn.open();
    }

    public void close(DisconnectReason reason) {
        if (this.state != State.REALTIME_DISCONNECTED) {
            if (this.logger.logsDebug()) {
                this.logger.debug("closing realtime connection");
            }
            this.state = State.REALTIME_DISCONNECTED;
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
            this.delegate.onDisconnect(reason);
        }
    }

    public void close() {
        this.close(DisconnectReason.OTHER);
    }

    public void sendRequest(Map<String, Object> message) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("t", "d");
        request.put("d", message);
        this.sendData(request);
    }

    @Override
    public void onMessage(Map<String, Object> message) {
        try {
            String messageType = (String)message.get("t");
            if (messageType != null) {
                if (messageType.equals("d")) {
                    Map data = (Map)message.get("d");
                    this.onDataMessage(data);
                } else if (messageType.equals(SERVER_CONTROL_MESSAGE)) {
                    Map data = (Map)message.get("d");
                    this.onControlMessage(data);
                } else if (this.logger.logsDebug()) {
                    this.logger.debug("Ignoring unknown server message type: " + messageType);
                }
            } else {
                if (this.logger.logsDebug()) {
                    this.logger.debug("Failed to parse server message: missing message type:" + message.toString());
                }
                this.close();
            }
        }
        catch (ClassCastException e) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Failed to parse server message: " + e.toString());
            }
            this.close();
        }
    }

    @Override
    public void onDisconnect(boolean wasEverConnected) {
        this.conn = null;
        if (!wasEverConnected && this.state == State.REALTIME_CONNECTING) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Realtime connection failed");
            }
            if (this.repoInfo.isCacheableHost()) {
                // empty if block
            }
        } else if (this.logger.logsDebug()) {
            this.logger.debug("Realtime connection lost");
        }
        this.close();
    }

    private void onDataMessage(Map<String, Object> data) {
        if (this.logger.logsDebug()) {
            this.logger.debug("received data message: " + data.toString());
        }
        this.delegate.onDataMessage(data);
    }

    private void onControlMessage(Map<String, Object> data) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Got control message: " + data.toString());
        }
        try {
            String messageType = (String)data.get("t");
            if (messageType != null) {
                if (messageType.equals("s")) {
                    String reason = (String)data.get("d");
                    this.onConnectionShutdown(reason);
                } else if (messageType.equals(SERVER_CONTROL_MESSAGE_RESET)) {
                    String host = (String)data.get("d");
                    this.onReset(host);
                } else if (messageType.equals("h")) {
                    Map handshakeData = (Map)data.get("d");
                    this.onHandshake(handshakeData);
                } else if (this.logger.logsDebug()) {
                    this.logger.debug("Ignoring unknown control message: " + messageType);
                }
            } else {
                if (this.logger.logsDebug()) {
                    this.logger.debug("Got invalid control message: " + data.toString());
                }
                this.close();
            }
        }
        catch (ClassCastException e) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Failed to parse control message: " + e.toString());
            }
            this.close();
        }
    }

    private void onConnectionShutdown(String reason) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Connection shutdown command received. Shutting down...");
        }
        this.delegate.onKill(reason);
        this.close();
    }

    private void onHandshake(Map<String, Object> handshake) {
        String host;
        long timestamp = (Long)handshake.get(SERVER_HELLO_TIMESTAMP);
        this.repoInfo.internalHost = host = (String)handshake.get("h");
        String sessionId = (String)handshake.get("s");
        if (this.state == State.REALTIME_CONNECTING) {
            this.conn.start();
            this.onConnectionReady(timestamp, sessionId);
        }
    }

    private void onConnectionReady(long timestamp, String sessionId) {
        if (this.logger.logsDebug()) {
            this.logger.debug("realtime connection established");
        }
        this.state = State.REALTIME_CONNECTED;
        this.delegate.onReady(timestamp, sessionId);
    }

    private void onReset(String host) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Got a reset; killing connection to " + this.repoInfo.internalHost + "; Updating internalHost to " + host);
        }
        this.repoInfo.internalHost = host;
        this.close(DisconnectReason.SERVER_RESET);
    }

    private void sendData(Map<String, Object> data) {
        if (this.state != State.REALTIME_CONNECTED) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Tried to send on an unconnected connection");
            }
        } else {
            if (this.logger.logsDebug()) {
                this.logger.debug("Sending data: " + data.toString());
            }
            this.conn.send(data);
        }
    }

    private static enum State {
        REALTIME_CONNECTING,
        REALTIME_CONNECTED,
        REALTIME_DISCONNECTED;

    }

    public static interface Delegate {
        public void onReady(long var1, String var3);

        public void onDataMessage(Map<String, Object> var1);

        public void onDisconnect(DisconnectReason var1);

        public void onKill(String var1);
    }

    public static enum DisconnectReason {
        SERVER_RESET,
        OTHER;

    }
}

