/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.snapshot;

import com.firebase.client.snapshot.LeafNode;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.PriorityUtilities;
import java.util.Map;

public class DeferredValueNode
extends LeafNode<DeferredValueNode> {
    private Map<Object, Object> value;

    public DeferredValueNode(Map<Object, Object> value, Node priority) {
        super(priority);
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getHashString() {
        return this.getPriorityHash() + "deferredValue:" + this.value;
    }

    @Override
    public DeferredValueNode updatePriority(Node priority) {
        assert (PriorityUtilities.isValidPriority(priority));
        return new DeferredValueNode(this.value, priority);
    }

    @Override
    protected LeafNode.LeafType getLeafType() {
        return LeafNode.LeafType.DeferredValue;
    }

    @Override
    protected int compareLeafValues(DeferredValueNode other) {
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof DeferredValueNode)) {
            return false;
        }
        DeferredValueNode otherDeferredValueNode = (DeferredValueNode)other;
        return this.value.equals(otherDeferredValueNode.value) && this.priority.equals(otherDeferredValueNode.priority);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode() + this.priority.hashCode();
    }
}

