/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.snapshot;

import com.firebase.client.snapshot.LeafNode;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.PriorityUtilities;
import com.firebase.client.utilities.Utilities;

public class DoubleNode
extends LeafNode<DoubleNode> {
    private final Double value;

    public DoubleNode(Double value, Node priority) {
        super(priority);
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getHashString() {
        String toHash = this.getPriorityHash();
        toHash = toHash + "number:";
        toHash = toHash + Utilities.doubleToHashString(this.value);
        return toHash;
    }

    @Override
    public DoubleNode updatePriority(Node priority) {
        assert (PriorityUtilities.isValidPriority(priority));
        return new DoubleNode(this.value, priority);
    }

    @Override
    protected LeafNode.LeafType getLeafType() {
        return LeafNode.LeafType.Number;
    }

    @Override
    protected int compareLeafValues(DoubleNode other) {
        return this.value.compareTo(other.value);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof DoubleNode)) {
            return false;
        }
        DoubleNode otherDoubleNode = (DoubleNode)other;
        return this.value.equals(otherDoubleNode.value) && this.priority.equals(otherDoubleNode.priority);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode() + this.priority.hashCode();
    }
}

