/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.snapshot;

import com.firebase.client.core.Path;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.KeyIndex;
import com.firebase.client.snapshot.NamedNode;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.PathIndex;
import com.firebase.client.snapshot.ValueIndex;
import java.util.Comparator;

public abstract class Index
implements Comparator<NamedNode> {
    public abstract boolean isDefinedOn(Node var1);

    public boolean indexedValueChanged(Node oldNode, Node newNode) {
        NamedNode newWrapped;
        NamedNode oldWrapped = new NamedNode(ChildKey.getMinName(), oldNode);
        return this.compare(oldWrapped, newWrapped = new NamedNode(ChildKey.getMinName(), newNode)) != 0;
    }

    public abstract NamedNode makePost(ChildKey var1, Node var2);

    public NamedNode minPost() {
        return NamedNode.getMinNode();
    }

    public abstract NamedNode maxPost();

    public abstract String getQueryDefinition();

    public static Index fromQueryDefinition(String str) {
        if (str.equals(".value")) {
            return ValueIndex.getInstance();
        }
        if (str.equals(".key")) {
            return KeyIndex.getInstance();
        }
        if (str.equals(".priority")) {
            throw new IllegalStateException("queryDefinition shouldn't ever be .priority since it's the default");
        }
        return new PathIndex(new Path(str));
    }

    public int compare(NamedNode one, NamedNode two, boolean reverse) {
        if (reverse) {
            return this.compare(two, one);
        }
        return this.compare(one, two);
    }
}

