/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.snapshot;

import com.firebase.client.snapshot.LeafNode;
import com.firebase.client.snapshot.Node;
import com.firebase.client.utilities.Utilities;

public class LongNode
extends LeafNode<LongNode> {
    private final long value;

    public LongNode(Long value, Node priority) {
        super(priority);
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getHashString() {
        String toHash = this.getPriorityHash();
        toHash = toHash + "number:";
        toHash = toHash + Utilities.doubleToHashString(this.value);
        return toHash;
    }

    @Override
    public LongNode updatePriority(Node priority) {
        return new LongNode(this.value, priority);
    }

    @Override
    protected LeafNode.LeafType getLeafType() {
        return LeafNode.LeafType.Number;
    }

    @Override
    protected int compareLeafValues(LongNode other) {
        return Utilities.compareLongs(this.value, other.value);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof LongNode)) {
            return false;
        }
        LongNode otherLongNode = (LongNode)other;
        return this.value == otherLongNode.value && this.priority.equals(otherLongNode.priority);
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32) + this.priority.hashCode();
    }
}

