/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.snapshot;

import com.firebase.client.core.Path;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.ChildrenNode;
import com.firebase.client.snapshot.EmptyNode;
import com.firebase.client.snapshot.NamedNode;
import java.util.Iterator;

public interface Node
extends Comparable<Node>,
Iterable<NamedNode> {
    public static final ChildrenNode MAX_NODE = new ChildrenNode(){

        @Override
        public int compareTo(Node other) {
            return other == this ? 0 : 1;
        }

        @Override
        public boolean equals(Object other) {
            return other == this;
        }

        @Override
        public Node getPriority() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean hasChild(ChildKey childKey) {
            return false;
        }

        @Override
        public Node getImmediateChild(ChildKey name) {
            if (name.isPriorityChildName()) {
                return this.getPriority();
            }
            return EmptyNode.Empty();
        }

        @Override
        public String toString() {
            return "<Max Node>";
        }
    };

    public boolean isLeafNode();

    public Node getPriority();

    public Node getChild(Path var1);

    public Node getImmediateChild(ChildKey var1);

    public Node updateImmediateChild(ChildKey var1, Node var2);

    public ChildKey getPredecessorChildKey(ChildKey var1);

    public ChildKey getSuccessorChildKey(ChildKey var1);

    public Node updateChild(Path var1, Node var2);

    public Node updatePriority(Node var1);

    public boolean hasChild(ChildKey var1);

    public boolean isEmpty();

    public int getChildCount();

    public Object getValue();

    public Object getValue(boolean var1);

    public String getHash();

    public String getHashString();

    public Iterator<NamedNode> reverseIterator();
}

