/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.utilities;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

public class HttpUtilities {
    public static URI buildUrl(String server, String path, Map<String, String> params) {
        try {
            URI serverURI = new URI(server);
            URI uri = new URI(serverURI.getScheme(), serverURI.getAuthority(), path, null, null);
            String query = null;
            if (params != null) {
                StringBuilder queryBuilder = new StringBuilder();
                boolean first = true;
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (!first) {
                        queryBuilder.append("&");
                    }
                    first = false;
                    queryBuilder.append(URLEncoder.encode(entry.getKey(), "utf-8"));
                    queryBuilder.append("=");
                    queryBuilder.append(URLEncoder.encode(entry.getValue(), "utf-8"));
                }
                query = queryBuilder.toString();
            }
            if (query != null) {
                return new URI(uri.toASCIIString() + "?" + query);
            }
            return uri;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Couldn't build valid auth URI.", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Couldn't build valid auth URI.", e);
        }
    }

    private static void addMethodParams(HttpEntityEnclosingRequestBase request, Map<String, String> params) {
        if (params != null) {
            ArrayList<BasicNameValuePair> postParams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                postParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            try {
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(postParams, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Didn't find utf-8 encoding", e);
            }
        }
    }

    public static HttpUriRequest requestWithType(String server, String path, HttpRequestType type, Map<String, String> urlParams, Map<String, String> requestParams) {
        switch (type) {
            case GET: 
            case DELETE: {
                urlParams = new HashMap<String, String>(urlParams);
                urlParams.putAll(requestParams);
                break;
            }
        }
        if (type == HttpRequestType.DELETE) {
            urlParams.put("_method", "delete");
        }
        URI url = HttpUtilities.buildUrl(server, path, urlParams);
        switch (type) {
            case GET: {
                return new HttpGet(url);
            }
            case POST: {
                HttpPost post = new HttpPost(url);
                if (requestParams != null) {
                    HttpUtilities.addMethodParams((HttpEntityEnclosingRequestBase)post, requestParams);
                }
                return post;
            }
            case DELETE: {
                return new HttpDelete(url);
            }
            case PUT: {
                HttpPut put = new HttpPut(url);
                if (requestParams != null) {
                    HttpUtilities.addMethodParams((HttpEntityEnclosingRequestBase)put, requestParams);
                }
                return put;
            }
        }
        throw new IllegalStateException("Shouldn't reach here!");
    }

    public static enum HttpRequestType {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

