/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.geofire.core;

import com.firebase.geofire.GeoLocation;
import com.firebase.geofire.core.GeoHash;
import com.firebase.geofire.util.Base32Utils;
import com.firebase.geofire.util.GeoUtils;
import java.util.HashSet;
import java.util.Set;

public class GeoHashQuery {
    private final String startValue;
    private final String endValue;

    public GeoHashQuery(String startValue, String endValue) {
        this.startValue = startValue;
        this.endValue = endValue;
    }

    public static GeoHashQuery queryForGeoHash(GeoHash geohash, int bits) {
        String hash = geohash.getGeoHashString();
        int precision = (int)Math.ceil((double)bits / 5.0);
        if (hash.length() < precision) {
            return new GeoHashQuery(hash, hash + "~");
        }
        hash = hash.substring(0, precision);
        String base = hash.substring(0, hash.length() - 1);
        int lastValue = Base32Utils.base32CharToValue(hash.charAt(hash.length() - 1));
        int significantBits = bits - base.length() * 5;
        int unusedBits = 5 - significantBits;
        int startValue = lastValue >> unusedBits << unusedBits;
        int endValue = startValue + (1 << unusedBits);
        String startHash = base + Base32Utils.valueToBase32Char(startValue);
        String endHash = endValue > 31 ? base + "~" : base + Base32Utils.valueToBase32Char(endValue);
        return new GeoHashQuery(startHash, endHash);
    }

    public static Set<GeoHashQuery> queriesAtLocation(GeoLocation location, double radius) {
        boolean didJoin;
        int queryBits = Math.max(1, Utils.bitsForBoundingBox(location, radius));
        int geoHashPrecision = (int)Math.ceil(queryBits / 5);
        double latitude = location.latitude;
        double longitude = location.longitude;
        double latitudeDegrees = radius / 110574.0;
        double latitudeNorth = Math.min(90.0, latitude + latitudeDegrees);
        double latitudeSouth = Math.max(-90.0, latitude - latitudeDegrees);
        double longitudeDeltaNorth = GeoUtils.distanceToLongitudeDegrees(radius, latitudeNorth);
        double longitudeDeltaSouth = GeoUtils.distanceToLongitudeDegrees(radius, latitudeSouth);
        double longitudeDelta = Math.max(longitudeDeltaNorth, longitudeDeltaSouth);
        HashSet<GeoHashQuery> queries = new HashSet<GeoHashQuery>();
        GeoHash geoHash = new GeoHash(latitude, longitude, geoHashPrecision);
        GeoHash geoHashW = new GeoHash(latitude, GeoUtils.wrapLongitude(longitude - longitudeDelta), geoHashPrecision);
        GeoHash geoHashE = new GeoHash(latitude, GeoUtils.wrapLongitude(longitude + longitudeDelta), geoHashPrecision);
        GeoHash geoHashN = new GeoHash(latitudeNorth, longitude, geoHashPrecision);
        GeoHash geoHashNW = new GeoHash(latitudeNorth, GeoUtils.wrapLongitude(longitude - longitudeDelta), geoHashPrecision);
        GeoHash geoHashNE = new GeoHash(latitudeNorth, GeoUtils.wrapLongitude(longitude + longitudeDelta), geoHashPrecision);
        GeoHash geoHashS = new GeoHash(latitudeSouth, longitude, geoHashPrecision);
        GeoHash geoHashSW = new GeoHash(latitudeSouth, GeoUtils.wrapLongitude(longitude - longitudeDelta), geoHashPrecision);
        GeoHash geoHashSE = new GeoHash(latitudeSouth, GeoUtils.wrapLongitude(longitude + longitudeDelta), geoHashPrecision);
        queries.add(GeoHashQuery.queryForGeoHash(geoHash, queryBits));
        queries.add(GeoHashQuery.queryForGeoHash(geoHashE, queryBits));
        queries.add(GeoHashQuery.queryForGeoHash(geoHashW, queryBits));
        queries.add(GeoHashQuery.queryForGeoHash(geoHashN, queryBits));
        queries.add(GeoHashQuery.queryForGeoHash(geoHashNE, queryBits));
        queries.add(GeoHashQuery.queryForGeoHash(geoHashNW, queryBits));
        queries.add(GeoHashQuery.queryForGeoHash(geoHashS, queryBits));
        queries.add(GeoHashQuery.queryForGeoHash(geoHashSE, queryBits));
        queries.add(GeoHashQuery.queryForGeoHash(geoHashSW, queryBits));
        do {
            GeoHashQuery query1 = null;
            GeoHashQuery query2 = null;
            block1: for (GeoHashQuery query : queries) {
                for (GeoHashQuery other : queries) {
                    if (query == other || !query.canJoinWith(other)) continue;
                    query1 = query;
                    query2 = other;
                    continue block1;
                }
            }
            if (query1 != null && query2 != null) {
                queries.remove(query1);
                queries.remove(query2);
                queries.add(query1.joinWith(query2));
                didJoin = true;
                continue;
            }
            didJoin = false;
        } while (didJoin);
        return queries;
    }

    private boolean isPrefix(GeoHashQuery other) {
        return other.endValue.compareTo(this.startValue) >= 0 && other.startValue.compareTo(this.startValue) < 0 && other.endValue.compareTo(this.endValue) < 0;
    }

    private boolean isSuperQuery(GeoHashQuery other) {
        int startCompare = other.startValue.compareTo(this.startValue);
        if (startCompare <= 0) {
            return other.endValue.compareTo(this.endValue) >= 0;
        }
        return false;
    }

    public boolean canJoinWith(GeoHashQuery other) {
        return this.isPrefix(other) || other.isPrefix(this) || this.isSuperQuery(other) || other.isSuperQuery(this);
    }

    public GeoHashQuery joinWith(GeoHashQuery other) {
        if (other.isPrefix(this)) {
            return new GeoHashQuery(this.startValue, other.endValue);
        }
        if (this.isPrefix(other)) {
            return new GeoHashQuery(other.startValue, this.endValue);
        }
        if (this.isSuperQuery(other)) {
            return other;
        }
        if (other.isSuperQuery(this)) {
            return this;
        }
        throw new IllegalArgumentException("Can't join these 2 queries: " + this + ", " + other);
    }

    public boolean containsGeoHash(GeoHash hash) {
        String hashStr = hash.getGeoHashString();
        return this.startValue.compareTo(hashStr) <= 0 && this.endValue.compareTo(hashStr) > 0;
    }

    public String getStartValue() {
        return this.startValue;
    }

    public String getEndValue() {
        return this.endValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoHashQuery that = (GeoHashQuery)o;
        if (!this.endValue.equals(that.endValue)) {
            return false;
        }
        return this.startValue.equals(that.startValue);
    }

    public int hashCode() {
        int result = this.startValue.hashCode();
        result = 31 * result + this.endValue.hashCode();
        return result;
    }

    public String toString() {
        return "GeoHashQuery{startValue='" + this.startValue + '\'' + ", endValue='" + this.endValue + '\'' + '}';
    }

    public static class Utils {
        private Utils() {
        }

        public static double bitsLatitude(double resolution) {
            return Math.min(Math.log(2.000393E7 / resolution) / Math.log(2.0), 110.0);
        }

        public static double bitsLongitude(double resolution, double latitude) {
            double degrees = GeoUtils.distanceToLongitudeDegrees(resolution, latitude);
            return Math.abs(degrees) > 0.0 ? Math.max(1.0, Math.log(360.0 / degrees) / Math.log(2.0)) : 1.0;
        }

        public static int bitsForBoundingBox(GeoLocation location, double size) {
            double latitudeDegreesDelta = GeoUtils.distanceToLatitudeDegrees(size);
            double latitudeNorth = Math.min(90.0, location.latitude + latitudeDegreesDelta);
            double latitudeSouth = Math.max(-90.0, location.latitude - latitudeDegreesDelta);
            int bitsLatitude = (int)Math.floor(Utils.bitsLatitude(size)) * 2;
            int bitsLongitudeNorth = (int)Math.floor(Utils.bitsLongitude(size, latitudeNorth)) * 2 - 1;
            int bitsLongitudeSouth = (int)Math.floor(Utils.bitsLongitude(size, latitudeSouth)) * 2 - 1;
            return Math.min(bitsLatitude, Math.min(bitsLongitudeNorth, bitsLongitudeSouth));
        }
    }
}

