/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.geofire.core;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SimpleFuture<V>
implements Future<V> {
    private V object = null;
    private boolean isSet = false;
    private final Lock lock = new ReentrantLock();
    private final Condition setCondition = this.lock.newCondition();

    public synchronized void put(V object) {
        this.lock.lock();
        try {
            this.object = object;
            this.isSet = true;
            this.setCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.isSet;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            while (!this.isSet) {
                this.setCondition.await();
            }
            V v = this.object;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.lock.lock();
        try {
            while (!this.isSet) {
                if (this.setCondition.await(timeout, unit)) continue;
                throw new TimeoutException();
            }
            V v = this.object;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }
}

