/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.auth;

import com.floragunn.searchguard.action.configupdate.TransportConfigUpdateAction;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auth.AuthDomain;
import com.floragunn.searchguard.auth.AuthenticationBackend;
import com.floragunn.searchguard.auth.AuthorizationBackend;
import com.floragunn.searchguard.auth.HTTPAuthenticator;
import com.floragunn.searchguard.auth.internal.InternalAuthenticationBackend;
import com.floragunn.searchguard.auth.internal.NoOpAuthenticationBackend;
import com.floragunn.searchguard.auth.internal.NoOpAuthorizationBackend;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.ConfigChangeListener;
import com.floragunn.searchguard.filter.SearchGuardRestFilter;
import com.floragunn.searchguard.http.HTTPBasicAuthenticator;
import com.floragunn.searchguard.http.HTTPClientCertAuthenticator;
import com.floragunn.searchguard.http.HTTPHostAuthenticator;
import com.floragunn.searchguard.http.HTTPProxyAuthenticator;
import com.floragunn.searchguard.http.XFFResolver;
import com.floragunn.searchguard.support.LogHelper;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;

public class BackendRegistry
implements ConfigChangeListener {
    protected final ESLogger log = Loggers.getLogger(this.getClass());
    private final Map<String, String> authImplMap = new HashMap<String, String>();
    private final SortedSet<AuthDomain> authDomains = new TreeSet<AuthDomain>();
    private final Set<AuthorizationBackend> authorizers = new HashSet<AuthorizationBackend>();
    private volatile boolean initialized;
    private final TransportConfigUpdateAction tcua;
    private final AdminDNs adminDns;
    private final XFFResolver xffResolver;
    private volatile boolean anonymousAuthEnabled = false;
    private final Settings esSettings;
    private final InternalAuthenticationBackend iab;
    private final AuditLog auditLog;
    private Cache<AuthCredentials, User> userCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).removalListener((RemovalListener)new RemovalListener<AuthCredentials, User>(){

        public void onRemoval(RemovalNotification<AuthCredentials, User> notification) {
            BackendRegistry.this.log.debug("Clear user cache for {} due to {}", new Object[]{((AuthCredentials)notification.getKey()).getUsername(), notification.getCause()});
        }
    }).build();
    private Cache<String, User> userCacheTransport = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).removalListener((RemovalListener)new RemovalListener<String, User>(){

        public void onRemoval(RemovalNotification<String, User> notification) {
            BackendRegistry.this.log.debug("Clear user cache for {} due to {}", new Object[]{notification.getKey(), notification.getCause()});
        }
    }).build();

    @Inject
    public BackendRegistry(Settings settings, RestController controller, TransportConfigUpdateAction tcua, ClusterService cse, AdminDNs adminDns, XFFResolver xffResolver, InternalAuthenticationBackend iab, AuditLog auditLog) {
        tcua.addConfigChangeListener("config", this);
        controller.registerFilter((RestFilter)new SearchGuardRestFilter(this, auditLog));
        this.tcua = tcua;
        this.adminDns = adminDns;
        this.esSettings = settings;
        this.xffResolver = xffResolver;
        this.iab = iab;
        this.auditLog = auditLog;
        this.authImplMap.put("intern_c", InternalAuthenticationBackend.class.getName());
        this.authImplMap.put("intern_z", NoOpAuthorizationBackend.class.getName());
        this.authImplMap.put("internal_c", InternalAuthenticationBackend.class.getName());
        this.authImplMap.put("internal_z", NoOpAuthorizationBackend.class.getName());
        this.authImplMap.put("noop_c", NoOpAuthenticationBackend.class.getName());
        this.authImplMap.put("noop_z", NoOpAuthorizationBackend.class.getName());
        this.authImplMap.put("ldap_c", "com.floragunn.dlic.auth.ldap.backend.LDAPAuthenticationBackend");
        this.authImplMap.put("ldap_z", "com.floragunn.dlic.auth.ldap.backend.LDAPAuthorizationBackend");
        this.authImplMap.put("basic_h", HTTPBasicAuthenticator.class.getName());
        this.authImplMap.put("proxy_h", HTTPProxyAuthenticator.class.getName());
        this.authImplMap.put("clientcert_h", HTTPClientCertAuthenticator.class.getName());
        this.authImplMap.put("kerberos_h", "com.floragunn.dlic.auth.http.kerberos.HTTPSpnegoAuthenticator");
        this.authImplMap.put("jwt_h", "com.floragunn.dlic.auth.http.jwt.HTTPJwtAuthenticator");
        this.authImplMap.put("host_h", HTTPHostAuthenticator.class.getName());
    }

    public void invalidateCache() {
        this.userCache.invalidateAll();
        this.userCacheTransport.invalidateAll();
    }

    private <T> T newInstance(String clazzOrShortcut, String type, Settings settings) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String clazz = clazzOrShortcut;
        if (this.authImplMap.containsKey(clazz + "_" + type)) {
            clazz = this.authImplMap.get(clazz + "_" + type);
        }
        Class<?> t = Class.forName(clazz);
        try {
            Constructor<?> tctor = t.getConstructor(Settings.class);
            return (T)tctor.newInstance(settings);
        }
        catch (Exception e) {
            this.log.warn("Unable to create instance of class {} with (Settings.class) constructor due to {}", (Throwable)e, new Object[]{t, e.toString()});
            Constructor<?> tctor = t.getConstructor(Settings.class, TransportConfigUpdateAction.class);
            return (T)tctor.newInstance(new Object[]{settings, this.tcua});
        }
    }

    @Override
    public void onChange(String event, Settings settings) {
        this.authDomains.clear();
        this.anonymousAuthEnabled = settings.getAsBoolean("searchguard.dynamic.http.anonymous_auth_enabled", Boolean.valueOf(false));
        Map authzDyn = settings.getGroups("searchguard.dynamic.authz");
        for (String ad : authzDyn.keySet()) {
            Settings ads = (Settings)authzDyn.get(ad);
            if (!ads.getAsBoolean("enabled", Boolean.valueOf(true)).booleanValue()) continue;
            try {
                AuthorizationBackend authorizationBackend = (AuthorizationBackend)this.newInstance(ads.get("authorization_backend.type", "noop"), "z", Settings.builder().put(this.esSettings).put(ads.getAsSettings("authorization_backend.config")).build());
                this.authorizers.add(authorizationBackend);
            }
            catch (Exception e) {
                this.log.error("Unable to initialize AuthorizationBackend {} due to {}", (Throwable)e, new Object[]{ad, e.toString()});
            }
        }
        Map dyn = settings.getGroups("searchguard.dynamic.authc");
        for (String ad : dyn.keySet()) {
            Settings ads = (Settings)dyn.get(ad);
            if (!ads.getAsBoolean("enabled", Boolean.valueOf(true)).booleanValue()) continue;
            try {
                String authBackendClazz = ads.get("authentication_backend.type", InternalAuthenticationBackend.class.getName());
                AuthenticationBackend authenticationBackend = authBackendClazz.equals(InternalAuthenticationBackend.class.getName()) || authBackendClazz.equals("internal") || authBackendClazz.equals("intern") ? this.iab : (AuthenticationBackend)this.newInstance(authBackendClazz, "c", Settings.builder().put(this.esSettings).put(ads.getAsSettings("authentication_backend.config")).build());
                String httpAuthenticatorType = ads.get("http_authenticator.type");
                HTTPAuthenticator httpAuthenticator = httpAuthenticatorType == null ? null : (HTTPAuthenticator)this.newInstance(httpAuthenticatorType, "h", Settings.builder().put(this.esSettings).put(ads.getAsSettings("http_authenticator.config")).build());
                this.authDomains.add(new AuthDomain(authenticationBackend, httpAuthenticator, ads.getAsBoolean("http_authenticator.challenge", Boolean.valueOf(true)), ads.getAsInt("order", Integer.valueOf(0))));
            }
            catch (Exception e) {
                this.log.error("Unable to initialize auth domain {} due to {}", (Throwable)e, new Object[]{ad, e.toString()});
            }
        }
        if (this.authDomains.isEmpty()) {
            this.authDomains.add(new AuthDomain(this.iab, new HTTPBasicAuthenticator(Settings.EMPTY), true, 0));
        }
        this.initialized = true;
    }

    @Override
    public void validate(String event, Settings settings) throws ElasticsearchSecurityException {
    }

    public boolean authenticate(TransportRequest request) throws ElasticsearchSecurityException {
        final User user = (User)request.getFromContext((Object)"_sg_user");
        if (user == null) {
            return false;
        }
        if (this.adminDns.isAdmin(user.getName())) {
            return true;
        }
        for (final AuthDomain authDomain : new TreeSet<AuthDomain>(this.authDomains)) {
            User authenticatedUser = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Transport User '{}' is in cache? {} (cache size: {})", new Object[]{user.getName(), this.userCacheTransport.getIfPresent((Object)user.getName()) != null, this.userCacheTransport.size()});
            }
            try {
                try {
                    authenticatedUser = (User)this.userCacheTransport.get((Object)user.getName(), (Callable)new Callable<User>(){

                        @Override
                        public User call() throws Exception {
                            if (BackendRegistry.this.log.isDebugEnabled()) {
                                BackendRegistry.this.log.debug(user.getName() + " not cached, return from backend directly", new Object[0]);
                            }
                            if (authDomain.getBackend().exists(user)) {
                                for (AuthorizationBackend ab : BackendRegistry.this.authorizers) {
                                    try {
                                        ab.fillRoles(user, new AuthCredentials(user.getName(), new String[0]));
                                    }
                                    catch (Exception e) {
                                        BackendRegistry.this.log.error("Problems retrieving roles for {} from {}", new Object[]{user, ab.getClass()});
                                    }
                                }
                                return user;
                            }
                            throw new Exception("no such user " + user.getName());
                        }
                    });
                }
                catch (Exception e) {
                    this.log.error("Unexpected exception {} ", (Throwable)e, new Object[]{e.toString()});
                    throw new ElasticsearchSecurityException(e.toString(), (Throwable)e, new Object[0]);
                }
                if (authenticatedUser == null) {
                    this.log.info("Cannot authenticate user (or add roles) with ad {} due to user is null, try next", new Object[]{authDomain.getOrder()});
                    continue;
                }
                if (this.adminDns.isAdmin(authenticatedUser.getName())) {
                    this.log.error("Cannot authenticate user because admin user is not permitted to login via HTTP", new Object[0]);
                    return false;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("User '{}' is authenticated", new Object[]{authenticatedUser});
                }
                request.putInContext((Object)"_sg_user", (Object)authenticatedUser);
                return true;
            }
            catch (ElasticsearchSecurityException e) {
                this.log.info("Cannot authenticate user (or add roles) with ad {} due to {}, try next", new Object[]{authDomain.getOrder(), e.toString()});
            }
        }
        return false;
    }

    public boolean authenticate(RestRequest request, RestChannel channel) throws ElasticsearchSecurityException {
        String sslPrincipal;
        if (this.log.isTraceEnabled()) {
            this.log.trace(LogHelper.toString((ContextAndHeaderHolder)request), new Object[0]);
        }
        if (this.adminDns.isAdmin(sslPrincipal = (String)request.getFromContext((Object)"_sg_ssl_principal"))) {
            request.putInContext((Object)"_sg_user", (Object)new User(sslPrincipal));
            return true;
        }
        if (!this.isInitialized()) {
            this.log.error("Not yet initialized", new Object[0]);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.SERVICE_UNAVAILABLE, "Search Guard not initialized (SG11)"));
            return false;
        }
        request.putInContext((Object)"_sg_remote_address", (Object)this.xffResolver.resolve(request));
        boolean authenticated = false;
        User authenticatedUser = null;
        AuthCredentials authCredenetials = null;
        HTTPAuthenticator firstChallengingHttpAuthenticator = null;
        for (final AuthDomain authDomain : new TreeSet<AuthDomain>(this.authDomains)) {
            AuthCredentials ac;
            HTTPAuthenticator httpAuthenticator = authDomain.getHttpAuthenticator();
            if (httpAuthenticator == null) continue;
            if (authDomain.isChallenge() && firstChallengingHttpAuthenticator == null) {
                firstChallengingHttpAuthenticator = httpAuthenticator;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Try to extract auth creds from http {} ", new Object[]{httpAuthenticator.getType()});
            }
            try {
                ac = httpAuthenticator.extractCredentials(request);
            }
            catch (Exception e1) {
                this.log.info("{} extracting credentials from {}", (Throwable)e1, new Object[]{e1.toString(), httpAuthenticator.getType()});
                continue;
            }
            authCredenetials = ac;
            if (ac == null) {
                if (this.anonymousAuthEnabled || !authDomain.isChallenge() || !httpAuthenticator.reRequestAuthentication(channel, null)) continue;
                return false;
            }
            if (!ac.isComplete()) {
                if (!httpAuthenticator.reRequestAuthentication(channel, ac)) continue;
                return false;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("User '{}' is in cache? {} (cache size: {})", new Object[]{ac.getUsername(), this.userCache.getIfPresent((Object)ac) != null, this.userCache.size()});
            }
            try {
                try {
                    authenticatedUser = (User)this.userCache.get((Object)ac, (Callable)new Callable<User>(){

                        @Override
                        public User call() throws Exception {
                            if (BackendRegistry.this.log.isDebugEnabled()) {
                                BackendRegistry.this.log.debug(ac.getUsername() + " not cached, return from " + authDomain.getBackend().getType() + " backend directly", new Object[0]);
                            }
                            User authenticatedUser = authDomain.getBackend().authenticate(ac);
                            for (AuthorizationBackend ab : BackendRegistry.this.authorizers) {
                                try {
                                    ab.fillRoles(authenticatedUser, new AuthCredentials(authenticatedUser.getName(), new String[0]));
                                }
                                catch (Exception e) {
                                    BackendRegistry.this.log.error("Problems retrieving roles for {} from {}", new Object[]{authenticatedUser, ab.getClass()});
                                }
                            }
                            return authenticatedUser;
                        }
                    });
                }
                catch (Exception e) {
                    this.log.error("Unexpected exception {} ", (Throwable)e, new Object[]{e.toString()});
                    throw new ElasticsearchSecurityException(e.toString(), (Throwable)e, new Object[0]);
                }
                finally {
                    ac.clearSecrets();
                }
                if (authenticatedUser == null) {
                    this.log.info("Cannot authenticate user (or add roles) with ad {} due to user is null, try next", new Object[]{authDomain.getOrder()});
                    continue;
                }
                if (this.adminDns.isAdmin(authenticatedUser.getName())) {
                    this.log.error("Cannot authenticate user because admin user is not permitted to login via HTTP", new Object[0]);
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN));
                    return false;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("User '{}' is authenticated", new Object[]{authenticatedUser});
                }
                request.putInContext((Object)"_sg_user", (Object)authenticatedUser);
                authenticated = true;
                break;
            }
            catch (ElasticsearchSecurityException e) {
                this.log.info("Cannot authenticate user (or add roles) with ad {} due to {}, try next", new Object[]{authDomain.getOrder(), e.toString()});
            }
        }
        if (!authenticated) {
            if (authCredenetials == null && this.anonymousAuthEnabled) {
                request.putInContext((Object)"_sg_user", (Object)User.ANONYMOUS);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Anonymous User is authenticated", new Object[0]);
                }
                return true;
            }
            if (firstChallengingHttpAuthenticator != null && firstChallengingHttpAuthenticator.reRequestAuthentication(channel, null)) {
                return false;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Authentication finally failed", new Object[0]);
            }
            this.auditLog.logFailedLogin(authCredenetials == null ? null : authCredenetials.getUsername(), request);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.UNAUTHORIZED));
            return false;
        }
        return authenticated;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public void impersonate(TransportRequest tr, TransportChannel channel) throws ElasticsearchSecurityException {
        String impersonatedUser = (String)tr.getHeader("sg_impersonate_as");
        if (Strings.isNullOrEmpty((String)impersonatedUser)) {
            return;
        }
        if (!this.isInitialized()) {
            throw new ElasticsearchSecurityException("Could not check for impersonation because Search Guard is not yet initialized", new Object[0]);
        }
        User origPKIuser = (User)tr.getFromContext((Object)"_sg_user");
        if (origPKIuser == null) {
            throw new ElasticsearchSecurityException("no original PKI user found", new Object[0]);
        }
        User aU = origPKIuser;
        if (this.adminDns.isAdmin(impersonatedUser)) {
            throw new ElasticsearchSecurityException("'" + origPKIuser.getName() + "' is not allowed to impersonate as an adminuser  '" + impersonatedUser + "'", new Object[0]);
        }
        try {
            if (impersonatedUser != null && !this.adminDns.isImpersonationAllowed(new LdapName(origPKIuser.getName()), impersonatedUser)) {
                throw new ElasticsearchSecurityException("'" + origPKIuser.getName() + "' is not allowed to impersonate as '" + impersonatedUser + "'", new Object[0]);
            }
            if (impersonatedUser != null) {
                aU = new User(impersonatedUser);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Impersonate from '{}' to '{}'", new Object[]{origPKIuser.getName(), impersonatedUser});
                }
            }
        }
        catch (InvalidNameException e1) {
            throw new ElasticsearchSecurityException("PKI does not have a valid name ('" + origPKIuser.getName() + "'), should never happen", (Throwable)e1, new Object[0]);
        }
        tr.putInContext((Object)"_sg_user", (Object)Objects.requireNonNull(aU));
    }
}

