/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.auth.internal.InternalAuthenticationBackend;
import com.floragunn.searchguard.configuration.ActionGroupHolder;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.ConfigurationService;
import com.floragunn.searchguard.configuration.DlsFlsRequestValve;
import com.floragunn.searchguard.configuration.PrivilegesEvaluator;
import com.floragunn.searchguard.configuration.SearchGuardSettingsFilter;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class ConfigurationModule
extends AbstractModule {
    protected final ESLogger log = Loggers.getLogger(((Object)((Object)this)).getClass());

    protected void configure() {
        this.bind(AdminDNs.class);
        this.bind(SearchGuardSettingsFilter.class).asEagerSingleton();
        this.bind(ConfigurationService.class).asEagerSingleton();
        this.bind(ActionGroupHolder.class).asEagerSingleton();
        this.bind(PrivilegesEvaluator.class).asEagerSingleton();
        this.bind(InternalAuthenticationBackend.class).asEagerSingleton();
        try {
            Class<?> dlsFlsRequestValve = Class.forName("com.floragunn.searchguard.configuration.DlsFlsValveImpl");
            if (dlsFlsRequestValve == null) {
                throw new ClassNotFoundException();
            }
            this.bind(DlsFlsRequestValve.class).to(dlsFlsRequestValve).asEagerSingleton();
            this.log.info("FLS/DLS valve bound", new Object[0]);
        }
        catch (ClassNotFoundException e) {
            this.bind(DlsFlsRequestValve.class).to(DlsFlsRequestValve.NoopDlsFlsRequestValve.class).asEagerSingleton();
            this.log.info("FLS/DLS valve not bound (noop)", new Object[0]);
        }
    }
}

