/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.searchguard.configuration.PrivilegesEvaluator;
import com.floragunn.searchguard.user.User;
import java.security.cert.X509Certificate;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class SearchGuardInfoAction
extends BaseRestHandler {
    private final Provider<PrivilegesEvaluator> evaluator;

    @Inject
    public SearchGuardInfoAction(Settings settings, RestController controller, Client client, Provider<PrivilegesEvaluator> evaluator) {
        super(settings, controller, client);
        this.evaluator = evaluator;
        controller.registerHandler(RestRequest.Method.GET, "/_searchguard/authinfo", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        BytesRestResponse response = null;
        XContentBuilder builder = channel.newBuilder();
        try {
            X509Certificate[] certs = (X509Certificate[])request.getFromContext((Object)"_sg_ssl_peer_certificates");
            builder.startObject();
            builder.field("user", request.getFromContext((Object)"_sg_user"));
            builder.field("remote_address", request.getFromContext((Object)"_sg_remote_address"));
            builder.field("sg_roles", ((PrivilegesEvaluator)this.evaluator.get()).mapSgRoles((User)request.getFromContext((Object)"_sg_user"), (TransportAddress)request.getFromContext((Object)"_sg_remote_address")));
            builder.field("principal", request.getFromContext((Object)"_sg_ssl_principal"));
            builder.field("peer_certificates", certs != null && certs.length > 0 ? certs.length + "" : "0");
            builder.endObject();
            response = new BytesRestResponse(RestStatus.OK, builder);
        }
        catch (Exception e1) {
            builder.startObject();
            builder.field("error", e1.toString());
            builder.endObject();
            response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
        }
        channel.sendResponse((RestResponse)response);
    }
}

