/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import com.floragunn.searchguard.support.Base64Helper;
import com.google.common.base.Strings;
import java.io.Serializable;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;

public class HeaderHelper {
    public static void checkSGHeader(RestRequest request) {
        if (request != null) {
            for (Object header : request.getHeaders()) {
                if (header == null || !((String)header).trim().toLowerCase().startsWith("_sg_".toLowerCase())) continue;
                throw new ElasticsearchSecurityException("invalid header found", new Object[0]);
            }
            for (Object header : request.headers()) {
                if (header == null || header.getKey() == null || !((String)header.getKey()).trim().toLowerCase().startsWith("_sg_".toLowerCase())) continue;
                throw new ElasticsearchSecurityException("invalid header found", new Object[0]);
            }
        }
    }

    public static void checkSGHeader(TransportMessage<?> request) {
        if (request != null) {
            for (String header : request.getHeaders()) {
                if (header == null || !header.trim().toLowerCase().startsWith("_sg_".toLowerCase())) continue;
                throw new ElasticsearchSecurityException("invalid header found", new Object[0]);
            }
        }
    }

    public static boolean isInterClusterRequest(TransportRequest request) {
        return request.getFromContext((Object)"_sg_ssl_transport_intercluster_request") == Boolean.TRUE;
    }

    public static boolean isDirectRequest(TransportRequest request) {
        return "direct".equals(request.getFromContext((Object)"_sg_channel_type")) || request.remoteAddress() == null;
    }

    public static String getSafeFromHeader(TransportRequest request, String headerName) {
        if (request == null || headerName == null || headerName.isEmpty()) {
            return null;
        }
        String headerValue = null;
        if (!request.hasHeader(headerName) || (headerValue = (String)request.getHeader(headerName)) == null) {
            return null;
        }
        if (HeaderHelper.isInterClusterRequest(request) || HeaderHelper.isDirectRequest(request)) {
            return headerValue;
        }
        return null;
    }

    public static Serializable deserializeSafeFromHeader(TransportRequest request, String headerName) {
        String objectAsBase64 = HeaderHelper.getSafeFromHeader(request, headerName);
        if (!Strings.isNullOrEmpty((String)objectAsBase64)) {
            return Base64Helper.deserializeObject(objectAsBase64);
        }
        return null;
    }
}

