/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class LogHelper {
    private static final ESLogger USER_TRACE_LOGGER = Loggers.getLogger((String)"com.floragunn.searchguard.usertracelogger");

    public static void logUserTrace(String msg, Object ... params) {
        if (USER_TRACE_LOGGER.isTraceEnabled()) {
            String tn = Thread.currentThread().getName();
            if (tn.startsWith("elasticsearch[")) {
                tn = tn.substring(14, tn.indexOf("]", 15));
            }
            USER_TRACE_LOGGER.trace(tn + "::" + msg, params);
        }
    }

    public static String toString(ContextAndHeaderHolder holder) {
        StringBuilder sb = new StringBuilder();
        sb.append("Headers:" + System.lineSeparator());
        for (String key : holder.getHeaders()) {
            sb.append(key + "=" + holder.getHeader(key) + System.lineSeparator());
        }
        sb.append("Context:" + System.lineSeparator());
        for (String key : holder.getContext()) {
            sb.append(key + "=" + holder.getFromContext((Object)key) + System.lineSeparator());
        }
        return sb.toString();
    }
}

