/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import com.google.common.base.Strings;
import io.netty.handler.ssl.OpenSsl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.PluginAwareNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public abstract class AbstractUnitTest {
    @Rule
    public TestName name = new TestName();
    protected final String clustername = "searchguard_ssl_testcluster";
    protected Node esNode1;
    private Node esNode2;
    private Node esNode3;
    private String httpHost = null;
    private int httpPort = -1;
    protected Set<InetSocketTransportAddress> httpAdresses = new HashSet<InetSocketTransportAddress>();
    protected String nodeHost;
    protected int nodePort;
    protected boolean enableHTTPClientSSL = false;
    protected boolean enableHTTPClientSSLv3Only = false;
    protected boolean sendHTTPClientCertificate = false;
    protected boolean trustHTTPServerCertificate = false;
    protected String keystore = "node-0-keystore.jks";
    @Rule
    public final TestWatcher testWatcher = new TestWatcher(){

        protected void starting(Description description) {
            String methodName = description.getMethodName();
            String className = description.getClassName();
            className = className.substring(className.lastIndexOf(46) + 1);
            System.out.println("---------------- Starting JUnit-test: " + className + " " + methodName + " ----------------");
        }

        protected void failed(Throwable e, Description description) {
            String methodName = description.getMethodName();
            String className = description.getClassName();
            className = className.substring(className.lastIndexOf(46) + 1);
            System.out.println(">>>> " + className + " " + methodName + " FAILED due to " + e);
        }

        protected void finished(Description description) {
        }
    };
    protected final ESLogger log = Loggers.getLogger(this.getClass());

    protected AbstractUnitTest() {
    }

    private Settings.Builder getDefaultSettingsBuilder(int nodenum, boolean dataNode, boolean masterNode) {
        return Settings.settingsBuilder().put("node.name", "searchguard_testnode_" + nodenum).put("node.data", dataNode).put("node.master", masterNode).put("cluster.name", "searchguard_ssl_testcluster").put("path.data", "data/data").put("path.work", "data/work").put("path.logs", "data/logs").put("path.conf", "data/config").put("path.plugins", "data/plugins").put("index.number_of_shards", "1").put("index.number_of_replicas", "0").put("http.enabled", true).put("cluster.routing.allocation.disk.watermark.high", "1mb").put("cluster.routing.allocation.disk.watermark.low", "1mb").put("http.cors.enabled", true).put("node.local", false).put("discovery.zen.minimum_master_nodes", 1).put("path.home", ".");
    }

    protected final String getHttpServerUri() {
        String address = "http" + (this.enableHTTPClientSSL ? "s" : "") + "://" + this.httpHost + ":" + this.httpPort;
        this.log.debug("Connect to {}", new Object[]{address});
        return address;
    }

    public final void startES(Settings settings) throws Exception {
        this.startES(settings, 30, 3);
    }

    public final void startES(Settings settings, int timeOutSec, int assertNodes) throws Exception {
        FileUtils.deleteDirectory((File)new File("data"));
        this.esNode1 = new PluginAwareNode(this.getDefaultSettingsBuilder(1, false, true).put(settings == null ? Settings.Builder.EMPTY_SETTINGS : settings).build(), new Class[]{SearchGuardSSLPlugin.class, SearchGuardPlugin.class});
        this.esNode2 = new PluginAwareNode(this.getDefaultSettingsBuilder(2, true, true).put(settings == null ? Settings.Builder.EMPTY_SETTINGS : settings).build(), new Class[]{SearchGuardSSLPlugin.class, SearchGuardPlugin.class});
        this.esNode3 = new PluginAwareNode(this.getDefaultSettingsBuilder(3, true, false).put(settings == null ? Settings.Builder.EMPTY_SETTINGS : settings).build(), new Class[]{SearchGuardSSLPlugin.class, SearchGuardPlugin.class});
        this.esNode1.start();
        this.esNode2.start();
        this.esNode3.start();
        this.waitForCluster(ClusterHealthStatus.GREEN, TimeValue.timeValueSeconds((long)timeOutSec), this.esNode1.client(), assertNodes);
    }

    protected Client client() {
        return this.esNode1.client();
    }

    @Before
    public void setUp() throws Exception {
        this.enableHTTPClientSSL = false;
        this.enableHTTPClientSSLv3Only = false;
    }

    @After
    public void tearDown() throws Exception {
        Thread.sleep(500L);
        if (this.esNode3 != null) {
            this.esNode3.close();
        }
        if (this.esNode2 != null) {
            this.esNode2.close();
        }
        if (this.esNode1 != null) {
            this.esNode1.close();
        }
    }

    protected void waitForGreenClusterState(Client client) throws IOException {
        this.waitForCluster(ClusterHealthStatus.GREEN, TimeValue.timeValueSeconds((long)30L), client, 3);
    }

    protected void waitForCluster(ClusterHealthStatus status, TimeValue timeout, Client client, int assertNodes) throws IOException {
        try {
            this.log.debug("waiting for cluster state {}", new Object[]{status.name()});
            ClusterHealthResponse healthResponse = (ClusterHealthResponse)client.admin().cluster().prepareHealth(new String[0]).setWaitForStatus(status).setTimeout(timeout).setWaitForNodes(String.valueOf(assertNodes)).execute().actionGet();
            if (healthResponse.isTimedOut()) {
                throw new IOException("cluster state is " + healthResponse.getStatus().name() + " with " + healthResponse.getNumberOfNodes() + " nodes");
            }
            this.log.debug("... cluster state ok " + healthResponse.getStatus().name() + " with " + healthResponse.getNumberOfNodes() + " nodes", new Object[0]);
            Assert.assertEquals((long)assertNodes, (long)healthResponse.getNumberOfNodes());
            NodesInfoResponse res = (NodesInfoResponse)this.esNode1.client().admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet();
            NodeInfo[] nodes = (NodeInfo[])res.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                InetSocketTransportAddress is;
                NodeInfo nodeInfo = nodes[i];
                if (nodeInfo.getHttp() != null && nodeInfo.getHttp().address() != null) {
                    is = (InetSocketTransportAddress)nodeInfo.getHttp().address().publishAddress();
                    this.httpPort = is.getPort();
                    this.httpHost = is.getHost();
                    this.httpAdresses.add(is);
                }
                is = (InetSocketTransportAddress)nodeInfo.getTransport().getAddress().publishAddress();
                this.nodePort = is.getPort();
                this.nodeHost = is.getHost();
            }
        }
        catch (ElasticsearchTimeoutException e) {
            throw new IOException("timeout, cluster does not respond to health request, cowardly refusing to continue with operations");
        }
    }

    public File getAbsoluteFilePathFromClassPath(String fileNameFromClasspath) {
        File file = null;
        URL fileUrl = AbstractUnitTest.class.getClassLoader().getResource(fileNameFromClasspath);
        if (fileUrl != null) {
            try {
                file = new File(URLDecoder.decode(fileUrl.getFile(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
            if (file.exists() && file.canRead()) {
                return file;
            }
            this.log.error("Cannot read from {}, maybe the file does not exists? ", new Object[]{file.getAbsolutePath()});
        } else {
            this.log.error("Failed to load " + fileNameFromClasspath, new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executeSimpleRequest(String request) throws Exception {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = this.getHTTPClient();
            response = httpClient.execute((HttpUriRequest)new HttpGet(this.getHttpServerUri() + "/" + request));
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new Exception("Statuscode " + response.getStatusLine().getStatusCode());
            }
            String string = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
    }

    protected HttpResponse executeGetRequest(String request, Header ... header) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpGet(this.getHttpServerUri() + "/" + request), header);
    }

    protected HttpResponse executeHeadRequest(String request, Header ... header) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpHead(this.getHttpServerUri() + "/" + request), header);
    }

    protected HttpResponse executePutRequest(String request, String body, Header ... header) throws Exception {
        HttpPut uriRequest = new HttpPut(this.getHttpServerUri() + "/" + request);
        if (!Strings.isNullOrEmpty((String)body)) {
            uriRequest.setEntity((HttpEntity)new StringEntity(body));
        }
        return this.executeRequest((HttpUriRequest)uriRequest, header);
    }

    protected HttpResponse executePostRequest(String request, String body, Header ... header) throws Exception {
        HttpPost uriRequest = new HttpPost(this.getHttpServerUri() + "/" + request);
        if (!Strings.isNullOrEmpty((String)body)) {
            uriRequest.setEntity((HttpEntity)new StringEntity(body));
        }
        return this.executeRequest((HttpUriRequest)uriRequest, header);
    }

    protected HttpResponse executeDeleteRequest(String request, Header ... header) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpDelete(this.getHttpServerUri() + "/" + request), header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResponse executeRequest(HttpUriRequest uriRequest, Header ... header) throws Exception {
        try (CloseableHttpClient httpClient = null;){
            httpClient = this.getHTTPClient();
            if (header != null && header.length > 0) {
                for (int i = 0; i < header.length; ++i) {
                    Header h = header[i];
                    uriRequest.addHeader(h);
                }
            }
            HttpResponse res = new HttpResponse(httpClient.execute(uriRequest));
            this.log.trace(res.getBody(), new Object[0]);
            HttpResponse httpResponse = res;
            return httpResponse;
        }
    }

    protected final CloseableHttpClient getHTTPClient() throws Exception {
        HttpClientBuilder hcb = HttpClients.custom();
        if (this.enableHTTPClientSSL) {
            this.log.debug("Configure HTTP client with SSL", new Object[0]);
            KeyStore myTrustStore = KeyStore.getInstance("JKS");
            myTrustStore.load(new FileInputStream(this.getAbsoluteFilePathFromClassPath("truststore.jks")), "changeit".toCharArray());
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(this.getAbsoluteFilePathFromClassPath(this.keystore)), "changeit".toCharArray());
            SSLContextBuilder sslContextbBuilder = SSLContexts.custom().useTLS();
            if (this.trustHTTPServerCertificate) {
                sslContextbBuilder.loadTrustMaterial(myTrustStore);
            }
            if (this.sendHTTPClientCertificate) {
                sslContextbBuilder.loadKeyMaterial(keyStore, "changeit".toCharArray());
            }
            SSLContext sslContext = sslContextbBuilder.build();
            String[] protocols = null;
            protocols = this.enableHTTPClientSSLv3Only ? new String[]{"SSLv3"} : new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, protocols, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            hcb.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        hcb.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(60000).build());
        return hcb.build();
    }

    protected final String loadFile(String file) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("/" + file), (Writer)sw, (Charset)StandardCharsets.UTF_8);
        return sw.toString();
    }

    protected BytesReference readYamlContent(String file) {
        try {
            return this.readXContent(new StringReader(this.loadFile(file)), XContentType.YAML);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BytesReference readXContent(Reader reader, XContentType xContentType) throws IOException {
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent((XContentType)xContentType).createParser(reader);
            parser.nextToken();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = builder.bytes();
            return bytesReference;
        }
    }

    public static String encodeBasicHeader(String username, String password) {
        return new String(DatatypeConverter.printBase64Binary((byte[])(username + ":" + Objects.requireNonNull(password)).getBytes(StandardCharsets.UTF_8)));
    }

    static {
        System.out.println("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        System.out.println("Java Version: " + System.getProperty("java.version") + " " + System.getProperty("java.vendor"));
        System.out.println("JVM Impl.: " + System.getProperty("java.vm.version") + " " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name"));
        System.out.println("Open SSL available: " + OpenSsl.isAvailable());
        System.out.println("Open SSL version: " + OpenSsl.versionString());
    }

    protected class HttpResponse {
        private final CloseableHttpResponse inner;
        private final String body;
        private final Header[] header;
        private final int statusCode;
        private final String statusReason;

        public HttpResponse(CloseableHttpResponse inner) throws IllegalStateException, IOException {
            this.inner = inner;
            this.body = inner.getEntity() == null ? null : IOUtils.toString((InputStream)inner.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            this.header = inner.getAllHeaders();
            this.statusCode = inner.getStatusLine().getStatusCode();
            this.statusReason = inner.getStatusLine().getReasonPhrase();
            inner.close();
        }

        public CloseableHttpResponse getInner() {
            return this.inner;
        }

        public String getBody() {
            return this.body;
        }

        public Header[] getHeader() {
            return this.header;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusReason() {
            return this.statusReason;
        }
    }
}

