/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.AbstractUnitTest;
import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.configuration.PrivilegesInterceptorImpl;
import com.floragunn.searchguard.http.HTTPClientCertAuthenticator;
import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import com.floragunn.searchguard.support.ReflectionHelper;
import io.netty.handler.ssl.OpenSsl;
import java.net.InetSocketAddress;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.PluginAwareNode;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.test.rest.FakeRestRequest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SGTests
extends AbstractUnitTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    protected boolean allowOpenSSL = Boolean.parseBoolean(System.getenv("SG_ALLOW_OPENSSL"));

    @Test
    public void testEnsureOpenSSLAvailability() {
        if (this.allowOpenSSL) {
            Assert.assertTrue((String)String.valueOf(OpenSsl.unavailabilityCause()), (boolean)OpenSsl.isAvailable());
        }
    }

    @Test
    public void testDiscoveryWithoutInitialization() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).build();
        this.startES(settings);
        Assert.assertEquals((long)3L, (long)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getStatus());
    }

    @Test
    public void testCustomInterclusterRequestEvaluator() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.cert.intercluster_request_evaluator_class", "com.floragunn.searchguard.AlwaysFalseInterClusterRequestEvaluator").build();
        this.startES(settings, 5, 1);
        Assert.assertEquals((long)1L, (long)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getStatus());
    }

    @Test
    public void testNodeClientDisallowedWithNonServerCertificate() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).build();
        this.startES(settings);
        Assert.assertEquals((long)3L, (long)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getStatus());
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put("node.client", true).put("path.home", ".").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").build();
        this.log.debug("Start node client", new Object[0]);
        try (Node node = new PluginAwareNode(tcSettings, new Class[]{SearchGuardSSLPlugin.class}).start();){
            Assert.assertEquals((long)1L, (long)((NodeInfo[])((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            Assert.assertEquals((long)3L, (long)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        }
    }

    @Test
    public void testNodeClientDisallowedWithNonServerCertificateFull() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).build();
        this.startES(settings);
        Assert.assertEquals((long)3L, (long)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getStatus());
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put("path.home", ".").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").build();
        this.log.debug("Start node client", new Object[0]);
        try (Node node = new PluginAwareNode(tcSettings, new Class[]{SearchGuardSSLPlugin.class, SearchGuardPlugin.class}).start();){
            Assert.assertEquals((long)1L, (long)((NodeInfo[])((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            Assert.assertEquals((long)3L, (long)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        }
    }

    @Test
    public void testNodeClientAllowedWithServerCertificate() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).build();
        this.startES(settings);
        Assert.assertEquals((long)3L, (long)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getStatus());
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put("node.client", true).put("path.home", ".").put(settings).build();
        this.log.debug("Start node client", new Object[0]);
        try (Node node = new PluginAwareNode(tcSettings, new Class[]{SearchGuardSSLPlugin.class}).start();){
            Assert.assertEquals((long)4L, (long)((NodeInfo[])((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            Assert.assertEquals((long)4L, (long)((ClusterHealthResponse)this.client().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        }
    }

    @Test
    public void ensureInitViaRestDoesWork() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.enabled", true).put(new Object[]{"searchguard.ssl.http.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.http.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf"}).build();
        this.startES(settings);
        this.enableHTTPClientSSL = true;
        this.trustHTTPServerCertificate = true;
        this.sendHTTPClientCertificate = true;
        Assert.assertEquals((long)503L, (long)this.executePutRequest("searchguard/config/0", "{}", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("___", ""))}).getStatusCode());
        this.keystore = "kirk-keystore.jks";
        Assert.assertEquals((long)201L, (long)this.executePutRequest("searchguard/config/0", "{}", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("___", ""))}).getStatusCode());
    }

    @Test
    public void testHTTPClientCert() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.enabled", true).put(new Object[]{"searchguard.ssl.http.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.http.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("dummy").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config_clientcert.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("vulcangov").type("kolinahr").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("secrets").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("planet").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("captains").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("students").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("alumni").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("administration").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("praxis").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("legends").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":2}")).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("sf", new String[]{"starfleet", "starfleet_academy", "starfleet_library"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("nonsf", new String[]{"klingonempire", "vulcangov"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("unrestricted", new String[]{"public"})).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        this.enableHTTPClientSSL = true;
        this.trustHTTPServerCertificate = true;
        this.sendHTTPClientCertificate = true;
        this.keystore = "spock-keystore.jks";
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("_search", new Header[0]).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executePutRequest("searchguard/config/0", "{}", new Header[0]).getStatusCode());
        this.keystore = "kirk-keystore.jks";
        Assert.assertEquals((long)200L, (long)this.executePutRequest("searchguard/config/0", "{}", new Header[0]).getStatusCode());
        AbstractUnitTest.HttpResponse res = this.executeGetRequest("_searchguard/authinfo", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
    }

    @Test
    public void testHTTPBasic() throws Exception {
        ConfigUpdateResponse cur3;
        Object cur2;
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("dummy").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("vulcangov").type("kolinahr").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("secrets").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("planet").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("captains").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("students").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("alumni").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("administration").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("praxis").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("legends").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":2}")).actionGet();
            tc.index(new IndexRequest("spock").type("type01").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("kirk").type("type01").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("role01_role02").type("type01").refresh(true).source("{\"content\":1}")).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("sf", new String[]{"starfleet", "starfleet_academy", "starfleet_library"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("nonsf", new String[]{"klingonempire", "vulcangov"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("unrestricted", new String[]{"public"})).actionGet();
            cur2 = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur2.getNodes()).length);
        }
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))}).getStatusCode());
        Assert.assertEquals((long)404L, (long)this.executeGetRequest("searchguard/config/0", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))}).getStatusCode());
        Assert.assertEquals((long)404L, (long)this.executeGetRequest("xxxxyyyy/config/0", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("abc", "abc:abc"))}).getStatusCode());
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("userwithnopassword", ""))}).getStatusCode());
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("userwithblankpassword", ""))}).getStatusCode());
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "wrongpasswd"))}).getStatusCode());
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic wrongheader")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic ")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("picard", "picard"))}).getStatusCode());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "wrongpasswd"))}).getStatusCode());
        }
        Assert.assertEquals((long)200L, (long)this.executePutRequest("/theindex", "{}", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("theindexadmin", "theindexadmin"))}).getStatusCode());
        Assert.assertEquals((long)201L, (long)this.executePutRequest("/theindex/type/1?refresh=true", "{\"a\":0}", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("theindexadmin", "theindexadmin"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("/theindex/_analyze?text=this+is+a+test", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("theindexadmin", "theindexadmin"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executeGetRequest("_analyze?text=this+is+a+test", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("theindexadmin", "theindexadmin"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeDeleteRequest("/theindex", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("theindexadmin", "theindexadmin"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executeDeleteRequest("/klingonempire", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("theindexadmin", "theindexadmin"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executeGetRequest("starfleet/_search", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executeGetRequest("_search", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("starfleet/ships/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executeDeleteRequest("searchguard/", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executePostRequest("/searchguard/_close", null, new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executePostRequest("/searchguard/_upgrade", null, new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executePutRequest("/searchguard/_mapping/config", "{}", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executeGetRequest("searchguard/", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executePutRequest("searchguard/config/2", "{}", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executeGetRequest("searchguard/config/0", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executeDeleteRequest("searchguard/config/0", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executePutRequest("searchguard/config/0", "{}", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        AbstractUnitTest.HttpResponse resc = this.executeGetRequest("_cat/indices/public", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("bug108", "nagilum"))});
        Assert.assertTrue((boolean)resc.getBody().contains("green"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("role01_role02/type01/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("user_role01_role02_role03", "user_role01_role02_role03"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executeGetRequest("role01_role02/type01/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("user_role01", "user_role01"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("spock/type01/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("spock", "spock"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executeGetRequest("spock/type01/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("kirk", "kirk"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("kirk/type01/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("kirk", "kirk"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executePutRequest("_mapping/config", "{\"i\" : [\"4\"]}", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)403L, (long)this.executePostRequest("searchguard/_mget", "{\"ids\" : [\"0\"]}", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("starfleet/ships/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();
        cur2 = null;
        try {
            this.log.debug("Start transport client to init 2", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles_deny.yml"))).actionGet();
            cur3 = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur3.getNodes()).length);
        }
        catch (Throwable cur3) {
            cur2 = cur3;
            throw cur3;
        }
        finally {
            if (tc != null) {
                if (cur2 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable cur3) {
                        ((Throwable)cur2).addSuppressed(cur3);
                    }
                } else {
                    tc.close();
                }
            }
        }
        Assert.assertEquals((long)403L, (long)this.executeGetRequest("starfleet/ships/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();
        cur2 = null;
        try {
            this.log.debug("Start transport client to init 3", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            cur3 = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur3.getNodes()).length);
        }
        catch (Throwable throwable) {
            cur2 = throwable;
            throw throwable;
        }
        finally {
            if (tc != null) {
                if (cur2 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)cur2).addSuppressed(throwable);
                    }
                } else {
                    tc.close();
                }
            }
        }
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("starfleet/ships/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))}).getStatusCode());
        AbstractUnitTest.HttpResponse res = this.executeGetRequest("_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"total\" : 18"));
        Assert.assertTrue((!res.getBody().contains("searchguard") ? 1 : 0) != 0);
        res = this.executeGetRequest("_nodes/stats?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("total_in_bytes"));
        Assert.assertTrue((boolean)res.getBody().contains("max_file_descriptors"));
        Assert.assertTrue((boolean)res.getBody().contains("buffer_pools"));
        Assert.assertFalse((boolean)res.getBody().contains("\"nodes\" : { }"));
        res = this.executePostRequest("*/_upgrade", "", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))});
        System.out.println(res.getBody());
        System.out.println(res.getStatusReason());
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator();
        res = this.executePostRequest("_bulk", bulkBody, new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("writer", "writer"))});
        System.out.println(res.getBody());
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"errors\":false"));
        Assert.assertTrue((boolean)res.getBody().contains("\"status\":201"));
        res = this.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("sg_tenant", "unittesttenant"), new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("sg_tenants"));
        Assert.assertTrue((boolean)res.getBody().contains("unittesttenant"));
        Assert.assertTrue((boolean)res.getBody().contains("\"kltentrw\":true"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_name\":\"worf\""));
        res = this.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("sg_tenants"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_requested_tenant\":null"));
        Assert.assertTrue((boolean)res.getBody().contains("\"kltentrw\":true"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_name\":\"worf\""));
        Assert.assertTrue((PrivilegesInterceptorImpl.count > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConfigHotReload() throws Exception {
        ConfigUpdateResponse cur3;
        AbstractUnitTest.HttpResponse res;
        Object inetSocketTransportAddress2;
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("dummy").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            ConfigUpdateResponse cur2 = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur2.getNodes()).length);
        }
        BasicHeader spock = new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("spock", "spock"));
        for (Object inetSocketTransportAddress2 : this.httpAdresses) {
            res = this.executeRequest((HttpUriRequest)new HttpGet("http://" + inetSocketTransportAddress2.getHost() + ":" + inetSocketTransportAddress2.getPort() + "/_searchguard/authinfo?pretty=true"), new Header[]{spock});
            Assert.assertTrue((boolean)res.getBody().contains("spock"));
            Assert.assertFalse((boolean)res.getBody().contains("additionalrole"));
            Assert.assertTrue((boolean)res.getBody().contains("vulcan"));
        }
        TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();
        inetSocketTransportAddress2 = null;
        try {
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users_spock_add_roles.yml"))).actionGet();
            cur3 = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur3.getNodes()).length);
        }
        catch (Throwable cur3) {
            inetSocketTransportAddress2 = cur3;
            throw cur3;
        }
        finally {
            if (tc != null) {
                if (inetSocketTransportAddress2 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable cur3) {
                        ((Throwable)inetSocketTransportAddress2).addSuppressed(cur3);
                    }
                } else {
                    tc.close();
                }
            }
        }
        for (Object inetSocketTransportAddress2 : this.httpAdresses) {
            this.log.debug("http://" + inetSocketTransportAddress2.getHost() + ":" + inetSocketTransportAddress2.getPort(), new Object[0]);
            res = this.executeRequest((HttpUriRequest)new HttpGet("http://" + inetSocketTransportAddress2.getHost() + ":" + inetSocketTransportAddress2.getPort() + "/_searchguard/authinfo?pretty=true"), new Header[]{spock});
            Assert.assertTrue((boolean)res.getBody().contains("spock"));
            Assert.assertTrue((boolean)res.getBody().contains("additionalrole1"));
            Assert.assertTrue((boolean)res.getBody().contains("additionalrole2"));
            Assert.assertFalse((boolean)res.getBody().contains("starfleet"));
        }
        tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();
        inetSocketTransportAddress2 = null;
        try {
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.index(new IndexRequest("searchguard").type("config").refresh(true).id("0").source(this.readYamlContent("sg_config_host.yml"))).actionGet();
            cur3 = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur3.getNodes()).length);
        }
        catch (Throwable cur4) {
            inetSocketTransportAddress2 = cur4;
            throw cur4;
        }
        finally {
            if (tc != null) {
                if (inetSocketTransportAddress2 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable cur4) {
                        ((Throwable)inetSocketTransportAddress2).addSuppressed(cur4);
                    }
                } else {
                    tc.close();
                }
            }
        }
        for (Object inetSocketTransportAddress2 : this.httpAdresses) {
            res = this.executeRequest((HttpUriRequest)new HttpGet("http://" + inetSocketTransportAddress2.getHost() + ":" + inetSocketTransportAddress2.getPort() + "/_searchguard/authinfo?pretty=true"), new Header[0]);
            this.log.debug(res.getBody(), new Object[0]);
            Assert.assertTrue((boolean)res.getBody().contains("sg_role_host1"));
            Assert.assertTrue((boolean)res.getBody().contains("sg_role_host2"));
            Assert.assertTrue((boolean)res.getBody().contains("sg_host_127.0.0.1"));
            Assert.assertTrue((boolean)res.getBody().contains("roles=[]"));
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
        }
    }

    @Test
    public void testCreateIndex() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).put("index.number_of_shards", 3).put("index.number_of_replicas", 0).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((String)"Expected 3 nodes", (long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("dummy").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("starfleet").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("captains").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("students").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("alumni").refresh(true).source("{\"content\":1}")).actionGet();
            IndicesAliasesResponse r = (IndicesAliasesResponse)tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("sf", new String[]{"starfleet", "starfleet_academy"})).actionGet();
            Assert.assertTrue((String)"Alias creation not acknowledged", (boolean)r.isAcknowledged());
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        Assert.assertEquals((String)"Unable to create index 'nag'", (long)200L, (long)this.executePutRequest("nag1", null, new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))}).getStatusCode());
        Assert.assertEquals((String)"Unable to create index 'starfleet_library'", (long)200L, (long)this.executePutRequest("starfleet_library", null, new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))}).getStatusCode());
        Thread.sleep(2000L);
        this.waitForGreenClusterState(this.esNode1.client());
        Assert.assertEquals((String)"Unable to close index 'starfleet_library'", (long)200L, (long)this.executePostRequest("starfleet_library/_close", null, new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))}).getStatusCode());
        AbstractUnitTest.HttpResponse res = this.executePostRequest("starfleet_library/_open", null, new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))});
        Assert.assertEquals((String)"Unable to open index 'starfleet_library'", (long)200L, (long)res.getStatusCode());
        Assert.assertEquals((String)"open index 'starfleet_library' not acknowledged", (Object)"{\"acknowledged\":true}", (Object)res.getBody());
        this.waitForGreenClusterState(this.esNode1.client());
    }

    @Test
    public void testHTTPProxy() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("dummy").id("0").refresh(true).source(this.readYamlContent("sg_config_proxy.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config_proxy.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("vulcangov").type("kolinahr").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("secrets").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("planet").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("captains").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("students").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("alumni").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("administration").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("praxis").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("legends").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":2}")).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("sf", new String[]{"starfleet", "starfleet_academy", "starfleet_library"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("nonsf", new String[]{"klingonempire", "vulcangov"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("unrestricted", new String[]{"public"})).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum-wrong", "nagilum-wrong"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user-wrong", "scotty"), new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))}).getStatusCode());
        Assert.assertEquals((long)500L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "a"), new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum-wrong", "nagilum-wrong"))}).getStatusCode());
        Assert.assertEquals((long)500L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "a,b,c"), new BasicHeader("x-proxy-user", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("X-Proxy-User", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer")}).getStatusCode());
    }

    @Test
    public void testTransportClient() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf", "nagilum"}).build();
        System.out.println(settings.getAsMap());
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("dummy").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            System.out.println("------- Begin INIT ---------");
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            tc.index(new IndexRequest("starfleet").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        System.out.println("------- INIT complete ---------");
        tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("spock-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "spock").put("path.home", ".").build();
        System.out.println("------- 0 ---------");
        tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).build();
        var4_4 = null;
        try {
            this.log.debug("Start transport client to use", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            System.out.println("------- 1 ---------");
            CreateIndexResponse cir = (CreateIndexResponse)tc.admin().indices().create(new CreateIndexRequest("vulcan")).actionGet();
            Assert.assertTrue((boolean)cir.isAcknowledged());
            System.out.println("------- 2 ---------");
            IndexResponse ir = (IndexResponse)tc.index(new IndexRequest("vulcan").type("secrets").id("s1").refresh(true).source("{\"secret\":true}")).actionGet();
            Assert.assertTrue((boolean)ir.isCreated());
            System.out.println("------- 3 ---------");
            GetResponse gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").setRealtime(Boolean.valueOf(true)).get();
            Assert.assertTrue((boolean)gr.isExists());
            System.out.println("------- 4 ---------");
            gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").setRealtime(Boolean.valueOf(false)).get();
            Assert.assertTrue((boolean)gr.isExists());
            System.out.println("------- 5 ---------");
            SearchResponse actionGet = (SearchResponse)tc.search(new SearchRequest(new String[]{"vulcan"}).types(new String[]{"secrets"})).actionGet();
            Assert.assertEquals((long)1L, (long)actionGet.getHits().getHits().length);
            System.out.println("------- 6 ---------");
            gr = (GetResponse)tc.prepareGet("searchguard", "config", "0").setRealtime(Boolean.valueOf(false)).get();
            Assert.assertFalse((boolean)gr.isExists());
            System.out.println("------- 7 ---------");
            gr = (GetResponse)tc.prepareGet("searchguard", "config", "0").setRealtime(Boolean.valueOf(true)).get();
            Assert.assertFalse((boolean)gr.isExists());
            System.out.println("------- 8 ---------");
            actionGet = (SearchResponse)tc.search(new SearchRequest(new String[]{"searchguard"})).actionGet();
            Assert.assertEquals((long)0L, (long)actionGet.getHits().getHits().length);
            System.out.println("------- 9 ---------");
            try {
                tc.index(new IndexRequest("searchguard").type("config").id("0").source(this.readYamlContent("sg_config.yml"))).actionGet();
                Assert.fail();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            System.out.println("------- 10 ---------");
            try {
                gr = (GetResponse)((GetRequestBuilder)tc.prepareGet("vulcan", "secrets", "s1").putHeader("sg_impersonate_as", (Object)"worf")).get();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertEquals((Object)"no permissions for indices:data/read/get", (Object)e.getMessage());
            }
            System.out.println("------- 11 ---------");
            try {
                gr = (GetResponse)((GetRequestBuilder)tc.prepareGet("vulcan", "secrets", "s1").putHeader("Authorization", (Object)("basic " + SGTests.encodeBasicHeader("worf", "worf")))).get();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertEquals((Object)"no permissions for indices:data/read/get", (Object)e.getMessage());
            }
            System.out.println("------- 12 ---------");
            try {
                gr = (GetResponse)((GetRequestBuilder)tc.prepareGet("vulcan", "secrets", "s1").putHeader("Authorization", (Object)("basic " + SGTests.encodeBasicHeader("worf", "worf111")))).get();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertTrue((boolean)e.getCause().getMessage().contains("password does not match"));
            }
            System.out.println("------- 13 ---------");
            try {
                gr = (GetResponse)((GetRequestBuilder)tc.prepareGet("vulcan", "secrets", "s1").putHeader("sg_impersonate_as", (Object)"gkar")).get();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertEquals((Object)"'CN=spock,OU=client,O=client,L=Test,C=DE' is not allowed to impersonate as 'gkar'", (Object)e.getMessage());
            }
            System.out.println("------- 14 ---------");
            boolean ok = false;
            try {
                gr = (GetResponse)((GetRequestBuilder)tc.prepareGet("vulcan", "secrets", "s1").putHeader("sg_impersonate_as", (Object)"nagilum")).get();
                ok = true;
                gr = (GetResponse)((GetRequestBuilder)((GetRequestBuilder)tc.prepareGet("vulcan", "secrets", "s1").putHeader("sg_impersonate_as", (Object)"nagilum")).putHeader("Authorization", (Object)("basic " + SGTests.encodeBasicHeader("worf", "worf")))).get();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertEquals((Object)"no permissions for indices:data/read/get", (Object)e.getMessage());
                Assert.assertTrue((boolean)ok);
            }
            System.out.println("------- 15 ---------");
            gr = (GetResponse)((GetRequestBuilder)tc.prepareGet("searchguard", "config", "0").putHeader("sg_impersonate_as", (Object)"nagilum")).setRealtime(Boolean.TRUE).get();
            Assert.assertFalse((boolean)gr.isExists());
            Assert.assertTrue((boolean)gr.isSourceEmpty());
            gr = (GetResponse)((GetRequestBuilder)tc.prepareGet("searchguard", "config", "0").putHeader("Authorization", (Object)("basic " + SGTests.encodeBasicHeader("nagilum", "nagilum")))).setRealtime(Boolean.TRUE).get();
            Assert.assertFalse((boolean)gr.isExists());
            Assert.assertTrue((boolean)gr.isSourceEmpty());
            System.out.println("------- 16---------");
            gr = (GetResponse)((GetRequestBuilder)tc.prepareGet("searchguard", "config", "0").putHeader("sg_impersonate_as", (Object)"nagilum")).setRealtime(Boolean.FALSE).get();
            Assert.assertFalse((boolean)gr.isExists());
            Assert.assertTrue((boolean)gr.isSourceEmpty());
            SearchResponse searchRes = (SearchResponse)((SearchRequestBuilder)tc.prepareSearch(new String[]{"starfleet"}).setTypes(new String[]{"ships"}).setScroll(TimeValue.timeValueMinutes((long)5L)).putHeader("sg_impersonate_as", (Object)"nagilum")).get();
            SearchResponse scrollRes = (SearchResponse)((SearchScrollRequestBuilder)tc.prepareSearchScroll(searchRes.getScrollId()).putHeader("sg_impersonate_as", (Object)"worf")).get();
            System.out.println("------- TRC end ---------");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tc != null) {
                if (var4_4 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tc.close();
                }
            }
        }
        System.out.println("------- CTC end ---------");
    }

    public void testHttps() throws Exception {
        this.enableHTTPClientSSL = true;
        this.trustHTTPServerCertificate = true;
        this.sendHTTPClientCertificate = true;
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.http.enforce_clientauth", true).put(new Object[]{"searchguard.ssl.http.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.http.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).build();
        this.startES(settings);
        System.out.println(this.executeSimpleRequest("_searchguard/sslinfo?pretty"));
        Assert.assertTrue((boolean)this.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
        Assert.assertTrue((boolean)this.executeSimpleRequest("_nodes/settings?pretty").contains("searchguard_ssl_testcluster"));
        Assert.assertFalse((boolean)this.executeSimpleRequest("_nodes/settings?pretty").contains("\"searchguard\""));
    }

    @Test
    public void testSpecialUsernames() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("dummy").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("vulcangov").type("kolinahr").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("secrets").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("planet").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("captains").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("students").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("alumni").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("administration").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("praxis").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("legends").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":2}")).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("sf", new String[]{"starfleet", "starfleet_academy", "starfleet_library"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("nonsf", new String[]{"klingonempire", "vulcangov"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("unrestricted", new String[]{"public"})).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("bug.99", "nagilum"))}).getStatusCode());
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("a", "b"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("\"'+-,;_?*@<>!$%&/()=#", "nagilum"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("\u00a7\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df", "nagilum"))}).getStatusCode());
    }

    @Test
    public void testDlsFls() throws Exception {
        Assume.assumeTrue((boolean)ReflectionHelper.canLoad((String)"com.floragunn.searchguard.configuration.SearchGuardFlsDlsIndexSearcherWrapper"));
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("vulcangov").type("kolinahr").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("secrets").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("planet").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("captains").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("students").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("alumni").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("administration").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("praxis").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("legends").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":2}")).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("sf", new String[]{"starfleet", "starfleet_academy", "starfleet_library"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("nonsf", new String[]{"klingonempire", "vulcangov"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("unrestricted", new String[]{"public"})).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[0]).getStatusCode());
        AbstractUnitTest.HttpResponse res = this.executeGetRequest("/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("sarek", "sarek"))});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        Assert.assertTrue((boolean)res.getBody().contains("\"total\" : 1,"));
        Assert.assertTrue((boolean)res.getBody().contains("\"_source\" : { }"));
    }

    @Test
    public void testDlsFlsM() throws Exception {
        Assume.assumeTrue((boolean)ReflectionHelper.canLoad((String)"com.floragunn.searchguard.configuration.SearchGuardFlsDlsIndexSearcherWrapper"));
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            int i;
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            for (i = 0; i < 177; ++i) {
                tc.index(new IndexRequest("company").type("companytype").refresh(true).source("{\"number_of_employees\":3, \"content\":" + i + "}")).actionGet();
            }
            for (i = 0; i < 11; ++i) {
                tc.index(new IndexRequest("article").type("articletype").refresh(true).source("{\"number_of_employees\":3,\"content\":" + i + "}")).actionGet();
            }
            for (i = 0; i < 16; ++i) {
                tc.index(new IndexRequest("investment").type("investmenttype").refresh(true).source("{\"content\":" + i + "}")).actionGet();
            }
            for (i = 0; i < 78; ++i) {
                tc.index(new IndexRequest("investor").type("investortype").refresh(true).source("{\"content\":" + i + "}")).actionGet();
            }
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        String msearch = "{\"index\":\"company\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":0,\"query\":{\"bool\":{\"must\":{\"match_all\":{}},\"must_not\":[],\"filter\":{\"bool\":{\"must\":[{\"query\":{\"query_string\":{\"query\":\"number_of_employees:3\",\"analyze_wildcard\":true}}}]}}}}}" + System.lineSeparator() + "{\"index\":\"company\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":0,\"query\":{\"bool\":{\"must\":{\"match_all\":{}},\"must_not\":[],\"filter\":{\"bool\":{\"must\":[{\"query\":{\"query_string\":{\"query\":\"number_of_employees:3\",\"analyze_wildcard\":true}}}]}}}}}" + System.lineSeparator();
        AbstractUnitTest.HttpResponse resc = this.executePostRequest("_msearch?refresh=true&pretty", msearch, new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("dlsnoinvest", "dlsnoinvest"))});
        System.out.println(resc.getBody());
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((resc.getBody().split("\"total\" : 0,").length == 3 ? 1 : 0) != 0);
        msearch = "{\"index\":\"article\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":0,\"query\":{\"bool\":{\"must\":{\"match_all\":{}},\"must_not\":[],\"filter\":{\"bool\":{\"must\":[{\"range\":{\"number_of_employees\":{\"gte\":3,\"lte\":3,\"format\":\"epoch_millis\"}}}]}}}}}" + System.lineSeparator();
        resc = this.executePostRequest("_msearch?refresh=true&pretty", msearch, new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("dlsnoinvest", "dlsnoinvest"))});
        System.out.println(resc.getBody());
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"total\" : 11,"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"successful\" : 1,"));
    }

    @Test
    public void testHTTPAnon() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("dummy").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config_anon.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("vulcangov").type("kolinahr").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("secrets").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("vulcangov").type("planet").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("captains").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("students").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_academy").type("alumni").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("public").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("starfleet_library").type("administration").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("praxis").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("legends").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("hall_of_fame").refresh(true).source("{\"content\":2}")).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("sf", new String[]{"starfleet", "starfleet_academy", "starfleet_library"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("nonsf", new String[]{"klingonempire", "vulcangov"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("unrestricted", new String[]{"public"})).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "wrong"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))}).getStatusCode());
        AbstractUnitTest.HttpResponse resc = this.executeGetRequest("_searchguard/authinfo", new Header[0]);
        System.out.println(resc.getBody());
        Assert.assertTrue((boolean)resc.getBody().contains("sg_anonymous"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        resc = this.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))});
        System.out.println(resc.getBody());
        Assert.assertTrue((boolean)resc.getBody().contains("nagilum"));
        Assert.assertFalse((boolean)resc.getBody().contains("sg_anonymous"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("_searchguard/authinfo", new Header[0]).getStatusCode());
        Assert.assertEquals((long)401L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "wrong"))}).getStatusCode());
        Assert.assertEquals((long)200L, (long)this.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("nagilum", "nagilum"))}).getStatusCode());
    }

    @Test
    public void testTransportClientImpersonation() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf", "nagilum"}).build();
        System.out.println(settings.getAsMap());
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("dummy").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            System.out.println("------- Begin INIT ---------");
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            tc.index(new IndexRequest("starfleet").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        System.out.println("------- INIT complete ---------");
        tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("spock-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "spock").put("path.home", ".").put("request.headers.sg_impersonate_as", "worf").build();
        System.out.println("------- 0 ---------");
        tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).build();
        var4_4 = null;
        try {
            this.log.debug("Start transport client to use", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            NodesInfoRequest nir = new NodesInfoRequest();
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(nir).actionGet()).getNodes()).length);
            System.out.println("------- TRC end ---------");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tc != null) {
                if (var4_4 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tc.close();
                }
            }
        }
        System.out.println("------- CTC end ---------");
    }

    @Test
    public void testTransportClientImpersonationWildcard() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"*"}).build();
        System.out.println(settings.getAsMap());
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("dummy").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            System.out.println("------- Begin INIT ---------");
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            tc.index(new IndexRequest("starfleet").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        System.out.println("------- INIT complete ---------");
        tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("spock-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "spock").put("path.home", ".").put("request.headers.sg_impersonate_as", "worf").build();
        System.out.println("------- 0 ---------");
        tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).build();
        var4_4 = null;
        try {
            this.log.debug("Start transport client to use", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            NodesInfoRequest nir = new NodesInfoRequest();
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(nir).actionGet()).getNodes()).length);
            System.out.println("------- TRC end ---------");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tc != null) {
                if (var4_4 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tc.close();
                }
            }
        }
        System.out.println("------- CTC end ---------");
    }

    @Test
    public void testFilteredAlias() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("theindex").type("type1").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("theindex").type("type2").refresh(true).source("{\"content\":2}")).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("alias1", (QueryBuilder)QueryBuilders.termQuery((String)"_type", (String)"type1"), new String[]{"theindex"})).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAlias("alias2", (QueryBuilder)QueryBuilders.termQuery((String)"_type", (String)"type2"), new String[]{"theindex"})).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        AbstractUnitTest.HttpResponse resc = this.executeGetRequest("alias*/_search", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))});
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
    }

    @Test
    public void testMultiget() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("mindex1").type("type").id("1").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("mindex2").type("type").id("2").refresh(true).source("{\"content\":2}")).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        String mgetBody = "{\"docs\" : [{\"_index\" : \"mindex1\",\"_type\" : \"type\",\"_id\" : \"1\" }, {\"_index\" : \"mindex2\", \"_type\" : \"type\", \"_id\" : \"2\"}]}";
        AbstractUnitTest.HttpResponse resc = this.executePostRequest("_mget?refresh=true", mgetBody, new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("picard", "picard"))});
        System.out.println(resc.getBody());
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertFalse((boolean)resc.getBody().contains("type2"));
    }

    @Test
    public void testSingle() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("shakespeare").type("type").id("1").refresh(true).source("{\"content\":1}")).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        AbstractUnitTest.HttpResponse resc = this.executeGetRequest("shakespeare/_search", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("picard", "picard"))});
        System.out.println(resc.getBody());
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\":1"));
        resc = this.executeHeadRequest("shakespeare", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("picard", "picard"))});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
    }

    @Test
    public void testComposite() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).putArray("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_composite_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles_composite.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("starfleet").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("klingonempire").type("ships").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("public").type("legends").refresh(true).source("{\"content\":1}")).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        String msearchBody = "{\"index\":\"starfleet\", \"type\":\"ships\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"klingonempire\", \"type\":\"ships\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"public\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}";
        AbstractUnitTest.HttpResponse resc = this.executePostRequest("_msearch?refresh=true", msearchBody, new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("worf", "worf"))});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("\"_index\":\"klingonempire\""));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("hits"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("no permissions for indices:data/read/search"));
    }

    @Test
    public void testIndexTypeEvaluation() throws Exception {
        Settings settings = Settings.settingsBuilder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")}).put(new Object[]{"searchguard.ssl.transport.truststore_filepath", this.getAbsoluteFilePathFromClassPath("truststore.jks")}).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putArray("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"}).build();
        this.startES(settings);
        Settings tcSettings = Settings.builder().put("cluster.name", "searchguard_ssl_testcluster").put(settings).put(new Object[]{"searchguard.ssl.transport.keystore_filepath", this.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")}).put("searchguard.ssl.transport.keystore_alias", "kirk").put("path.home", ".").build();
        try (TransportClient tc = TransportClient.builder().settings(tcSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();){
            this.log.debug("Start transport client to init", new Object[0]);
            tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(this.nodeHost, this.nodePort)));
            Assert.assertEquals((long)3L, (long)((NodeInfo[])((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes()).length);
            tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            tc.index(new IndexRequest("searchguard").type("config").id("0").refresh(true).source(this.readYamlContent("sg_config.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("internalusers").refresh(true).id("0").source(this.readYamlContent("sg_internal_users.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("roles").id("0").refresh(true).source(this.readYamlContent("sg_roles.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("rolesmapping").refresh(true).id("0").source(this.readYamlContent("sg_roles_mapping.yml"))).actionGet();
            tc.index(new IndexRequest("searchguard").type("actiongroups").refresh(true).id("0").source(this.readYamlContent("sg_action_groups.yml"))).actionGet();
            System.out.println("------- End INIT ---------");
            tc.index(new IndexRequest("foo1").type("bar").id("1").refresh(true).source("{\"content\":1}")).actionGet();
            tc.index(new IndexRequest("foo2").type("bar").id("2").refresh(true).source("{\"content\":2}")).actionGet();
            tc.index(new IndexRequest("foo").type("baz").id("3").refresh(true).source("{\"content\":3}")).actionGet();
            tc.index(new IndexRequest("fooba").type("z").id("4").refresh(true).source("{\"content\":4}")).actionGet();
            try {
                tc.index(new IndexRequest("x#a").type("xxx").id("4a").refresh(true).source("{\"content\":4}")).actionGet();
                Assert.fail((String)"Indexname can contain #");
            }
            catch (InvalidIndexNameException invalidIndexNameException) {
                // empty catch block
            }
            try {
                tc.index(new IndexRequest("xa").type("x#a").id("4a").refresh(true).source("{\"content\":4}")).actionGet();
                Assert.fail((String)"Typename can contain #");
            }
            catch (InvalidTypeNameException invalidTypeNameException) {
                // empty catch block
            }
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertEquals((long)3L, (long)((ConfigUpdateResponse.Node[])cur.getNodes()).length);
        }
        AbstractUnitTest.HttpResponse resc = this.executeGetRequest("/foo1/bar/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("baz", "worf"))});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 1"));
        resc = this.executeGetRequest("/foo2/bar/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("baz", "worf"))});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 2"));
        resc = this.executeGetRequest("/foo/baz/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("baz", "worf"))});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 3"));
        resc = this.executeGetRequest("/fooba/z/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("baz", "worf"))});
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = this.executeGetRequest("/foo1/bar/1?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("baz", "worf"))});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"found\" : true"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 1"));
        resc = this.executeGetRequest("/foo2/bar/2?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("baz", "worf"))});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 2"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"found\" : true"));
        resc = this.executeGetRequest("/foo/baz/3?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("baz", "worf"))});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 3"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"found\" : true"));
        resc = this.executeGetRequest("/fooba/z/4?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("baz", "worf"))});
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = this.executeGetRequest("/foo*/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("baz", "worf"))});
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = this.executeGetRequest("/foo*,-fooba/bar/_search?pretty", new Header[]{new BasicHeader("Authorization", "Basic " + SGTests.encodeBasicHeader("baz", "worf"))});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 1"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 2"));
    }

    @Test
    public void testDnParsingCertAuth() throws Exception {
        Settings settings = Settings.settingsBuilder().put("username_attribute", "cn").build();
        HTTPClientCertAuthenticator auth = new HTTPClientCertAuthenticator(settings);
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(this.newSSLRestRequest("cn=abc,l=ert,st=zui,c=qwe")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(this.newSSLRestRequest("CN=abc,L=ert,st=zui,c=qwe")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(this.newSSLRestRequest("l=ert,cn=abc,st=zui,c=qwe")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(this.newSSLRestRequest("L=ert,CN=abc,c,st=zui,c=qwe")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(this.newSSLRestRequest("l=ert,st=zui,c=qwe,cn=abc")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(this.newSSLRestRequest("L=ert,st=zui,c=qwe,CN=abc")).getUsername());
        Assert.assertEquals((Object)"L=ert,st=zui,c=qwe", (Object)auth.extractCredentials(this.newSSLRestRequest("L=ert,st=zui,c=qwe")).getUsername());
        settings = Settings.settingsBuilder().build();
        auth = new HTTPClientCertAuthenticator(settings);
        Assert.assertEquals((Object)"cn=abc,l=ert,st=zui,c=qwe", (Object)auth.extractCredentials(this.newSSLRestRequest("cn=abc,l=ert,st=zui,c=qwe")).getUsername());
    }

    private RestRequest newSSLRestRequest(String sslPrincipal) {
        FakeRestRequest request = new FakeRestRequest();
        request.putInContext((Object)"_sg_ssl_principal", (Object)sslPrincipal);
        return request;
    }

    static {
        System.setProperty("sg.nowarn.client", "true");
    }
}

