/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.transport;

import com.floragunn.searchguard.transport.DefaultInterClusterRequestEvaluator;
import com.floragunn.searchguard.transport.InterClusterRequestEvaluator;
import com.floragunn.searchguard.transport.InterClusterRequestEvaluatorProvider;
import java.security.cert.X509Certificate;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.TransportRequest;
import org.junit.Assert;
import org.junit.Test;

public class InterClusterRequestEvaluatorProviderTest {
    private Settings settings;
    private Provider<InterClusterRequestEvaluator> provider;

    @Test
    public void testUsesDefaultWhenSettingIsMissing() {
        this.givenImplIs(null);
        this.provider = new InterClusterRequestEvaluatorProvider(this.settings);
        Assert.assertTrue((String)"Exp. to use default evaluator when setting is missing", (boolean)(this.provider.get() instanceof DefaultInterClusterRequestEvaluator));
    }

    @Test
    public void testUsesDefaultWhenImplCantBeLoaded() {
        this.givenImplIs("java.lang.String");
        this.provider = new InterClusterRequestEvaluatorProvider(this.settings);
        Assert.assertTrue((String)"Exp. to use default evaluator when implementation can not be loaded", (boolean)(this.provider.get() instanceof DefaultInterClusterRequestEvaluator));
    }

    @Test
    public void testLoadsCustomEvaluator() {
        this.givenImplIs(InterClusterRequestEvaluatorImpl.class.getName());
        this.provider = new InterClusterRequestEvaluatorProvider(this.settings);
        Assert.assertTrue((String)"Exp. to use a custom evaluator when implementation is defined", (boolean)(this.provider.get() instanceof InterClusterRequestEvaluatorImpl));
    }

    private void givenImplIs(String name) {
        Settings.Builder builder = Settings.settingsBuilder();
        if (name != null) {
            builder.put("searchguard.cert.intercluster_request_evaluator_class", name);
        }
        this.settings = builder.build();
    }

    static class InterClusterRequestEvaluatorImpl
    implements InterClusterRequestEvaluator {
        public InterClusterRequestEvaluatorImpl(Settings settings) {
        }

        public boolean isInterClusterRequest(TransportRequest request, X509Certificate[] localCerts, X509Certificate[] peerCerts, String principal) {
            return false;
        }
    }
}

