/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class AggregationTests
extends SingleClusterTest {
    @Test
    public void testBasicAggregations() throws Exception {
        Settings settings = Settings.builder().build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
            tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_academy").type("students").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_library").type("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("klingonempire").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("public").type("legends").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("spock").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("kirk").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("role01_role02").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("xyz").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"xyz"}).alias("alias1"))).actionGet();
        }
        RestHelper.HttpResponse res = rh.executePostRequest("_search?pretty", "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":40}}}}", AggregationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        this.assertNotContains(res, "*xception*");
        this.assertNotContains(res, "*erial*");
        this.assertNotContains(res, "*mpty*");
        this.assertNotContains(res, "*earchguard*");
        this.assertContains(res, "*vulcangov*");
        this.assertContains(res, "*starfleet*");
        this.assertContains(res, "*klingonempire*");
        this.assertContains(res, "*xyz*");
        this.assertContains(res, "*role01_role02*");
        this.assertContains(res, "*\"failed\" : 0*");
        res = rh.executePostRequest("*/_search?pretty", "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":40}}}}", AggregationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        this.assertNotContains(res, "*xception*");
        this.assertNotContains(res, "*erial*");
        this.assertNotContains(res, "*mpty*");
        this.assertNotContains(res, "*earchguard*");
        this.assertContains(res, "*vulcangov*");
        this.assertContains(res, "*starfleet*");
        this.assertContains(res, "*klingonempire*");
        this.assertContains(res, "*xyz*");
        this.assertContains(res, "*role01_role02*");
        this.assertContains(res, "*\"failed\" : 0*");
        res = rh.executePostRequest("_search?pretty", "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":40}}}}", AggregationTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        this.assertNotContains(res, "*xception*");
        this.assertNotContains(res, "*erial*");
        this.assertNotContains(res, "*mpty*");
        this.assertNotContains(res, "*earchguard*");
        this.assertNotContains(res, "*vulcangov*");
        this.assertNotContains(res, "*kirk*");
        this.assertNotContains(res, "*starfleet*");
        this.assertContains(res, "*public*");
        this.assertContains(res, "*xyz*");
        this.assertContains(res, "*\"failed\" : 0*");
        res = rh.executePostRequest("_search?pretty", "{\"size\":0,\"aggs\":{\"myindices\":{\"terms\":{\"field\":\"_index\",\"size\":40}}}}", AggregationTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
    }
}

